/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.parser.CounterNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.SyntaxError;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.prettyprinter;

public class nameNode
extends Node
implements Prettyprintable {
    private opSym symbol;

    public opSym sym() {
        return this.symbol;
    }

    public nameNode() {
    }

    public nameNode(Scope sc) {
        this.setScope(sc);
    }

    public nameNode(opSym s, Scope sc) {
        this.symbol = s;
        this.setScope(sc);
    }

    public nameNode(int kind2, String s, Scope sc) {
        this.make(kind2, new ltoken(s, sc));
        this.setScope(sc);
    }

    public nameNode(int kind2, ltoken tok) {
        this.make(kind2, tok);
        this.setScope(tok.scope());
    }

    public static nameNode makeFunction(String s, int arity, Scope sc) {
        nameNode result = new nameNode(1, new ltoken(s, sc));
        result.setArity(arity);
        return result;
    }

    public static nameNode makeSelection(nameNode dot, nameNode nn) {
        nameNode result = new nameNode(nn.scope());
        if (!dot.isDot() || nn.kind() != 1 && nn.kind() != 0) {
            throw new InternalError("nameNode.makeSelction");
        }
        result.locs(dot, nn);
        result.symbol = new opSym(9, nn.symbol.string());
        return result;
    }

    private nameNode make(int kind2, ltoken tok) {
        this.locs(tok);
        this.setScope(tok.scope());
        this.symbol = new opSym(kind2, tok.toString());
        return this;
    }

    public nameNode id(ltoken id) {
        return this.make(1, id);
    }

    public nameNode inf(ltoken before, ltoken op, ltoken after) {
        this.make(3, op);
        this.locs(before, after);
        return this;
    }

    public nameNode post(ltoken before, ltoken op) {
        this.make(6, op);
        this.loc1(before);
        return this;
    }

    public nameNode pre(ltoken op, ltoken after) {
        this.make(7, op);
        this.loc2(after);
        return this;
    }

    public nameNode op(ltoken op) {
        return this.make(10, op);
    }

    public nameNode mix(ltoken before, ltoken open, CounterNode c, ltoken close, ltoken after) {
        return this.mix(before, open, c.val(), close, after);
    }

    public nameNode mix(ltoken before, ltoken open, int argsBetween, ltoken close, ltoken after) {
        this.locs(open, close);
        if (before != null) {
            this.loc1(before);
        }
        if (after != null) {
            this.loc2(after);
        }
        this.symbol = new opSym(before != null, open.toString(), argsBetween, close.toString(), after != null);
        return this;
    }

    public nameNode mix(boolean before, ltoken open, CounterNode n, ltoken close, boolean after) {
        return this.mix(before, open, n.val(), close, after);
    }

    public nameNode mix(boolean before, ltoken open, int n, ltoken close, boolean after) {
        this.locs(open, close);
        this.symbol = new opSym(before, open.toString(), n, close.toString(), after);
        return this;
    }

    public void sel(ltoken first, ltoken dot, ltoken id) {
        this.locs(first, id);
        this.symbol = new opSym(9, id.toString());
        this.symbol.setSelectionMarker(first == null || !first.loc().equals(dot.loc()));
    }

    public void ite(ltoken iftok, ltoken last) {
        this.locs(iftok, last);
        this.symbol = new opSym(2, iftok.toString());
    }

    public void copy(nameNode nn) {
        this.symbol = nn.symbol;
        this.locs(nn);
    }

    public int arity() {
        return this.symbol.arity();
    }

    public void setArity(int n) {
        this.symbol.setArity(n);
    }

    public String string() {
        return this.symbol.string();
    }

    public boolean equals(Object obj) {
        return obj instanceof nameNode ? this.equals((nameNode)obj) : (obj instanceof opSym ? this.equals((opSym)obj) : false);
    }

    public boolean equals(nameNode nn) {
        return nn != null && this.symbol.similar(nn.symbol);
    }

    public int hashCode() {
        return this.symbol.canBeZeroary() || this.symbol.isSomefix() ? this.symbol.string().hashCode() : this.symbol.hashCode();
    }

    public boolean isEqualityOp() {
        return this.symbol.equals(opSym.eqSym) || this.symbol.equals(opSym.neqSym);
    }

    public boolean isNumeral() {
        return this.symbol.isNumeral();
    }

    public boolean isLogicalOp() {
        return this.symbol.equals(opSym.andSym) || this.symbol.equals(opSym.iffSym) || this.symbol.equals(opSym.impliesSym) || this.symbol.equals(opSym.orSym);
    }

    public boolean isDot() {
        return this.symbol.equals(opSym.dotSym);
    }

    public int kind() {
        return this.symbol.kind();
    }

    public int priority() {
        return this.symbol.priority();
    }

    public nameNode adjust(operatorNode op) throws SyntaxError {
        if (op.sig() == null) {
            throw new InternalError("nameNode.adjust");
        }
        int arity = this.symbol.arity();
        if (arity > 0 && arity != op.arity()) {
            throw new SyntaxError(" too " + (arity < op.arity() ? "few" : "many") + " arguments indicated in operator name " + this);
        }
        if (arity > 0) {
            return this;
        }
        switch (this.kind()) {
            case 1: {
                this.setArity(op.arity());
                return this;
            }
            case 4: {
                return this;
            }
            case 10: {
                break;
            }
            default: {
                throw new InternalError("nameNode.adjust");
            }
        }
        switch (op.arity()) {
            case 0: {
                throw new SyntaxError("illegal name " + this.symbol.string() + " for constant");
            }
            case 1: {
                switch (op.id().kind()) {
                    case 7: {
                        this.symbol.setKind(7);
                        return this;
                    }
                    case 6: 
                    case 9: {
                        this.symbol.setKind(6);
                        return this;
                    }
                }
                throw new SyntaxError("ambiguous whether operator " + this.symbol.string() + " is prefix or postfix");
            }
            case 2: {
                this.symbol.setKind(3);
                return this;
            }
        }
        throw new SyntaxError("illegal name " + this.symbol.string() + " for operator with arity > 2");
    }

    public void addBefore() {
        if (this.symbol.argBefore()) {
            throw new InternalError("nameNode.addBefore");
        }
        int n = this.symbol.arity() - (this.symbol.argAfter() ? 1 : 0);
        this.symbol = new opSym(true, this.symbol.string(), n, this.symbol.closeString(), this.symbol.argAfter());
    }

    public void addAfter() {
        if (this.symbol.argAfter()) {
            throw new InternalError("nameNode.addAfter");
        }
        int n = this.symbol.arity() - (this.symbol.argBefore() ? 1 : 0);
        this.symbol = new opSym(this.symbol.argBefore(), this.symbol.string(), n, this.symbol.closeString(), true);
    }

    public prettyprinter print(prettyprinter pp) {
        return this.symbol.print(pp);
    }
}

