/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;

public class lexer {
    public static final int LT_2CHAR = -1;
    public static final int LT_ALPHA = -2;
    public static final int LT_DIGITS = -3;
    public static final int LT_EOF = -4;
    public static final int LT_EOL = 10;
    public static final int LT_ESCAPE = -5;
    public static final int LT_OP = -6;
    public static final int LT_QUOTE = -7;
    public static final int LT_COMMENT = -8;
    public static final int LT_WHITE = -9;
    public int ltype;
    public String lval;
    public int lexemeLineNo;
    public int lexemeColNo;
    public int lastLineNo;
    public int lastColNo;
    public String file;
    protected short[] ctype = new short[256];
    protected static final short CT_WHITE = 1;
    protected static final short CT_DIGIT = 2;
    protected static final short CT_ALPHA = 4;
    protected static final short CT_QUOTE = 8;
    protected static final short CT_COMMENT = 16;
    protected static final short CT_OPCHAR = 32;
    protected static final short CT_ESCAPE = 64;
    protected static final short CT_DOUBLE = 128;
    protected static final short CT_EOL = 256;
    private boolean whiteP = false;
    private boolean commentP = false;
    private boolean eolP = false;
    private boolean slashSlashP = false;
    private boolean slashStarP = false;
    private boolean reuseLexeme = false;
    private Vector<String> special = new Vector(5);
    private Reader input;
    private char[] buf;
    private int lastChar = -2;
    private int nextChar = -2;
    private int nextLineNo = 1;
    private int nextColNo = 0;
    private int savedLastChar = -2;
    private int savedLastLineNo;
    private int savedLastColNo;
    private int savedNextChar = -2;
    private int savednextLineNo;
    private int savednextColNo;
    private static final int NULLC = -2;

    public lexer(Reader I) {
        this.input = I;
        this.file = "";
        this.buf = new char[20];
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(48, 57);
        this.parseDigits();
        this.whitespaceChars(0, 32);
    }

    public lexer(Reader I, String fileName) {
        this(I);
        this.file = fileName;
    }

    public void resetSyntax() {
        int i = this.ctype.length;
        while (--i >= 0) {
            this.ctype[i] = 0;
        }
        this.whitespaceChars(32, 32);
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > this.ctype.length) {
            hi = this.ctype.length;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (short)(this.ctype[n] | 4);
        }
    }

    public void opChars(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            this.ctype[c] = (short)(this.ctype[c] | 0x20);
            ++i;
        }
    }

    public void escapeChar(char ch) {
        this.ctype[ch] = 64;
    }

    public void quoteChar(int ch) {
        this.ctype[ch] = 8;
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > this.ctype.length) {
            hi = this.ctype.length;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > this.ctype.length) {
            hi = this.ctype.length;
        }
        while (low <= hi) {
            this.ctype[low++] = 0;
        }
        this.ctype[32] = 1;
    }

    public void ordinaryChar(int ch) {
        if (ch != 32) {
            this.ctype[ch] = 0;
        }
    }

    public void commentChar(int ch) {
        this.ctype[ch] = 16;
    }

    public void define(String s) throws InternalError {
        if (s.length() != 2) {
            throw new InternalError("lexer.define");
        }
        char c = s.charAt(0);
        this.ctype[c] = (short)(this.ctype[c] | 0x80);
        if (!this.special.contains(s = s.intern())) {
            this.special.addElement(s);
        }
    }

    public void undefine(String s) {
        this.special.removeElement(s.intern());
    }

    public void parseDigits() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (short)(this.ctype[n] | 2);
        }
    }

    public void reportComments(boolean flag) {
        this.commentP = flag;
    }

    public void reportEOL(boolean flag) {
        this.eolP = flag;
        this.ctype[10] = this.eolP ? 256 : 1;
    }

    public void reportWhitespace(boolean flag) {
        this.whiteP = flag;
    }

    public void slashStarComment(boolean flag) {
        this.slashStarP = flag;
    }

    public void slashSlashComment(boolean flag) {
        this.slashSlashP = flag;
    }

    private void getChar() throws IOException {
        if (this.savedNextChar != -2) {
            this.lastChar = this.savedLastChar;
            this.lastLineNo = this.savedLastLineNo;
            this.lastColNo = this.savedLastColNo;
            this.nextChar = this.savedNextChar;
            this.nextLineNo = this.savednextLineNo;
            this.nextColNo = this.savednextColNo;
            this.savedLastChar = -2;
            this.savedNextChar = -2;
        } else {
            this.lastChar = this.nextChar;
            this.lastLineNo = this.nextLineNo++;
            this.lastColNo = this.nextColNo;
            this.nextChar = this.input.read();
            if (this.lastChar == 10) {
                this.nextColNo = 0;
            }
            ++this.nextColNo;
        }
    }

    private void putbackChar() {
        if (this.savedNextChar != -2) {
            throw new InternalError();
        }
        this.savedNextChar = this.nextChar;
        this.savedLastChar = this.lastChar;
        this.nextChar = this.lastChar;
        this.lastChar = -2;
        this.savednextLineNo = this.nextLineNo;
        this.savednextColNo = this.nextColNo;
        this.savedLastLineNo = this.lastLineNo;
        this.savedLastColNo = this.lastColNo;
        this.nextLineNo = this.lastLineNo;
        this.nextColNo = this.lastColNo;
    }

    public int nextLexeme() throws IOException {
        int ctype;
        if (this.reuseLexeme) {
            this.reuseLexeme = false;
            return this.ltype;
        }
        short[] ct = this.ctype;
        this.lval = null;
        this.lexemeLineNo = this.nextLineNo;
        this.lexemeColNo = this.nextColNo;
        if (this.nextChar == -2) {
            this.getChar();
        }
        if (this.nextChar < 0) {
            this.ltype = -4;
            return -4;
        }
        int n = ctype = this.nextChar < 256 ? ct[this.nextChar] : 4;
        if (this.eolP && (ctype & 0x100) != 0) {
            this.nextChar = -2;
            return 10;
        }
        if ((ctype & 1) != 0) {
            if (this.whiteP) {
                return this.scanMore((short)1);
            }
            do {
                this.getChar();
                if (this.nextChar >= 0) continue;
                this.ltype = -4;
                return -4;
            } while (((ctype = this.nextChar < 256 ? ct[this.nextChar] : 4) & 1) != 0);
        }
        this.lexemeLineNo = this.nextLineNo;
        this.lexemeColNo = this.nextColNo;
        if ((ctype & 0x10) != 0) {
            return this.scanComment("");
        }
        if ((ctype & 0x80) != 0) {
            this.getChar();
            if (this.nextChar >= 0) {
                String s = "" + (char)this.lastChar + (char)this.nextChar;
                if (this.special.contains(s = s.intern())) {
                    this.nextChar = -2;
                    this.lval = s;
                    this.ltype = -1;
                    return -1;
                }
            }
            this.putbackChar();
        }
        if (this.nextChar == 47 && (this.slashSlashP || this.slashStarP)) {
            this.getChar();
            if (this.slashStarP && this.nextChar == 42) {
                return this.scanCComment();
            }
            if (this.slashSlashP && this.nextChar == 47) {
                return this.scanComment("/");
            }
            this.putbackChar();
        }
        if ((ctype & 2) != 0) {
            return this.scanMore((short)2);
        }
        if ((ctype & 0x20) != 0) {
            return this.scanMore((short)32);
        }
        if ((ctype & 4) != 0) {
            return this.scanMore((short)4);
        }
        if ((ctype & 8) != 0) {
            int quote = this.nextChar;
            int i = 0;
            do {
                this.getChar();
                int c = this.nextChar;
                if (c == 92) {
                    this.getChar();
                    switch (this.nextChar) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                        }
                    }
                }
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
            } while (this.nextChar >= 0 && this.nextChar != quote && this.nextChar != 10);
            if (this.nextChar == quote) {
                this.nextChar = -2;
            }
            this.lval = String.valueOf((char)quote) + String.copyValueOf(this.buf, 0, i) + (char)quote;
            return -7;
        }
        if ((ctype & 0x40) != 0) {
            int c = this.nextChar;
            this.getChar();
            int n2 = this.nextChar < 0 ? 1 : (ctype = this.nextChar < 256 ? ct[this.nextChar] : 4);
            if ((ctype & 1) != 0) {
                this.lval = String.valueOf((char)this.nextChar);
                this.ltype = c;
                return this.ltype;
            }
            if ((ctype & 4) != 0) {
                this.scanMore((short)4);
            } else {
                this.lval = String.valueOf((char)this.nextChar);
                this.nextChar = -2;
            }
            this.lval = String.valueOf((char)c) + this.lval;
            this.ltype = -5;
            return -5;
        }
        this.ltype = this.nextChar;
        this.lval = String.valueOf((char)this.nextChar);
        this.nextChar = -2;
        return this.ltype;
    }

    private int scanMore(short moreChars) throws IOException {
        int ctype;
        int i = 0;
        short[] ct = this.ctype;
        boolean doubleStarted = false;
        do {
            String s;
            if (i >= this.buf.length) {
                char[] nb = new char[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                this.buf = nb;
            }
            this.buf[i++] = (char)this.nextChar;
            this.getChar();
            int n = this.nextChar < 0 ? 1 : (ctype = this.nextChar < 256 ? ct[this.nextChar] : 4);
            if (doubleStarted && this.special.contains((s = "" + (char)this.lastChar + (char)this.nextChar).intern())) {
                this.putbackChar();
                --i;
                break;
            }
            boolean bl = doubleStarted = (ctype & 0x80) != 0;
        } while ((ctype & moreChars) != 0);
        this.lval = String.copyValueOf(this.buf, 0, i);
        switch (moreChars) {
            case 2: {
                this.ltype = -3;
                return -3;
            }
            case 32: {
                this.ltype = -6;
                return -6;
            }
            case 1: {
                this.ltype = -9;
                return -9;
            }
        }
        this.ltype = -2;
        return -2;
    }

    private int scanComment(String start) throws IOException {
        this.lval = start;
        while (this.nextChar != 10 && this.nextChar >= 0) {
            if (this.commentP) {
                this.lval = String.valueOf(this.lval) + (char)this.nextChar;
            }
            this.getChar();
        }
        return this.commentP ? (this.ltype = -8) : this.nextLexeme();
    }

    private int scanCComment() throws IOException {
        this.getChar();
        if (this.commentP) {
            this.lval = "/*";
        }
        while (this.nextChar >= 0) {
            this.getChar();
            if (this.commentP) {
                this.lval = String.valueOf(this.lval) + (char)this.nextChar;
            }
            if (this.nextChar != 47 || this.lastChar != 42) continue;
        }
        if (this.nextChar >= 0) {
            this.nextChar = -2;
        }
        return this.commentP ? (this.ltype = -8) : this.nextLexeme();
    }

    public void pushBack() {
        this.reuseLexeme = true;
    }

    public String toString() {
        String ret = "line " + this.lexemeLineNo + (this.lexemeLineNo == this.lastLineNo ? ", column" + (this.lexemeColNo == this.lastColNo ? " " : "s " + this.lexemeColNo + "-") + this.lastColNo : ", column " + this.lexemeColNo + ", to line " + this.lastLineNo + ", column " + this.lastColNo) + ": ";
        switch (this.ltype) {
            case -1: {
                return String.valueOf(ret) + "special  " + this.lval;
            }
            case -2: {
                return String.valueOf(ret) + "alpha    " + this.lval;
            }
            case -3: {
                return String.valueOf(ret) + "digits   " + this.lval;
            }
            case -4: {
                return String.valueOf(ret) + "eof";
            }
            case 10: {
                return String.valueOf(ret) + "eol";
            }
            case -5: {
                return String.valueOf(ret) + "escape   " + this.lval;
            }
            case -6: {
                return String.valueOf(ret) + "operator " + this.lval;
            }
            case -7: {
                return String.valueOf(ret) + "quote    " + this.lval;
            }
            case -9: {
                return String.valueOf(ret) + "white    " + '\'' + this.lval + '\'';
            }
            case -8: {
                return String.valueOf(ret) + "comment  " + this.lval;
            }
        }
        return String.valueOf(ret) + '\'' + (char)this.ltype + '\'';
    }

    public static void main(String[] args) {
        lexer scan = new lexer(new InputStreamReader(System.in));
        scan.wordChars(95, 95);
        scan.parseDigits();
        scan.opChars("!#$&*+-.<=>?@^|~");
        scan.commentChar(37);
        scan.escapeChar('\\');
        scan.define("\\/");
        scan.define("/\\");
        scan.define("__");
        scan.define(":=");
        try {
            while (scan.nextLexeme() != -4) {
                System.out.println(scan.toString());
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

