/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.automaton.declaration;
import com.veromodo.tioa.automaton.schedule;
import com.veromodo.tioa.automaton.stateVariable;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.Abstractify;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.programNode;
import com.veromodo.tioa.parser.statementNode;
import com.veromodo.tioa.parser.statesNode;
import com.veromodo.tioa.parser.withNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class detScheduleNode
extends Node {
    private statesNode states;
    private statementNode[] prog;
    private withNode withBlock = null;

    public statesNode states() {
        return this.states;
    }

    public programNode program() {
        return new programNode(this.prog);
    }

    public withNode withBlock() {
        return this.withBlock;
    }

    public boolean hasWithBlock() {
        return this.withBlock != null;
    }

    public void set(ltoken s, statesNode states, ListNode<statementNode> prog, ltoken od) {
        this.locs(s, od);
        this.states = states;
        this.prog = (statementNode[])prog.toArray(new statementNode[prog.size()]);
    }

    public void set(ltoken s, ListNode<statementNode> prog, ltoken od) {
        this.locs(s, od);
        this.prog = (statementNode[])prog.toArray(new statementNode[prog.size()]);
    }

    public void set(ltoken s, statesNode states, ListNode<statementNode> prog, ltoken od, withNode wn) {
        this.locs(s, od);
        this.states = states;
        this.prog = (statementNode[])prog.toArray(new statementNode[prog.size()]);
        this.withBlock = wn;
    }

    public void set(ltoken s, ListNode<statementNode> prog, ltoken od, withNode wn) {
        this.locs(s, od);
        this.prog = (statementNode[])prog.toArray(new statementNode[prog.size()]);
        this.withBlock = wn;
    }

    public void copy(detScheduleNode s) {
        this.locs(s);
        this.states = s.states;
        this.prog = s.prog;
        this.withBlock = s.withBlock;
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        if (this.states != null) {
            this.states.setScope(s);
        }
        int i = 0;
        while (i < this.prog.length) {
            statementNode node = this.prog[i];
            node.setScope(s);
            if (node.kind() == 1) {
                node.assign().putInSchedule();
            } else if (node.kind() == 5) {
                node.dwhile().putInSchedule();
            } else if (node.kind() == 3) {
                node.cond().putInSchedule();
            } else if (node.kind() == 2) {
                node.loop().putInSchedule();
            }
            ++i;
        }
    }

    public schedule makeAbstract() {
        stateVariable[] statevars = this.states == null ? new stateVariable[]{} : this.states.makeAbstract();
        declaration[] decs = null;
        if (this.withBlock != null) {
            decs = this.withBlock.makeAbstract();
        }
        return new schedule(statevars, (statement[])Abstractify.map((Abstractifiable[])this.prog, (Object[])new statement[this.prog.length]), decs);
    }
}

