/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.Main;
import com.veromodo.tioa.checker.checkVocab;
import com.veromodo.tioa.parser.info;
import com.veromodo.tioa.parser.parser;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.specs;
import com.veromodo.tioa.parser.tioaTokenizer;
import com.veromodo.tioa.parser.vocabKey;
import com.veromodo.tioa.parser.vocabNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Hashtable;

public class builtIns {
    private static info[] defs0 = new info[]{new info("", 3, "NumericOps"), new info("AugmentedReal", 0, "AugmentedReal"), new info("Char", 0, "Character"), new info("Int", 0, "Integer"), new info("Mset", 1, "Multiset"), new info("Nat", 0, "Natural"), new info("Null", 1, "Null"), new info("Real", 0, "Real"), new info("DiscreteReal", 0, "DiscreteReal"), new info("Seq", 1, "Sequence"), new info("Set", 1, "Set"), new info("String", 0, "String")};
    private static Hashtable<vocabKey, String> defs = new Hashtable();

    public static boolean isSort(String s) {
        info inf = builtIns.getInfo(s);
        return inf != null && inf.arity == 0;
    }

    private static String ArrayTemplate(int n) {
        String typeName = "Array[" + builtIns.indices("I", n) + ", E]";
        return "vocabulary Array" + n + " defines " + typeName + "\n" + "  operators\n" + "    __[" + builtIns.blanks(n) + "]: " + typeName + "," + builtIns.indices("I", n) + " -> E\n" + "    assign: " + typeName + ", " + builtIns.indices("I", n) + ", E -> " + typeName + "\n" + "    constant: E -> " + typeName + "\n";
    }

    private static String MapTemplate(int n) {
        String typeName = "Map[" + builtIns.indices("D", n) + ", R]";
        return "vocabulary Map" + n + " defines " + typeName + "\n" + "  operators\n" + "    empty: -> " + typeName + "\n" + "    __[" + builtIns.blanks(n) + "]: " + typeName + ", " + builtIns.indices("D", n) + " -> R\n" + "    update: " + typeName + ", " + builtIns.indices("D", n) + ", R -> " + typeName + "\n" + "    defined: " + typeName + ", " + builtIns.indices("D", n) + " -> Bool\n";
    }

    private static String indices(String s, int n) {
        if (n < 1) {
            throw new InternalError("builtIns.indices");
        }
        String result = String.valueOf(s) + "1";
        int i = 2;
        while (i <= n) {
            result = String.valueOf(result) + ", " + s + n;
            ++i;
        }
        return result;
    }

    private static String blanks(int n) {
        if (n < 1) {
            throw new InternalError("builtIns.blanks");
        }
        String result = "__";
        int i = 2;
        while (i <= n) {
            result = String.valueOf(result) + ", __";
            ++i;
        }
        return result;
    }

    private static boolean addVocab(vocabNode vn) {
        boolean known = false;
        sortNode template = vn.defines();
        if (template != null) {
            vocabKey key = new vocabKey(template.constructor().id().toString(), template.nSubsorts());
            String vocabName = defs.get(key);
            known = vocabName != null;
            defs.put(key, vn.name().toString());
        }
        return !known;
    }

    public static vocabNode getVocab(String id, int arity) {
        vocabKey key = new vocabKey(id, arity);
        String vocabName = defs.get(key);
        if (vocabName != null) {
            return specs.getVocabulary(vocabName);
        }
        String vName = null;
        int i = 0;
        while (vName == null && i < defs0.length) {
            if (id.equals(builtIns.defs0[i].trigger) && arity == builtIns.defs0[i].arity) {
                vName = builtIns.defs0[i].vocabName;
            }
            ++i;
        }
        if (vName == null && arity > 1) {
            if (id.equals("Map")) {
                return builtIns.pseudoVocab("Map", arity);
            }
            if (id.equals("Array")) {
                return builtIns.pseudoVocab("Array", arity);
            }
        }
        return vName == null ? null : builtIns.getVocab(vName);
    }

    public static vocabNode getVocab(String vocabName) {
        vocabNode t = null;
        info inf = builtIns.getInfo(vocabName);
        if (inf == null) {
            return t;
        }
        if (specs.parsedVocabulary(vocabName)) {
            t = specs.getVocabulary(vocabName);
        } else {
            parser scan = builtIns.getParser(vocabName);
            if (scan == null) {
                throw new InternalError("builtIns.getVocab");
            }
            try {
                scan.parse();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalError("builtIns.getVocab: " + e);
            }
            t = specs.getVocabulary(vocabName);
        }
        builtIns.addVocab(t);
        checkVocab.check(t);
        return t;
    }

    public static vocabNode pseudoVocab(String constructorName, int arity) {
        String sourceText;
        int nSubscripts = arity - 1;
        String vocabName = String.valueOf(constructorName) + nSubscripts;
        if (specs.parsedVocabulary(vocabName)) {
            return specs.getVocabulary(vocabName);
        }
        if (constructorName.equals("Array")) {
            sourceText = builtIns.ArrayTemplate(nSubscripts);
        } else if (constructorName.equals("Map")) {
            sourceText = builtIns.MapTemplate(nSubscripts);
        } else {
            return null;
        }
        parser scan = new parser(new tioaTokenizer(new StringReader(sourceText), vocabName));
        if (scan == null) {
            throw new InternalError("builtIns.pseudoVocab");
        }
        try {
            scan.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError("builtIns.pseudoVocab: " + e);
        }
        vocabNode vn = specs.getVocabulary(vocabName);
        if (vn == null || vn.name() == null) {
            System.out.println("pseudoVocab " + vn);
            System.out.println(sourceText);
            throw new InternalError("pseudoVocab " + vocabName);
        }
        builtIns.addVocab(vn);
        checkVocab.check(vn);
        return vn;
    }

    public static parser getParser(String vocabName) {
        info inf = builtIns.getInfo(vocabName);
        if (inf == null) {
            return null;
        }
        String fName = "Builtins/" + vocabName + ".tioa";
        InputStream is = Main.getResourceAsStream(fName);
        if (is == null) {
            throw new InternalError("Couldn't find file " + fName);
        }
        return new parser(new tioaTokenizer(new InputStreamReader(is), fName));
    }

    private static String getVocabName(String trigger, int arity) {
        int i = 0;
        while (i < defs0.length) {
            if (trigger.equals(builtIns.defs0[i].trigger) && arity == builtIns.defs0[i].arity) {
                return builtIns.defs0[i].vocabName;
            }
            ++i;
        }
        if (arity < 2) {
            return null;
        }
        if (trigger.equals("Map")) {
            return "Map" + (arity - 1);
        }
        if (trigger.equals("Array")) {
            return "Array" + (arity - 1);
        }
        return null;
    }

    private static info getInfo(String vocabName) {
        String prefix;
        int i = 0;
        while (i < defs0.length) {
            if (builtIns.defs0[i].vocabName.equals(vocabName)) {
                return defs0[i];
            }
            ++i;
        }
        String string = vocabName.startsWith("Map") ? "Map" : (prefix = vocabName.startsWith("Array") ? "Array" : null);
        if (prefix == null) {
            return null;
        }
        String ns = vocabName.substring(prefix.length());
        try {
            int n = Integer.parseInt(ns);
            if (n < 0) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }
}

