/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.basicAutomatonNode;
import com.veromodo.tioa.parser.compositionNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.termNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.parser.vocabRefNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class automatonDefNode
extends Node {
    private ltoken name;
    private formalNode[] formals;
    private termNode where;
    private vocabRefNode[] imports;
    private Node def;
    private variableNode statesVar;
    private variableNode paramVar;
    private variableNode primedStatesVar;
    private automaton theAutomaton;

    public ltoken name() {
        return this.name;
    }

    public int nFormals() {
        return this.formals.length;
    }

    public formalNode formal(int n) {
        return this.formals[n];
    }

    public termNode where() {
        return this.where;
    }

    public int nImports() {
        return this.imports.length;
    }

    public vocabRefNode imports(int n) {
        return this.imports[n];
    }

    public boolean isComposite() {
        return this.def instanceof compositionNode;
    }

    public basicAutomatonNode basicBody() {
        if (this.isComposite()) {
            throw new InternalError("automatonDefNode.basicBody");
        }
        return (basicAutomatonNode)this.def;
    }

    public compositionNode compositionBody() {
        if (this.isComposite()) {
            return (compositionNode)this.def;
        }
        throw new InternalError("automatonDefNode.compositionBody");
    }

    public variableNode statesVar() {
        if (this.statesVar == null) {
            throw new InternalError("automatonDefNode.statesVar()");
        }
        return this.statesVar;
    }

    public void statesVar(variableNode vn) {
        this.statesVar = vn;
    }

    public variableNode paramVar() {
        if (this.paramVar == null) {
            throw new InternalError("automatonDefNode.paramVar()");
        }
        return this.paramVar;
    }

    public void paramVar(variableNode vn) {
        this.paramVar = vn;
    }

    public variableNode primedStatesVar() {
        if (this.statesVar == null) {
            throw new InternalError("automatonDefNode.primedStatesVar()");
        }
        return this.primedStatesVar;
    }

    public void primedStatesVar(variableNode vn) {
        this.primedStatesVar = vn;
    }

    public automaton makeAbstract() {
        if (this.status() != Node.status.OK) {
            return null;
        }
        if (this.theAutomaton == null) {
            this.theAutomaton = this.isComposite() ? this.compositionBody().makeAbstract(this.name.toString(), this.formals, this.where, this.imports, this.statesVar, this.primedStatesVar) : this.basicBody().makeAbstract(this.name.toString(), this.formals, this.where, this.imports, this.statesVar, this.primedStatesVar);
        }
        return this.theAutomaton;
    }

    public automatonDefNode() {
        this.formals = new formalNode[0];
        this.imports = new vocabRefNode[0];
    }

    public automatonDefNode(ltoken name) {
        this.name = name;
    }

    public void set(ltoken first, ltoken name) {
        this.locs(first, name);
        this.name = name;
    }

    public void set(ltoken key, ltoken name, ListNode<formalNode> f, termNode w) {
        this.locs(key, f);
        this.name = name;
        this.formals = (formalNode[])f.toArray(new formalNode[f.size()]);
        this.where = w;
    }

    public void set(automatonDefNode d) {
        this.locs(d);
        this.name = d.name;
        this.formals = d.formals;
        this.where = d.where;
        this.imports = new vocabRefNode[0];
    }

    public void set(automatonDefNode d, ltoken k, ListNode<vocabRefNode> t) {
        this.locs(d, t);
        this.name = d.name;
        this.formals = d.formals;
        this.where = d.where;
        this.imports = new vocabRefNode[t.size()];
        int n = 0;
        while (n < t.size()) {
            this.imports[n] = vocabRefNode.extract(t, n, k.sym);
            ++n;
        }
    }

    public void def(automatonDefNode d, Node body) {
        this.locs(d, body);
        this.name = d.name;
        this.formals = d.formals;
        this.where = d.where;
        this.imports = d.imports;
        this.def = body;
    }

    public void setScope() {
        Scope s = Scope.root().makeSubscope(Scope.automaticOps, "automaton " + this.name);
        super.setScope(s);
        this.name.setScope(s);
        int n = 0;
        while (n < this.formals.length) {
            this.formals[n].setScope(s);
            ++n;
        }
        if (this.where != null) {
            this.where.setScope(s);
        }
        n = 0;
        while (n < this.imports.length) {
            this.imports[n].setScope(s);
            ++n;
        }
        this.def.setScope(s);
    }
}

