/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortConstructor;
import com.veromodo.tioa.notions.vocabRef;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class vocabulary
extends Unit
implements SPrintable {
    private String vocabId;
    private formal[] formals = new formal[0];
    private sort defTemplate;
    private vocabRef[] imports = new vocabRef[0];
    private sort[] sorts = new sort[0];
    private operator[] operators = new operator[0];
    private factoring opFactors;

    public String name() {
        return this.vocabId;
    }

    public int nFormals() {
        return this.formals.length;
    }

    public formal formal(int n) {
        return this.formals[n];
    }

    public sortConstructor theConstructor() {
        return this.defTemplate == null ? null : this.defTemplate.constructor();
    }

    public int nImports() {
        return this.imports.length;
    }

    public vocabRef imports(int n) {
        return this.imports[n];
    }

    public int nSorts() {
        return this.sorts.length;
    }

    public sort sort(int n) {
        return this.sorts[n];
    }

    public int nOperators() {
        return this.operators.length;
    }

    public operator operator(int n) {
        return this.operators[n];
    }

    public factoring opFactors() {
        return this.opFactors;
    }

    public vocabulary(String vocabId, formal[] formals, String templateName, sort[] templateSorts, vocabRef[] imports, sort[] sorts, operator[] operators, factoring opFactors) {
        this.vocabId = vocabId;
        this.formals = formals;
        this.imports = imports;
        this.sorts = sorts;
        this.operators = operators;
        this.opFactors = opFactors;
        if (templateName != null) {
            sortConstructor con = new sortConstructor(templateName, templateSorts.length);
            this.defTemplate = new sort(con, templateSorts);
        }
    }

    public prettyprinter print(prettyprinter pp) {
        pp.align();
        pp.fill().put("vocabulary").blank().put(this.vocabId);
        if (this.formals.length > 0) {
            pp.blank(0).fill(1).put("(").list(this.formals, ",").put(")");
        }
        if (this.defTemplate != null) {
            pp.blank().put("defines").blank().print(this.defTemplate);
        }
        pp.end().eol();
        if (this.imports.length > 0) {
            pp.fill().put("imports").blank().list(this.imports, ",").end().eol();
        }
        if (this.sorts.length > 0) {
            pp.align().put("types").blank().list(this.sorts, ",").end().eol();
        }
        if (this.operators.length > 0) {
            pp.align().put("operators").blank();
            operator.print(pp, this.operators, this.opFactors).end().eol();
        }
        return pp.end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        int i;
        SList list = SExp.makeSList(SExp.makeSValue("vocabulary"));
        list.add(SExp.makeSValue(this.vocabId));
        if (this.nFormals() > 0) {
            SList list2 = new SList();
            list2.add(SExp.makeSValue("formals"));
            i = 0;
            while (i < this.formals.length) {
                list2.add(this.formals[i].toSValue());
                ++i;
            }
            list.add(list2);
        }
        if (this.defTemplate != null) {
            SList list2a = new SList();
            list2a.add(SExp.makeSValue("defines"));
            list2a.add(this.defTemplate.toSValue());
            list.add(list2a);
        }
        if (this.nImports() > 0) {
            SList list3 = new SList();
            list3.add(SExp.makeSValue("imports"));
            i = 0;
            while (i < this.imports.length) {
                list3.add(this.imports[i].toSValue());
                ++i;
            }
            list.add(list3);
        }
        if (this.nSorts() > 0) {
            SList list4 = new SList();
            list4.add(SExp.makeSValue("sorts"));
            i = 0;
            while (i < this.sorts.length) {
                list4.add(this.sorts[i].toSValue());
                ++i;
            }
            list.add(list4);
        }
        if (this.nOperators() > 0) {
            SList list5 = new SList();
            list5.add(SExp.makeSValue("ops"));
            i = 0;
            while (i < this.operators.length) {
                list5.add(this.operators[i].toSValue());
                ++i;
            }
            list.add(list5);
        }
        return list;
    }
}

