/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class variable
extends Unit
implements SPrintable {
    public static final int AUTOMATON_FORMAL = 1;
    public static final int AGGREGATE_FORMALS = 20;
    public static final int ACTION_FORMAL = 2;
    public static final int AGGREGATE_STATE = 3;
    public static final int PRIMED_AGGREGATE_STATE = 4;
    public static final int STATE = 5;
    public static final int PRIMED_STATE = 6;
    public static final int FREE = 7;
    public static final int AGGREGATE_LOCAL = 8;
    public static final int PRIMED_AGGREGATE_LOCAL = 9;
    public static final int LOCAL = 10;
    public static final int PRIMED_LOCAL = 11;
    public static final int CHOOSE = 12;
    public static final int LOOP = 13;
    public static final int TASK = 14;
    public static final int BOUND = 15;
    public static final int COMPONENT_FORMAL = 16;
    public static final int SCHEDULE_STATE = 17;
    public static final int PROOF_ACTUAL = 18;
    public static final int FUNCTION_FORMAL = 19;
    public static final int lastKind = 20;
    private String id;
    private sort sort;
    private int kind;
    private String asString;
    private int uid;
    private static int nextUid = 0;
    private String scopingInfo;
    private static Hashtable<String, Integer> allVarsHashtable = new Hashtable(30);
    private static Vector<variable> allVarsVector = new Vector(30);
    private static Hashtable<String, HashSet<variable>> allExternalReps = new Hashtable(30);

    public String id() {
        return this.id;
    }

    public sort sort() {
        return this.sort;
    }

    public int kind() {
        return this.kind;
    }

    public String scopingInfo() {
        return this.scopingInfo;
    }

    private static String hashKey(String id, sort s, int k, String sc) {
        return (String.valueOf(id) + ":" + s.toString() + ", k:" + k + ", sc:" + sc).intern();
    }

    public static variable get(int n) {
        int low = 0;
        int high = allVarsVector.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            variable v = allVarsVector.elementAt(mid);
            if (v.uid == n) {
                return v;
            }
            if (v.uid < n) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return null;
    }

    public variable(String id, sort s, int k) {
        this(id, s, k, "");
    }

    public variable(String id, sort s, int k, String sc) {
        if (id.indexOf(" ") > 0 || k < 1 || 20 < k) {
            throw new InternalError("variable.variable");
        }
        if (!(this.kind != 6 && this.kind != 11 && this.kind != 4 && this.kind != 9 || id.endsWith("'"))) {
            throw new InternalError("variable.variable");
        }
        this.id = id;
        this.sort = s;
        this.kind = k;
        this.scopingInfo = sc;
        this.asString = variable.externalRep(id, s);
        String key = variable.hashKey(id, s, k, sc);
        Integer UID = allVarsHashtable.get(key);
        if (UID == null) {
            this.uid = nextUid++;
            allVarsHashtable.put(key, new Integer(this.uid));
            allVarsVector.addElement(this);
            HashSet<variable> externals = allExternalReps.get(this.asString);
            if (externals == null) {
                externals = new HashSet();
                allExternalReps.put(this.asString, externals);
            }
            externals.add(this);
        } else {
            this.uid = UID;
        }
    }

    public variable intern() {
        return allVarsVector.elementAt(allVarsVector.indexOf(this));
    }

    public static String kindAsString(int k) {
        switch (k) {
            case 1: {
                return "automaton parameter";
            }
            case 20: {
                return "aggregate automaton parameter";
            }
            case 2: {
                return "formal action parameter";
            }
            case 3: {
                return "aggregate state variable";
            }
            case 4: {
                return "primed aggregate state variable";
            }
            case 5: {
                return "state variable";
            }
            case 6: {
                return "primed state variable";
            }
            case 7: {
                return "transition or task parameter";
            }
            case 8: {
                return "aggregate local variable";
            }
            case 9: {
                return "primed aggregate local variable";
            }
            case 10: {
                return "local variable";
            }
            case 11: {
                return "primed local variable";
            }
            case 12: {
                return "choose statement variable";
            }
            case 13: {
                return "loop variable";
            }
            case 14: {
                return "task for clause variable";
            }
            case 16: {
                return "component parameter";
            }
            case 17: {
                return "schedule state variable";
            }
            case 18: {
                return "proof action parameter";
            }
            case 19: {
                return "parameter in function definition";
            }
        }
        throw new InternalError("checkAutomaton.varKind " + k);
    }

    public static BitSet initValueKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        return kinds2;
    }

    public static BitSet initiallyKinds() {
        BitSet kinds2 = variable.initValueKinds();
        kinds2.set(3);
        kinds2.set(5);
        return kinds2;
    }

    public static BitSet actionFormalKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(2);
        return kinds2;
    }

    public static BitSet transitionActualKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(8);
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(7);
        kinds2.set(10);
        return kinds2;
    }

    public static BitSet transitionWhereKinds() {
        return variable.transitionActualKinds();
    }

    public static BitSet preconditionKinds() {
        BitSet kinds2 = variable.transitionWhereKinds();
        kinds2.set(3);
        kinds2.set(5);
        return kinds2;
    }

    public static BitSet effectKinds() {
        return variable.preconditionKinds();
    }

    public static BitSet ensuringKinds() {
        BitSet kinds2 = variable.effectKinds();
        kinds2.set(9);
        kinds2.set(4);
        kinds2.set(11);
        kinds2.set(6);
        return kinds2;
    }

    public static BitSet taskKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(14);
        kinds2.set(7);
        return kinds2;
    }

    public static BitSet taskForKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(14);
        return kinds2;
    }

    public static BitSet scheduleKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(8);
        kinds2.set(3);
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(7);
        kinds2.set(10);
        kinds2.set(17);
        kinds2.set(5);
        return kinds2;
    }

    public static BitSet ndrStatesKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(3);
        kinds2.set(5);
        return kinds2;
    }

    public static BitSet invocationKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(7);
        kinds2.set(17);
        kinds2.set(3);
        kinds2.set(5);
        kinds2.set(18);
        return kinds2;
    }

    public static BitSet proofKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(3);
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(5);
        kinds2.set(18);
        return kinds2;
    }

    public static BitSet correspKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(18);
        return kinds2;
    }

    public static BitSet componentKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(16);
        return kinds2;
    }

    public static BitSet hiddenKinds() {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(20);
        kinds2.set(7);
        return kinds2;
    }

    public variable makeDifferentInternal(int kind2) {
        if (kind2 == 5 || kind2 == 10) {
            throw new InternalError("variable.makeDifferentInternal");
        }
        String info2 = "version " + (this.scopingInfo.indexOf("version ") == 0 ? Integer.parseInt(this.scopingInfo.substring(8)) + 1 : 1);
        return new variable(this.id, this.sort, this.kind, info2);
    }

    public String makeFreshExternalID() {
        return this.makeFreshExternalID(null);
    }

    public String makeFreshExternalID(HashSet<String> avoidReps) {
        String newID;
        String externalRep;
        HashSet<variable> externals;
        int i = 0;
        while ((externals = allExternalReps.get(externalRep = variable.externalRep(newID = this.kind == 6 || this.kind == 11 || this.kind == 4 || this.kind == 9 ? String.valueOf(this.id.substring(0, this.id.length() - 1)) + i++ + "'" : String.valueOf(this.id) + i++, this.sort))) != null && !externals.isEmpty() || avoidReps != null && avoidReps.contains(newID)) {
        }
        return newID;
    }

    public variable makeDifferentExternal() {
        if (this.kind == 5 || this.kind == 10) {
            throw new InternalError("variable.makeDifferentExternal: " + variable.kindAsString(this.kind) + " " + this);
        }
        return this.makeDifferentExternal(this.scopingInfo);
    }

    public variable makeDifferentExternal(String sc) {
        return new variable(this.makeFreshExternalID(), this.sort, this.kind, sc);
    }

    public int hashCode() {
        return this.uid;
    }

    public int uid() {
        return this.uid;
    }

    public boolean equals(Object obj) {
        return obj instanceof variable ? this.equals((variable)obj) : false;
    }

    public boolean equals(variable v) {
        return v != null && this.uid == v.uid;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        return this.sort == null ? pp.print(this.id) : pp.fill().print(this.id).put(":").blank().print(this.sort).end();
    }

    public static String externalRep(String id, sort s) {
        return (String.valueOf(id) + ":" + s.toString()).intern();
    }

    @Override
    public String toString() {
        return this.asString;
    }

    public static prettyprinter print(prettyprinter pp, variable[] list, factoring f) {
        boolean inFactor = false;
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                pp.put(",").blank();
            }
            if (f.last(i)) {
                list[i].print(pp);
                if (inFactor) {
                    pp.end();
                }
                inFactor = false;
            } else {
                if (!inFactor) {
                    pp.fill();
                }
                pp.put(list[i].id());
                inFactor = true;
            }
            ++i;
        }
        return pp;
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        return SExp.makeSValue("v" + this.uid);
    }

    public static iprinter printAll(iprinter ip, Scope scope) {
        return variable.allToSValue(scope).print(ip);
    }

    public static SValue allToSValue(Scope scope) {
        SList list = SExp.makeSList(SExp.makeSValue("vars"));
        Enumeration<variable> e = allVarsVector.elements();
        while (e.hasMoreElements()) {
            variable var = e.nextElement();
            SList list1 = SExp.makeSList(var.toSValue(), SExp.makeSValue(var.id()), var.sort().toSValue());
            if (!var.scopingInfo.equals("")) {
                list1.add(SExp.makeSList(SExp.makeSValue(var.scopingInfo)));
            }
            list1.add(scope.toSValue());
            list.add(list1);
        }
        return list;
    }

    public int compareTo(variable v) {
        return this.uid < v.uid ? -1 : (this.uid == v.uid ? 0 : 1);
    }
}

