/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.actual;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class term
extends actual
implements Prettyprintable,
SPrintable {
    private int kind;
    public static final int OP = 0;
    public static final int QFR = 1;
    public static final int VAR = 2;
    private operator op;
    private term[] args;
    private variable var;
    private quantifier qfr;
    private term subterm;
    private sort theSort;
    private boolean parens;
    private boolean qual;
    private int hashVal = 0;
    private static final int ESC = 1;
    private static final int AND = 2;
    private static final int ID = 3;
    private static final int OPC = 4;
    private static final int SAFE = 5;

    public int kind() {
        return this.kind;
    }

    public String kindAsString() {
        switch (this.kind) {
            case 0: {
                return "term consisting of an operator";
            }
            case 1: {
                return "term consisting of a quantifier";
            }
            case 2: {
                return "term consisting of a variable";
            }
        }
        return "term's kind not initialized";
    }

    public operator op() {
        if (this.kind != 0) {
            throw new InternalError("term.op");
        }
        return this.op;
    }

    public int nArgs() {
        if (this.kind != 0) {
            throw new InternalError("term.nArgs");
        }
        return this.args.length;
    }

    public term arg(int n) {
        if (this.kind != 0 || n < 0 || this.args.length <= n) {
            throw new InternalError("term.arg");
        }
        return this.args[n];
    }

    public term[] cloneArgs() {
        return (term[])this.args.clone();
    }

    private int opKind() {
        switch (this.kind) {
            case 0: {
                return this.op.opKind();
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 0;
            }
        }
        throw new InternalError("term.opKind");
    }

    public variable var() {
        if (this.kind != 2) {
            throw new InternalError("term.var");
        }
        return this.var;
    }

    public quantifier qfr() {
        if (this.kind != 1) {
            throw new InternalError("term.qfr");
        }
        return this.qfr;
    }

    public term subterm() {
        if (this.kind != 1) {
            throw new InternalError("term.subterm");
        }
        return this.subterm;
    }

    public sort sort() {
        return this.theSort;
    }

    public term(variable v) {
        this.kind = 2;
        this.var = v;
        this.theSort = v.sort();
    }

    public term(term[] args, operator op) {
        this.kind = 0;
        this.op = op;
        this.args = args;
        this.theSort = op.sig().range();
        HashSet<String> externalReps = new HashSet<String>();
        for (variable v : this.freeVars()) {
            String rep = v.toString();
            if (externalReps.contains(rep)) {
                throw new InternalError("Distinct variables " + rep + " in\n " + this + " aka\n " + this.toSValue());
            }
            externalReps.add(rep);
        }
    }

    public term(operator op, term[] args) {
        this((term[])args.clone(), op);
    }

    public term reuse(operator op, term[] args) {
        if (this.kind != 0 || args.length != this.args.length) {
            throw new InternalError("term.reuse");
        }
        boolean same = true;
        int i = 0;
        while (same && i < args.length) {
            same = args[i] == this.args[i];
            ++i;
        }
        if (same) {
            args = this.args;
        }
        return same && op.equals(this.op) ? this : new term(args, op);
    }

    public term(quantifier q, term t) {
        if (!t.sort().equals(sort.boolSort)) {
            throw new InternalError("term.term(quantifer,term");
        }
        this.kind = 1;
        this.qfr = q;
        this.subterm = t;
        this.theSort = t.sort();
    }

    public term(term t) {
        this.kind = t.kind;
        this.op = t.op;
        this.args = t.args;
        this.var = t.var;
        this.qfr = t.qfr;
        this.subterm = t.subterm;
        this.theSort = t.theSort;
        this.hashVal = t.hashVal;
    }

    public HashSet<variable> freeVars() {
        HashSet<variable> freeVars = new HashSet<variable>();
        switch (this.kind) {
            case 0: {
                int i = 0;
                while (i < this.args.length) {
                    freeVars.addAll(this.args[i].freeVars());
                    ++i;
                }
                break;
            }
            case 1: {
                freeVars = this.subterm().freeVars();
                freeVars.remove(this.qfr().var().intern());
                break;
            }
            case 2: {
                freeVars.add(this.var().intern());
                break;
            }
            default: {
                throw new InternalError("term.freeVars");
            }
        }
        return freeVars;
    }

    public boolean occursFreely(variable v) {
        switch (this.kind) {
            case 0: {
                int i = 0;
                while (i < this.args.length) {
                    if (this.args[i].occursFreely(v)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                return !this.qfr.var().equals(v) && this.subterm.occursFreely(v);
            }
            case 2: {
                return v.equals(this.var);
            }
            default: {
                throw new InternalError("term.occursFreely");
            }
        }
        return false;
    }

    public boolean occursBound(variable v) {
        switch (this.kind) {
            case 0: {
                int i = 0;
                while (i < this.args.length) {
                    if (this.args[i].occursBound(v)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                return this.qfr.var().equals(v) || this.subterm.occursBound(v);
            }
            case 2: {
                break;
            }
            default: {
                throw new InternalError("term.occursBound");
            }
        }
        return false;
    }

    public boolean containsOp(operator op) {
        switch (this.kind) {
            case 0: {
                if (op.equals(this.op)) {
                    return true;
                }
                int i = 0;
                while (i < this.args.length) {
                    if (this.args[i].containsOp(op)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                return this.subterm.containsOp(op);
            }
            case 2: {
                break;
            }
            default: {
                throw new InternalError("term.containsOp");
            }
        }
        return false;
    }

    public boolean isSubterm(term t) {
        if (this.equals(t)) {
            return true;
        }
        switch (this.kind) {
            case 0: {
                int i = 0;
                while (i < this.args.length) {
                    if (this.args[i].isSubterm(t)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                return t != null && t.kind() == 2 && this.qfr.var().equals(t.var()) || this.subterm.isSubterm(t);
            }
            case 2: {
                break;
            }
            default: {
                throw new InternalError("term.isSubterm");
            }
        }
        return false;
    }

    public boolean isTrue() {
        return this.equals(booleans.trueTerm);
    }

    public boolean isFalse() {
        return this.equals(booleans.falseTerm);
    }

    public boolean equals(Object obj) {
        return obj instanceof term ? this.equals((term)obj) : false;
    }

    public boolean equals(term t) {
        if (t == this) {
            return true;
        }
        if (t == null || this.kind != t.kind || this.hashCode() != t.hashCode()) {
            return false;
        }
        switch (this.kind) {
            case 0: {
                if (this.args.length != t.args.length || !this.op.equals(t.op)) {
                    return false;
                }
                int i = 0;
                while (i < this.args.length) {
                    if (!this.args[i].equals(t.args[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 1: {
                return this.qfr.equals(t.qfr) && this.subterm.equals(t.subterm);
            }
            case 2: {
                return this.var.equals(t.var);
            }
        }
        throw new InternalError("term.equals");
    }

    public int hashCode() {
        if (this.hashVal == 0) {
            switch (this.kind) {
                case 0: {
                    this.hashVal = this.op.hashCode();
                    int i = 0;
                    while (i < this.args.length) {
                        this.hashVal = 17 * this.hashVal ^ this.args[i].hashCode();
                        ++i;
                    }
                    break;
                }
                case 1: {
                    this.hashVal = this.qfr.hashCode();
                    break;
                }
                case 2: {
                    this.hashVal = this.var.hashCode();
                    break;
                }
                default: {
                    throw new InternalError("term.hashCode");
                }
            }
        }
        return this.hashVal;
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SValue value2 = new SList();
        switch (this.kind) {
            case 0: {
                if (this.args.length == 0) {
                    value2 = this.op.litSValue();
                    break;
                }
                SList tempValue = SExp.makeSList(SExp.makeSValue("apply"), this.op.toSValue());
                int i = 0;
                while (i < this.args.length) {
                    tempValue.add(this.args[i].toSValue());
                    ++i;
                }
                value2 = tempValue;
                break;
            }
            case 1: {
                SList qList = (SList)this.qfr.toSValue();
                SList tList = new SList();
                tList.addAll((Collection)qList);
                tList.add(this.subterm.toSValue());
                value2 = tList;
                break;
            }
            case 2: {
                value2 = this.var.toSValue();
                break;
            }
            default: {
                throw new InternalError("term.toSValue");
            }
        }
        return value2;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        this.parens = false;
        this.qual = false;
        this.print(pp, 5);
        return pp;
    }

    protected int print(prettyprinter pp, int last) {
        if (this.parens) {
            pp.fill(1).put("(");
            last = 5;
        }
        switch (this.opKind()) {
            case 0: 
            case 5: {
                last = this.printId(pp, last);
                break;
            }
            case 1: {
                last = this.printFctTerm(pp, last);
                break;
            }
            case 2: {
                last = this.printIfTerm(pp, last);
                break;
            }
            case 3: {
                last = this.printInfixTerm(pp, last);
                break;
            }
            case 4: {
                last = this.printMixfixTerm(pp, last);
                break;
            }
            case 6: 
            case 9: {
                last = this.printPostfixTerm(pp, last);
                break;
            }
            case 7: 
            case 8: {
                last = this.printPrefixTerm(pp, last);
                break;
            }
            default: {
                throw new InternalError("term.print");
            }
        }
        if (this.parens) {
            pp.put(")").end();
            last = 5;
        }
        return last;
    }

    private int printFctTerm(prettyprinter pp, int last) {
        pp.fill();
        last = this.printId(pp, last);
        pp.blank(0).align(1).put("(").list(this.args, ",").put(")").end();
        if (this.qual) {
            pp.put(":").blank().print(this.theSort);
            last = this.theSort.isSimple() ? 3 : 5;
        } else {
            last = 5;
        }
        pp.end();
        return last;
    }

    private int printId(prettyprinter pp, int last) {
        if ((last == 1 || last == 3) && this.op.opKind() != 9) {
            pp.blank();
        }
        if (this.kind == 2) {
            pp.print(this.var.id());
        } else if (this.op.opKind() == 9) {
            pp.print("." + this.op.id().string());
        } else {
            pp.print(this.op.id().string());
        }
        return 3;
    }

    private int printIfTerm(prettyprinter pp, int last) {
        if (this.qual) {
            last = this.beginQualification(pp);
        }
        if (last == 1 || last == 3) {
            pp.blank();
        }
        term t = this;
        pp.align(0).fill(2).put("if ");
        if (this.qual && this.args[2].opKind() == 2) {
            while (true) {
                t.args[0].parens = false;
                pp.print(t.args[0]).blank().put("then").blank();
                t.args[1].parens = false;
                pp.print(t.args[1]).end().blank();
                t = t.args[2];
                if (!t.qual && t.opKind() == 2) {
                    pp.fill(2).put("else if").blank();
                    continue;
                }
                break;
            }
        } else {
            t.args[0].parens = false;
            pp.print(t.args[0]).end().blank().fill(2).put("then").blank();
            t.args[1].parens = false;
            pp.print(t.args[1]).end().blank();
        }
        t.args[2].parens = false;
        pp.fill(2).put("else").blank();
        last = t.args[2].print(pp, 5);
        pp.end().end();
        if (this.qual) {
            last = this.endQualification(pp);
        }
        return last;
    }

    private int printInfixTerm(prettyprinter pp, int last) {
        if (this.qual) {
            last = this.beginQualification(pp);
        }
        pp.align();
        last = this.printFirstInfixArg(pp, last);
        last = this.printOtherInfixArgs(pp, last, 1);
        pp.end();
        if (this.qual) {
            last = this.endQualification(pp);
        }
        return last;
    }

    private int printFirstInfixArg(prettyprinter pp, int last) {
        term arg1 = this.args[0];
        if (arg1.opKind() == 3 && this.op.id().equals(arg1.op.id()) && this.op.id().leftAssociative()) {
            last = arg1.printFirstInfixArg(pp, last);
            last = arg1.printOtherInfixArgs(pp, last, 1);
        } else {
            last = this.printInfixArg(pp, last, 0);
        }
        return last;
    }

    private int printOtherInfixArgs(prettyprinter pp, int last, int n) {
        term argn = this.args[n];
        if (argn.opKind() == 3 && this.op.id().equals(argn.op.id()) && this.op.id().leftAssociative()) {
            last = argn.printOtherInfixArgs(pp, last, 0);
            last = argn.printOtherInfixArgs(pp, last, 1);
        } else {
            if (this.op.id().equals(opSym.dotSym)) {
                pp.fill().put(opSym.dotSym.string());
            } else {
                pp.blank().fill().print(this.op.id().string()).blank();
            }
            last = this.printInfixArg(pp, 5, n);
            pp.end();
        }
        return last;
    }

    private int printInfixArg(prettyprinter pp, int last, int n) {
        int p2;
        term argn = this.args[n];
        if (argn.kind != 0) {
            last = argn.print(pp, last);
            return last;
        }
        int p1 = this.op.id().priority();
        argn.parens = p1 > (p2 = argn.op.id().priority()) || p1 == p2 && !this.op.equals(argn.op) || n > 0 && this.op.equals(argn.op) && !this.op.id().leftAssociative() || n == 0 && this.kind == 1 || n > 0 && this.op.id().equals(opSym.dotSym) && argn.opKind() == 0;
        last = argn.print(pp, last);
        return last;
    }

    private int printMixfixTerm(prettyprinter pp, int last) {
        int first = 0;
        int nargs = this.args.length;
        opSym openClose = this.op.id();
        if (openClose.argAfter()) {
            --nargs;
        }
        pp.fill();
        if (openClose.argBefore()) {
            ++first;
            last = this.args[0].printMixfixArg(pp, last);
        }
        pp.align(1);
        last = this.printOpenClose(pp, last, openClose.string());
        int i = first;
        while (i < nargs) {
            if (i > first) {
                pp.put(",").blank();
            }
            this.args[i].parens = false;
            last = this.args[i].print(pp, 5);
            ++i;
        }
        last = this.printOpenClose(pp, last, openClose.closeString());
        pp.end();
        if (openClose.argAfter()) {
            last = this.args[nargs].printMixfixArg(pp, last);
        }
        pp.end();
        return last;
    }

    private int printMixfixArg(prettyprinter pp, int last) {
        switch (this.opKind()) {
            case 0: 
            case 1: 
            case 9: {
                this.parens = this.qual;
                break;
            }
            default: {
                this.parens = true;
            }
        }
        return this.print(pp, last);
    }

    private int printOp(prettyprinter pp, int last) {
        String s = this.op.id().string();
        if (last == 2 || last == 1 || last == 4 && s.charAt(0) != '\\') {
            pp.blank();
        }
        pp.put(s);
        if (this.op.opKind() == 9) {
            pp.print(this.op.id().closeString());
            return 3;
        }
        return s.equals("\\") ? 1 : (s.equals("/") ? 2 : 4);
    }

    private int printOpenClose(prettyprinter pp, int last, String sym2) {
        if (last == 4 || last == 2 && sym2.charAt(0) == '\\') {
            pp.blank();
        }
        pp.put(sym2);
        return 5;
    }

    private int printPostfixTerm(prettyprinter pp, int last) {
        if (this.qual) {
            last = this.beginQualification(pp);
        }
        pp.fill();
        term t = this;
        Stack<term> postTerms = new Stack<term>();
        do {
            postTerms.push(t);
            t = t.args[0];
        } while (t.qual && t.opKind() == 6);
        int p1 = this.op.id().priority();
        int p2 = t.op == null ? opSym.trueSym.priority() : t.op.id().priority();
        t.parens = p1 > p2 || p1 == p2 && t.opKind() != 6 || t.opKind() == 8;
        last = t.print(pp, last);
        while (!postTerms.empty()) {
            last = ((term)postTerms.pop()).printId(pp, last);
        }
        pp.end();
        if (this.qual) {
            last = this.endQualification(pp);
        }
        return last;
    }

    private int printPrefixTerm(prettyprinter pp, int last) {
        opSym lastPrinted;
        if (this.qual) {
            this.beginQualification(pp);
        }
        term t = this;
        pp.fill(t.kind == 1 ? 3 : 2);
        do {
            if (t.kind == 1) {
                lastPrinted = opSym.allSym;
                last = t.printQfr(pp, last);
                t = t.subterm();
                continue;
            }
            lastPrinted = t.op.id();
            last = t.printOp(pp, last);
            t = t.args[0];
        } while (!t.qual && (t.kind == 1 || t.kind == 0 && t.opKind() == 7));
        t.parens = t.kind == 2 ? false : (t.qual ? false : (lastPrinted.kind() == 8 ? t.opKind() != 0 && t.opKind() != 1 : t.op.id().priority() <= lastPrinted.priority()));
        last = t.print(pp, last);
        pp.end();
        if (this.qual) {
            last = this.endQualification(pp);
        }
        return last;
    }

    private int beginQualification(prettyprinter pp) {
        pp.fill(1).put("(");
        return 5;
    }

    private int endQualification(prettyprinter pp) {
        pp.put("):").blank().print(this.theSort).end();
        return this.theSort.isSimple() ? 3 : 5;
    }

    private int printQfr(prettyprinter pp, int last) {
        if (last == 1 || last == 3 || last == 2) {
            pp.blank();
        }
        pp.fill().print(this.qfr).end().blank();
        return 5;
    }

    public static term make(operator op) {
        if (op.arity() != 0) {
            throw new InternalError("term.make: arity != 0");
        }
        return new term(new term[0], op);
    }

    public static term make(operator op, term t) {
        if (op.arity() != 1) {
            throw new InternalError("term.make: arity != 1");
        }
        sort argSort = op.sig().domain(0);
        if (!t.sort().equals(argSort)) {
            throw new InternalError("term.make: sort mismatch " + t.sort() + ":" + t.sort().uid() + " vs. " + argSort + ":" + argSort.uid());
        }
        term[] args = new term[]{t};
        return new term(args, op);
    }

    public static term make(operator op, term t1, term t2) {
        if (op.arity() != 2) {
            throw new InternalError("term.make: arity != 2");
        }
        if (!t1.sort().equals(op.sig().domain(0)) || !t2.sort().equals(op.sig().domain(1))) {
            throw new InternalError("term.make: sort mismatch");
        }
        term[] args = new term[]{t1, t2};
        return new term(args, op);
    }
}

