/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Iterator;

public class substitution
extends Unit {
    protected term[] dom;
    protected term[] rng;
    private int size = 0;
    private static substitution theIdentity = new substitution();

    public static substitution theIdentity() {
        return theIdentity;
    }

    public substitution() {
    }

    public substitution(int n) {
        this.ensureCapacity(n, 0);
    }

    public substitution(variable v, term t) {
        this(1);
        if (v != null && t != null) {
            this.add(v, t);
        }
    }

    public substitution(variable[] v, term[] t) {
        this(v.length);
        if (v.length != t.length) {
            throw new InternalError("substitution constructor: #vars != #terms");
        }
        int i = 0;
        while (i < v.length) {
            if (v[i] != null && t[i] != null) {
                this.add(v[i], t[i]);
            }
            ++i;
        }
    }

    public substitution(term[] dom, term[] rng) {
        this(dom.length);
        if (dom.length != rng.length) {
            throw new InternalError("substitution constructor: #dom != #rng");
        }
        int i = 0;
        while (i < dom.length) {
            if (dom[i] != null && rng[i] != null) {
                this.add(dom[i], dom[i]);
            }
            ++i;
        }
    }

    public int size() {
        return this.size;
    }

    public substitution add(term t1, term t2) {
        if (t1 == null || t2 == null || !t1.sort().equals(t2.sort())) {
            throw new InternalError("substitution.add(" + t1 + "," + t2 + ")");
        }
        if (this == theIdentity) {
            throw new InternalError("attempt to modify substition.theIdentity");
        }
        int i = 0;
        while (i < this.size) {
            if (this.dom[i].equals(t1)) {
                return this.rng[i].equals(t2) ? this : null;
            }
            if (this.dom[i].isSubterm(t1) || t1.isSubterm(this.dom[i])) {
                return null;
            }
            ++i;
        }
        this.ensureCapacity(this.size + 1, 10);
        this.dom[this.size] = t1;
        this.rng[this.size++] = t2;
        return this;
    }

    public substitution add(variable v, term t) {
        return this.add(new term(v), t);
    }

    public substitution add(variable v, variable vNew) {
        return this.add(v, new term(vNew));
    }

    public term delete(variable v) {
        int i = this.findIndex(new term(v));
        if (i < 0) {
            return null;
        }
        term result = this.rng[i];
        --this.size;
        int j = i;
        while (j < this.size) {
            this.dom[j] = this.dom[j + 1];
            this.rng[j] = this.rng[j + 1];
            ++j;
        }
        return result;
    }

    public term map(variable v) {
        int x = this.findIndex(new term(v));
        return x < 0 ? new term(v) : this.rng[x];
    }

    public term[] map(variable[] v) {
        term[] w = new term[v.length];
        int i = 0;
        while (i < v.length) {
            w[i] = this.map(v[i]);
            ++i;
        }
        return w;
    }

    public term map(term t) {
        if (t == null) {
            return null;
        }
        int x = this.findIndex(t);
        if (x >= 0) {
            return this.rng[x].equals(t) ? t : this.rng[x];
        }
        switch (t.kind()) {
            case 2: {
                return x < 0 ? t : this.rng[x];
            }
            case 0: {
                term[] args = null;
                int i = 0;
                while (i < t.nArgs()) {
                    term t1 = this.map(t.arg(i));
                    if (args != null || t1 != t.arg(i)) {
                        if (args == null) {
                            args = t.cloneArgs();
                        }
                        args[i] = t1;
                    }
                    ++i;
                }
                return args == null ? t : new term(args, t.op());
            }
            case 1: {
                quantifier q = t.qfr();
                variable v = q.var();
                term vImage = this.delete(v);
                variable vNew = null;
                Iterator<variable> i = t.freeVars().iterator();
                while (i.hasNext() && vNew == null) {
                    if (!this.map(i.next()).freeVars().contains(v.intern())) continue;
                    vNew = this.changeVar(v);
                }
                term subform = this.map(t.subterm());
                if (vNew != null) {
                    this.delete(v);
                }
                if (vImage != null) {
                    this.add(v, vImage);
                }
                return vNew != null ? new term(new quantifier(q.kind(), vNew), subform) : (subform != t.subterm() ? new term(q, subform) : t);
            }
        }
        throw new InternalError("substitution.map");
    }

    public variable changeVar(variable v) {
        variable vNew = v.makeDifferentExternal();
        return this.add(v, vNew) == null ? null : vNew;
    }

    public term[] map(term[] t) {
        boolean changed = false;
        term[] u = new term[t.length];
        int i = 0;
        while (i < t.length) {
            u[i] = this.map(t[i]);
            if (t[i] != u[i]) {
                changed = true;
            }
            ++i;
        }
        return changed ? u : t;
    }

    private int findIndex(term t) {
        int i = 0;
        while (i < this.size) {
            if (this.dom[i].equals(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public substitution union(substitution s) {
        substitution result = new substitution(this.size + s.size());
        int i = 0;
        while (i < this.size) {
            result.dom[i] = this.dom[i];
            result.rng[i] = this.rng[i];
            ++i;
        }
        i = 0;
        while (i < s.size()) {
            if (result.add(s.dom[i], s.rng[i]) == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public substitution compose(substitution s) {
        substitution result = new substitution(this.size + s.size());
        int i = 0;
        while (i < this.size) {
            result.add(this.dom[i], s.map(this.rng[i]));
            ++i;
        }
        i = 0;
        while (i < s.size()) {
            if (this.findIndex(this.dom[i]) < 0) {
                result.add(s.dom[i], s.rng[i]);
            }
            ++i;
        }
        return result;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.align(0);
        int i = 0;
        while (i < this.size) {
            pp.fill().print(this.dom[i]).blank().put("<-").blank().print(this.rng[i]).end().eol();
            ++i;
        }
        return pp.end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("substitute"));
        int i = 0;
        while (i < this.size) {
            list.add(SExp.makeSList(this.dom[i].toSValue(), this.rng[i].toSValue()));
            ++i;
        }
        return list;
    }

    public boolean equals(substitution s) {
        int i = 0;
        while (i < this.size) {
            if (!this.rng[i].equals(s.map(this.dom[i]))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < s.size) {
            if (this.findIndex(s.dom[i]) < 0 && !s.rng[i].equals(this.map(s.dom[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public substitution copy() {
        return new substitution(this.dom, this.rng);
    }

    private void ensureCapacity(int minimumSize, int extraCapacity) {
        if (this == theIdentity) {
            return;
        }
        if (this.dom != null && minimumSize <= this.dom.length) {
            return;
        }
        int newsize = minimumSize + extraCapacity;
        term[] newDom = new term[newsize];
        term[] newRng = new term[newsize];
        if (this.dom != null) {
            System.arraycopy(this.dom, 0, newDom, 0, this.size);
            System.arraycopy(this.rng, 0, newRng, 0, this.size);
        }
        this.dom = newDom;
        this.rng = newRng;
    }

    public void trimToSize() {
        if (this.dom == null || this.dom.length == this.size) {
            return;
        }
        this.ensureCapacity(this.size, 0);
    }

    public static void main(String[] args) {
        sort s = new sort("s");
        signature sig = new signature(s, s, s);
        operator op = new operator(new opSym(1, "f"), new signature(s, s, s));
        operator rel = new operator(new opSym(1, "R"), new signature(s, s, sort.boolSort));
        int nVars = 10;
        variable[] v = new variable[nVars];
        quantifier[] q = new quantifier[nVars];
        int i = 0;
        while (i < nVars) {
            v[i] = new variable("v" + i, s, 15);
            q[i] = new quantifier(quantifier.EXISTS, v[i]);
            ++i;
        }
        int sigmaSize = 4;
        term[] vMap = new term[sigmaSize];
        vMap[0] = new term(v[0]);
        vMap[1] = vMap[0];
        vMap[2] = substitution.makeTerm(op, v[0], v[0]);
        vMap[3] = substitution.makeTerm(op, v[0], v[1]);
        substitution sigma = new substitution(sigmaSize);
        int i2 = 0;
        while (i2 < sigmaSize) {
            sigma.add(v[i2], vMap[i2]);
            ++i2;
        }
        prettyprinter pp = prettyprinter.stdout();
        pp.align(0).align(0).put("sigma = ").print(sigma).end().eol().end();
        int nTerms = 11;
        term[] t = new term[nTerms];
        t[0] = new term(v[0]);
        t[1] = new term(v[1]);
        t[2] = new term(v[2]);
        t[3] = new term(v[3]);
        t[4] = new term(v[4]);
        t[5] = substitution.makeTerm(op, v[0], v[1]);
        t[6] = substitution.makeTerm(op, v[0], v[3]);
        term R = substitution.makeTerm(rel, v[0], v[1]);
        t[7] = new term(q[1], R);
        t[8] = new term(q[0], R);
        t[9] = new term(q[0], R);
        term R1 = substitution.makeTerm(rel, v[1], v[3]);
        term qR = new term(q[1], R1);
        t[10] = booleans.conjoin(qR, R1);
        pp.align(0).put("Mapped ").align(0).put("<from> -> <to>").eol();
        int i3 = 0;
        while (i3 < nTerms) {
            pp.fill().fill(0).print(t[i3]).end().blank().put("->").blank().fill(0).print(sigma.map(t[i3])).end().end().eol();
            ++i3;
        }
        pp.end().eol().end().eof();
    }

    private static term makeTerm(operator op, Object t1, Object t2) {
        term[] args = new term[]{substitution.makeTerm(t1), substitution.makeTerm(t2)};
        return new term(op, args);
    }

    private static term makeTerm(Object x) {
        return x instanceof term ? (term)x : (x instanceof variable ? new term((variable)x) : null);
    }
}

