/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortEnum;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.objectArray;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class sortUnion
extends sort
implements SPrintable {
    private sort sort;
    private String[] field;
    private operator[] get;
    private operator[] cvt;
    private sortEnum tagSort;
    private operator tag;
    private int hashVal;

    public sort sort() {
        return this.sort;
    }

    public int nFields() {
        return this.field.length;
    }

    public String field(int n) {
        return this.field[n];
    }

    public operator get(int n) {
        return this.get[n];
    }

    public operator cvt(int n) {
        return this.cvt[n];
    }

    public sortEnum tagSort() {
        return this.tagSort;
    }

    public operator tag() {
        return this.tag;
    }

    public sortUnion(sort s, String[] field, operator[] get, operator[] cvt, sortEnum tagSort, operator tag) {
        super(s);
        this.sort = s;
        this.field = field;
        this.get = get;
        this.cvt = cvt;
        this.tagSort = tagSort;
        this.tag = tag;
        if (!sortUnion.legal(s, field, get, cvt, tagSort, tag)) {
            throw new InternalError("sortunion()");
        }
        this.hashVal = 17 * (17 * s.hashCode() ^ tag.hashCode()) ^ tagSort.hashCode();
        int n = 0;
        while (n < get.length) {
            this.hashVal = 17 * (17 * this.hashVal ^ get[n].hashCode()) ^ cvt[n].hashCode();
            this.hashVal = 17 * this.hashVal ^ field[n].hashCode();
            ++n;
        }
    }

    public static boolean legal(sort s, String[] field, operator[] get, operator[] cvt, sortEnum tagSort, operator tag) {
        int n = field.length;
        if (!(n != 0 && get.length == n && cvt.length == n && tagSort.nElems() == n && tag.arity() == 1 && tag.sig().domain(0).equals(s) && tag.sig().range().equals(tagSort.sort()) && objectArray.noDuplicates(field) && objectArray.noDuplicates(get) && objectArray.noDuplicates(cvt))) {
            return false;
        }
        int i = 0;
        while (i < field.length) {
            if (get[i].arity() != 1 || cvt[i].arity() != 1 || get[i].sig().range().equals(s) || !get[i].sig().domain(0).equals(s) || !cvt[i].sig().range().equals(s) || !cvt[i].sig().domain(0).equals(get[i].sig().range())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public sortUnion rename(renaming r) {
        sort s = r.map(this.sort);
        sortEnum tagSort1 = this.tagSort.rename(r);
        boolean same = s.equals(this.sort) && this.tagSort.equals(tagSort1);
        int n = this.field.length;
        int i = 0;
        while (i < n && same) {
            sort rng = this.get[i].sig().range();
            same = rng.equals(r.map(rng));
            ++i;
        }
        if (same) {
            return this;
        }
        operator[] rget = new operator[n];
        operator[] rcvt = new operator[n];
        int i2 = 0;
        while (i2 < n) {
            rget[i2] = r.map(this.get[i2]);
            rcvt[i2] = r.map(this.cvt[i2]);
            ++i2;
        }
        return new sortUnion(s, this.field, rget, rcvt, tagSort1, r.map(this.tag));
    }

    public int hashCode() {
        return this.hashVal;
    }

    public boolean equals(Object obj) {
        return obj instanceof sortUnion ? this.equals((sortUnion)obj) : false;
    }

    public boolean equals(sortUnion s) {
        if (this == s) {
            return true;
        }
        return s != null && this.sort.equals(s.sort) && this.tag.equals(s.tag) && objectArray.equals(this.field, s.field) && objectArray.equals(this.get, s.get) && objectArray.equals(this.cvt, s.cvt) && this.tagSort.equals(s.tagSort());
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill().print(this.sort).blank().put("union").blank().put("[");
        int n = 0;
        while (n < this.get.length) {
            if (n > 0) {
                pp.put(",").blank();
            }
            pp.print(this.field[n]).put(":").blank().print(this.get[n].sig().range());
            ++n;
        }
        return pp.put("]").end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("union"), this.sort.toSValue(), this.tagSort.sort().toSValue(), this.tag.toSValue());
        int n = 0;
        while (n < this.field.length) {
            SList list1 = new SList();
            list1.add(SExp.makeSValue(this.field[n]));
            list1.add(this.get[n].sig().range().toSValue());
            list1.add(this.cvt(n).toSValue());
            list1.add(this.get(n).toSValue());
            list.add(list1);
            ++n;
        }
        return list;
    }
}

