/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.objectArray;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sortTuple
extends sort
implements SPrintable {
    private sort sort;
    private String[] field;
    private operator[] get;
    private operator[] set;
    private operator make;
    private int hashVal;

    public sort sort() {
        return this.sort;
    }

    public int nFields() {
        return this.field.length;
    }

    public String field(int n) {
        return this.field[n];
    }

    public operator get(int n) {
        return this.get[n];
    }

    public operator set(int n) {
        return this.set[n];
    }

    public operator make() {
        return this.make;
    }

    public int index(String id, sort s) {
        int i = 0;
        while (i < this.field.length) {
            if (this.field[i].equals(id) && this.get[i].sig().range().equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public sortTuple(sort s, String[] field, operator[] get, operator[] set, operator make) {
        super(s);
        this.sort = s;
        this.field = field;
        this.get = get;
        this.set = set;
        this.make = make;
        if (!sortTuple.legal(this.sort, field, get, set, make)) {
            throw new InternalError("sortTuple(sort, String[], operator[], operator[], operator)");
        }
        this.hashVal = this.hashVal();
    }

    public sortTuple(sort s, String[] field, sort[] fieldSort) {
        super(s);
        if (field.length != fieldSort.length) {
            throw new InternalError("sortTuple(sort, String[], sort[])");
        }
        this.sort = s;
        this.field = field;
        this.get = new operator[field.length];
        this.set = new operator[field.length];
        int i = 0;
        while (i < field.length) {
            this.get[i] = new operator(new opSym(9, field[i]), new signature(this.sort, fieldSort[i]));
            this.set[i] = new operator(new opSym(1, "set_" + field[i]), new signature(this.sort, fieldSort[i], this.sort));
            ++i;
        }
        this.make = new operator(opSym.bracketOp(false, field.length, false), new signature(this.sort, fieldSort));
        if (!sortTuple.legal(this.sort, field, this.get, this.set, this.make)) {
            throw new InternalError("sortTuple(sort, String[], sort[])");
        }
        this.hashVal = this.hashVal();
    }

    public static boolean legal(sort s, String[] field, operator[] get, operator[] set, operator make) {
        int n = field.length;
        if (!(n != 0 && get.length == n && set.length == n && make.arity() == n && make.sig().range().equals(s) && objectArray.noDuplicates(field) && objectArray.noDuplicates(get) && objectArray.noDuplicates(set))) {
            return false;
        }
        int i = 0;
        while (i < get.length) {
            if (!(get[i].arity() == 1 && set[i].arity() == 2 && !get[i].sig().range().equals(s) && get[i].sig().domain(0).equals(s) && set[i].sig().domain(0).equals(s) && set[i].sig().domain(1).equals(get[i].sig().range()) && set[i].sig().range().equals(s) && make.sig().domain(i).equals(get[i].sig().range()) && field[i].equals(get[i].id().string()) && field[i].equals(set[i].id().string().substring(4)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static sortTuple combine(sort s, HashSet<sortTuple> t) {
        HashSet sorts;
        int numFields = 0;
        Hashtable fieldTab = new Hashtable();
        for (sortTuple st : t) {
            int j = 0;
            while (j < st.nFields()) {
                String f = st.field(j).intern();
                sort s1 = st.get(j).sig().range();
                sorts = (HashSet)fieldTab.get(f);
                if (sorts == null) {
                    sorts = new HashSet();
                    fieldTab.put(f, sorts);
                }
                if (!sorts.contains(s1.intern())) {
                    ++numFields;
                }
                sorts.add(s.intern());
                ++j;
            }
        }
        String[] field = new String[numFields];
        sort[] fieldSort = new sort[numFields];
        int i = 0;
        Enumeration e = fieldTab.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            sorts = (HashSet)fieldTab.get(id);
            Iterator it = sorts.iterator();
            while (it.hasNext()) {
                field[i] = id;
                fieldSort[i] = (sort)it.next();
                ++i;
            }
        }
        return new sortTuple(s, field, fieldSort);
    }

    public sortTuple rename(renaming r) {
        sort s = r.map(this.sort);
        boolean same = s.equals(this.sort);
        int n = this.field.length;
        int i = 0;
        while (i < n && same) {
            sort rng = this.get[i].sig().range();
            same = rng.equals(r.map(rng));
            ++i;
        }
        if (same) {
            return this;
        }
        operator[] rget = new operator[n];
        operator[] rset = new operator[n];
        int i2 = 0;
        while (i2 < n) {
            rget[i2] = r.map(this.get[i2]);
            rset[i2] = r.map(this.set[i2]);
            ++i2;
        }
        return new sortTuple(s, this.field, rget, rset, r.map(this.make));
    }

    @Override
    public int hashCode() {
        return this.hashVal;
    }

    private int hashVal() {
        this.hashVal = 17 * this.sort.hashCode() ^ this.make.hashCode();
        int n = 0;
        while (n < this.get.length) {
            this.hashVal = 17 * (17 * this.hashVal ^ this.get[n].hashCode()) ^ this.set[n].hashCode();
            this.hashVal = 17 * this.hashVal ^ this.field[n].hashCode();
            ++n;
        }
        return this.hashVal;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof sortTuple && this.equals((sortTuple)obj);
    }

    public boolean equals(sortTuple s) {
        if (this == s) {
            return true;
        }
        return s != null && this.sort.equals(s.sort) && this.make.equals(s.make) && objectArray.equals(this.field, s.field) && objectArray.equals(this.get, s.get) && objectArray.equals(this.set, s.set);
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.fill().print(this.sort).blank().put("tuple").blank().put("[");
        int n = 0;
        while (n < this.get.length) {
            if (n > 0) {
                pp.put(",").blank();
            }
            pp.print(this.field[n]).put(":").blank().print(this.get[n].sig().range());
            ++n;
        }
        return pp.put("]").end();
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("tuple"), this.sort.toSValue(), this.make().toSValue());
        int n = 0;
        while (n < this.field.length) {
            SList list2 = new SList();
            list2.add(SExp.makeSValue(this.field[n]));
            list2.add(this.get[n].sig().range().toSValue());
            list2.add(this.set(n).toSValue());
            list2.add(this.get(n).toSValue());
            list.add(list2);
            ++n;
        }
        return list;
    }
}

