/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.objectArray;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class sortEnum
extends sort
implements SPrintable {
    private sort sort;
    private operator[] elements;
    private operator succ;
    private int hashVal;

    public sort sort() {
        return this.sort;
    }

    public operator[] elements() {
        return (operator[])this.elements.clone();
    }

    public int nElems() {
        return this.elements.length;
    }

    public operator elem(int n) {
        return this.elements[n];
    }

    public operator succ() {
        return this.succ;
    }

    public sortEnum(sort s, operator[] elements, operator succ) {
        super(s);
        this.sort = s;
        this.elements = elements;
        this.succ = succ;
        if (!sortEnum.legal(s, elements, succ)) {
            throw new InternalError("sortEnum()");
        }
        this.hashVal = 17 * s.hashCode() ^ succ.hashCode();
        int n = 0;
        while (n < elements.length) {
            this.hashVal = 17 * this.hashVal ^ elements[n].hashCode();
            ++n;
        }
    }

    public static boolean legal(sort s, operator[] elements, operator succ) {
        if (!(elements.length != 0 && succ.arity() == 1 && succ.sig().domain(0).equals(s) && succ.sig().range().equals(s) && objectArray.noDuplicates(elements))) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            operator op = elements[i];
            if (op.arity() > 0 || !op.sig().range().equals(s)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public sortEnum rename(renaming r) {
        sort s = r.map(this.sort);
        if (s.equals(this.sort)) {
            return this;
        }
        operator[] e = new operator[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            e[i] = r.map(this.elements[i]);
            ++i;
        }
        return new sortEnum(s, e, r.map(this.succ));
    }

    public int hashCode() {
        return this.hashVal;
    }

    public boolean equals(Object obj) {
        return obj instanceof sortEnum ? this.equals((sortEnum)obj) : false;
    }

    public boolean equals(sortEnum s) {
        return s != null && this.sort.equals(s.sort) && this.succ.equals(s.succ) && objectArray.equals(this.elements, s.elements);
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill().print(this.sort).blank().put("enumeration").blank().put("[").print(this.elements[0].id());
        int n = 1;
        while (n < this.elements.length) {
            pp.put(",").blank().print(this.elements[n].id());
            ++n;
        }
        return pp.put("]").end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("enum"), this.sort.toSValue(), this.succ().toSValue());
        int i = 0;
        while (i < this.elements.length) {
            operator elem = this.elements[i];
            SList list1 = SExp.makeSList(SExp.makeSValue(elem.id().string()));
            list1.add(elem.toSValue());
            list.add(list1);
            ++i;
        }
        return list;
    }
}

