/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.actual;
import com.veromodo.tioa.notions.sortConstructor;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class sort
extends actual
implements Prettyprintable,
SPrintable {
    private String id;
    private sortConstructor constructor;
    private sort[] subsorts;
    private String asString;
    private boolean numerals;
    private int uid;
    private static int nextUid = 0;
    public static sort typeSort;
    public static sort boolSort;
    public static sort realSort;
    public static sort realSortD;
    public static sort augmentedRealSort;
    public static sort augmentedRealSortD;
    private static Hashtable<String, Integer> allSortsHashtable;
    private static Vector<sort> allSortsVector;
    private static String[] numericSortId;

    static {
        allSortsHashtable = new Hashtable(20);
        allSortsVector = new Vector(20);
        boolSort = new sort("Bool");
        realSort = new sort("Real");
        realSortD = new sort("DiscreteReal");
        augmentedRealSort = new sort("AugmentedReal");
        augmentedRealSortD = new sort("DiscreteAugmentedReal");
        realSort.makeNumeral();
        realSortD.makeNumeral();
        augmentedRealSort.makeNumeral();
        augmentedRealSortD.makeNumeral();
        sort natSort = new sort("Nat");
        sort intSort = new sort("Int");
        natSort.makeNumeral();
        intSort.makeNumeral();
        typeSort = new sort("type");
        numericSortId = new String[]{"Nat", "Int", "Real", "AugmentedReal"};
    }

    public String id() {
        if (this.subsorts.length != 0) {
            throw new InternalError("sort.id");
        }
        return this.id;
    }

    public sortConstructor constructor() {
        if (this.subsorts.length == 0) {
            throw new InternalError("sort.constructor");
        }
        return this.constructor;
    }

    public int nSubsorts() {
        return this.subsorts.length;
    }

    public sort subsort(int n) {
        if (n < 0 || this.subsorts.length <= n) {
            throw new InternalError("sort.subsort");
        }
        return this.subsorts[n];
    }

    public sort[] cloneSubsorts() {
        return (sort[])this.subsorts.clone();
    }

    public boolean hasNumerals() {
        return this.numerals;
    }

    public sort(String s) {
        this.id = s;
        this.subsorts = new sort[0];
        this.numerals = false;
        this.asString = this.id.intern();
        Integer UID = allSortsHashtable.get(this.asString);
        if (UID == null) {
            this.uid = nextUid++;
            allSortsHashtable.put(this.asString, new Integer(this.uid));
            allSortsVector.addElement(this);
        } else {
            this.uid = UID;
            this.numerals = sort.allSortsVector.elementAt((int)this.uid).numerals;
        }
    }

    public sort(sortConstructor s, sort[] v) {
        this((sort[])v.clone(), s);
    }

    public sort(sort[] v, sortConstructor s) {
        assert (s.arity() == v.length);
        this.constructor = s;
        this.subsorts = v;
        this.numerals = false;
        this.asString = s.id();
        if (this.subsorts.length > 0) {
            int i = 0;
            while (i < this.subsorts.length) {
                this.asString = String.valueOf(this.asString) + (i == 0 ? "[" : ",") + this.subsorts[i].toString();
                ++i;
            }
            this.asString = String.valueOf(this.asString) + "]";
        }
        this.asString = this.asString.intern();
        Integer UID = allSortsHashtable.get(this.asString);
        if (UID == null) {
            this.uid = nextUid++;
            allSortsHashtable.put(this.asString, new Integer(this.uid));
            allSortsVector.addElement(this);
        } else {
            this.uid = UID;
        }
    }

    protected sort(sort s) {
        this.constructor = s.constructor;
        this.id = s.id;
        this.subsorts = s.subsorts;
        this.numerals = s.numerals;
        this.asString = s.asString;
        this.uid = s.uid;
    }

    public sort reuse(sortConstructor c, sort[] v) {
        assert (v.length == this.subsorts.length) : "precondition is false";
        boolean same = true;
        int i = 0;
        while (same && i < v.length) {
            same = v[i].equals(this.subsorts[i]);
            ++i;
        }
        if (same) {
            v = this.subsorts;
        }
        return same && this.constructor.equals(this.constructor) ? this : new sort(v, c);
    }

    public sort newConstructor(sortConstructor c) {
        assert (this.subsorts.length == 0);
        return c.equals(this.constructor) ? this : new sort(this.subsorts, c);
    }

    public sort intern() {
        return allSortsVector.elementAt(allSortsVector.indexOf(this));
    }

    public void makeNumeral() {
        this.numerals = true;
    }

    public int hashCode() {
        return this.uid;
    }

    public boolean isSimple() {
        return this.subsorts.length == 0;
    }

    public boolean isCompound() {
        return this.subsorts.length != 0;
    }

    public int uid() {
        return this.uid;
    }

    public boolean containsConstructor(String s) {
        if (this.subsorts.length == 0) {
            return false;
        }
        if (this.id.equals(s)) {
            return true;
        }
        int i = 0;
        while (i < this.subsorts.length) {
            if (this.subsorts[i].containsConstructor(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof sort ? this.equals((sort)obj) : false;
    }

    public boolean equals(sort s) {
        return s == null ? false : this.uid == s.uid;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill();
        pp.put(this.id == null ? this.constructor.id() : this.id);
        if (this.subsorts.length != 0) {
            pp.put("[").list(this.subsorts, ",").put("]");
        }
        return pp.end();
    }

    public String toString() {
        return this.asString;
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        return SExp.makeSValue("s" + this.uid);
    }

    public static iprinter printAll(iprinter ip, Scope sc) {
        return sort.allToSValue(sc).print(ip);
    }

    public static SValue allToSValue(Scope sc) {
        SList list = SExp.makeSList(SExp.makeSValue("sorts"));
        Enumeration<sort> e = allSortsVector.elements();
        while (e.hasMoreElements()) {
            SList list1 = new SList();
            sort s = e.nextElement();
            list1.add(s.toSValue());
            list1.add(s.nSubsorts() == 0 ? new SString(s.id()) : s.constructor().toSValue());
            sort[] sorts = s.cloneSubsorts();
            SList list2 = new SList();
            int i = 0;
            while (i < sorts.length) {
                list2.add(sorts[i].toSValue());
                ++i;
            }
            list1.add(list2);
            if (s.hasNumerals()) {
                list1.add(SExp.makeSValue("lit"));
            }
            list1.add(sc.toSValue());
            list.add(list1);
        }
        return list;
    }

    public int compareTo(sort s) {
        return this.uid < s.uid ? -1 : (this.uid == s.uid ? 0 : 1);
    }

    public static int compareIds(String s1, String s2) {
        int a1 = sort.numericIndex(s1);
        int a2 = sort.numericIndex(s2);
        return a1 < 0 || a2 < 0 ? -2 : (a1 < a2 ? -1 : (a1 == a2 ? 0 : 1));
    }

    public static boolean isSubsort(sort s1, sort s2) {
        if (s1.subsorts.length > 0 || s2.subsorts.length > 0) {
            return s1.equals(s2);
        }
        int c = sort.compareIds(s1.id, s2.id);
        return c == -2 && s1.equals(s2) || c == -1 || c == 0;
    }

    private static int numericIndex(String id) {
        if (id.equals("DiscreteReal")) {
            id = "Real";
        } else if (id.equals("DiscreteAugmentedReal")) {
            id = "AugmentedReal";
        }
        int i = 0;
        while (i < numericSortId.length) {
            if (id.equals(numericSortId[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

