/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.checker.Options;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.substitution;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class simplify {
    public static term iterate(term t, Context x) {
        if (!Options.simplify()) {
            return t;
        }
        block5: while (true) {
            term previous = t;
            if ((t = simplify.term(t, x)) != previous) continue;
            switch (t.kind()) {
                case 0: {
                    if (t.nArgs() == 0) {
                        return t;
                    }
                    term[] args = new term[t.nArgs()];
                    boolean same = true;
                    int i = 0;
                    while (i < args.length) {
                        args[i] = simplify.iterate(t.arg(i), x);
                        same &= args[i] == t.arg(i);
                        ++i;
                    }
                    if (same) {
                        return t;
                    }
                    t = new term(t.op(), args);
                    continue block5;
                }
                case 1: {
                    term t1 = simplify.iterate(t.subterm(), x);
                    if (t1 == t.subterm()) {
                        return t;
                    }
                    t = new term(t.qfr(), t1);
                    continue block5;
                }
                case 2: {
                    return t;
                }
            }
            break;
        }
        throw new InternalError("simplify.iterate");
    }

    public static term term(term t, Context x) {
        switch (t.kind()) {
            case 0: {
                operator op = t.op();
                if (op.equals(booleans.andOp)) {
                    return simplify.conjunction(t, x);
                }
                if (op.equals(booleans.orOp)) {
                    return simplify.disjunction(t, x);
                }
                if (op.equals(booleans.iffOp)) {
                    return simplify.iff(t, x);
                }
                if (op.equals(booleans.notOp)) {
                    return simplify.negation(t, x);
                }
                if (op.equals(booleans.impliesOp)) {
                    return simplify.implication(t, x);
                }
                if (op.id().isEqualitySym()) {
                    return simplify.equality(t, x);
                }
                return t;
            }
            case 1: {
                term result = simplify.vacuousQfr(t);
                if (t != result) {
                    return result;
                }
                return t.qfr().isExists() ? simplify.existential(t, x) : simplify.universal(t, x);
            }
            case 2: {
                return t;
            }
        }
        throw new InternalError("simplify.term");
    }

    public static void collectArgs(Vector<term> v, operator op, term t) {
        if (t.kind() == 0 && op.equals(t.op())) {
            int i = 0;
            while (i < t.nArgs()) {
                simplify.collectArgs(v, op, t.arg(i));
                ++i;
            }
        } else {
            v.addElement(t);
        }
    }

    public static term conjunction(term t, Context x) {
        boolean same = true;
        Vector<term> v = new Vector<term>();
        simplify.collectArgs(v, booleans.andOp, t);
        int n = 0;
        while (n < v.size()) {
            term t1 = v.elementAt(n);
            Context x1 = x.copy();
            int i = 0;
            while (i < v.size()) {
                if (i != n) {
                    x1.assertTrue(v.elementAt(i));
                }
                ++i;
            }
            if (x1.isFalse(t1 = simplify.iterate(t1, x1))) {
                return booleans.falseTerm;
            }
            if (x1.isTrue(t1)) {
                v.remove(n);
                same = false;
                continue;
            }
            ++n;
        }
        return same ? t : simplify.unflatten(booleans.andOp, v, booleans.trueTerm);
    }

    public static term disjunction(term t, Context x) {
        boolean same = true;
        Vector<term> v = new Vector<term>();
        simplify.collectArgs(v, booleans.orOp, t);
        int n = 0;
        while (n < v.size()) {
            term t1 = v.elementAt(n);
            Context x1 = x.copy();
            int i = 0;
            while (i < v.size()) {
                if (i != n) {
                    x1.assertFalse(v.elementAt(i));
                }
                ++i;
            }
            if (x1.isTrue(t1 = simplify.iterate(t1, x1))) {
                return booleans.trueTerm;
            }
            if (x1.isFalse(t1)) {
                v.remove(n);
                same = false;
                continue;
            }
            ++n;
        }
        return same ? t : simplify.unflatten(booleans.orOp, v, booleans.falseTerm);
    }

    public static boolean isNegation(term t) {
        return t.kind() == 0 && t.op().equals(booleans.notOp);
    }

    public static boolean isNegation(term t1, term t2, Context x) {
        return simplify.isNegation(t1) && x.isEquiv(t1.arg(0), t2) || simplify.isNegation(t2) && x.isEquiv(t2.arg(0), t1);
    }

    public static term unflatten(operator op, Vector<term> v, term noArgs) {
        if (v.size() == 0) {
            return noArgs;
        }
        term[] termArray = new term[2];
        termArray[0] = v.firstElement();
        term[] args = termArray;
        int i = 1;
        while (i < v.size()) {
            args[1] = v.elementAt(i);
            args[0] = new term(op, args);
            ++i;
        }
        return args[0];
    }

    public static term iff(term t, Context x) {
        boolean same = true;
        Vector<term> v = new Vector<term>();
        simplify.collectArgs(v, booleans.iffOp, t);
        boolean falsify = false;
        int n = 0;
        while (n < v.size()) {
            term t1 = simplify.iterate(v.elementAt(n), x);
            boolean delete = x.isTrue(t1);
            if (!delete && x.isFalse(t1)) {
                falsify = !falsify;
                delete = true;
            }
            int toDelete = -1;
            int i = 0;
            while (i < n && !delete && toDelete < 0) {
                term t2 = simplify.iterate(v.elementAt(i), x);
                if (x.isEquiv(t1, t2)) {
                    toDelete = i;
                } else if (simplify.isNegation(t2, t1, x)) {
                    toDelete = i;
                    falsify = !falsify;
                }
                ++i;
            }
            if (delete || toDelete >= 0) {
                v.remove(n);
            } else {
                ++n;
            }
            if (toDelete >= 0) {
                v.remove(toDelete);
            }
            same &= !delete && toDelete < 0;
        }
        if (same) {
            return t;
        }
        t = simplify.unflatten(booleans.iffOp, v, booleans.trueTerm);
        if (!falsify) {
            return t;
        }
        term[] args = new term[]{t};
        return new term(args, booleans.notOp);
    }

    public static term equality(term t, Context x) {
        if (!x.isEquiv(simplify.iterate(t.arg(0), x), simplify.iterate(t.arg(1), x))) {
            return t;
        }
        return t.op().id().equals(opSym.eqSym) ? booleans.trueTerm : booleans.falseTerm;
    }

    public static term negation(term t, Context x) {
        term arg = simplify.iterate(t.arg(0), x);
        if (x.isTrue(arg)) {
            return booleans.falseTerm;
        }
        if (x.isTrue(arg)) {
            return booleans.trueTerm;
        }
        if (simplify.isNegation(arg)) {
            return arg.arg(0);
        }
        return t;
    }

    public static term implication(term t, Context x) {
        term hyp = t.arg(0);
        term con = t.arg(1);
        Context x1 = x.copy();
        x1.assertTrue(hyp);
        term con1 = simplify.iterate(con, x1);
        if (x1.isTrue(con1)) {
            return booleans.trueTerm;
        }
        if (x1.isFalse(con1)) {
            return simplify.isNegation(hyp) ? hyp.arg(0) : term.make(booleans.notOp, hyp);
        }
        Context x2 = x.copy();
        x2.assertFalse(con);
        term hyp1 = simplify.iterate(hyp, x2);
        if (x2.isTrue(hyp1)) {
            return con;
        }
        if (x2.isFalse(hyp1)) {
            return booleans.trueTerm;
        }
        return t;
    }

    public static term existential(term t, Context x) {
        term tOriginal = t;
        Vector<quantifier> qfrs = new Vector<quantifier>();
        Vector<variable> vars = new Vector<variable>();
        while (t.kind() == 1 && t.qfr().kind() == quantifier.EXISTS) {
            qfrs.addElement(t.qfr());
            vars.addElement(t.qfr().var());
            t = t.subterm();
        }
        return simplify.findVarEquals(vars, qfrs, tOriginal, t, true, null, true, x);
    }

    public static term universal(term t, Context x) {
        term tOriginal = t;
        Vector<quantifier> qfrs = new Vector<quantifier>();
        Vector<variable> vars = new Vector<variable>();
        while (t.kind() == 1 && t.qfr().kind() == quantifier.ALL) {
            qfrs.addElement(t.qfr());
            vars.addElement(t.qfr().var());
            t = t.subterm();
        }
        if (t.kind() == 0 && t.op().id().equals(opSym.impliesSym)) {
            term result = simplify.findVarEquals(vars, qfrs, tOriginal, t.arg(0), true, t.arg(1), true, x);
            if (result != tOriginal) {
                return result;
            }
            return simplify.findVarEquals(vars, qfrs, tOriginal, t.arg(1), false, t.arg(0), false, x);
        }
        return simplify.findVarEquals(vars, qfrs, tOriginal, t, false, null, true, x);
    }

    private static term findVarEquals(Vector<variable> vars, Vector<quantifier> qfrs, term tOriginal, term t, boolean isAnd, term tOther, boolean isConclusion, Context x) {
        return simplify.findVarEquals(vars, qfrs, tOriginal, t, new substitution(), isAnd, tOther, isConclusion, x);
    }

    public static term findVarEquals(Vector<variable> vars, Vector<quantifier> qfrs, term tOriginal, term t, substitution sigma, boolean isAnd, term tOther, boolean isConclusion, Context x) {
        operator op = isAnd ? booleans.andOp : booleans.orOp;
        Vector<term> subterms = new Vector<term>();
        simplify.collectArgs(subterms, op, t);
        int i = 0;
        while (i < subterms.size()) {
            block13: {
                opSym opId;
                term subterm;
                block12: {
                    subterm = subterms.elementAt(i);
                    if (isAnd) break block12;
                    if (subterm.kind() != 0 || !subterm.op().equals(booleans.notOp)) break block13;
                    subterm = subterm.arg(0);
                }
                if (subterm.kind() == 0 && ((opId = subterm.op().id()).equals(opSym.eqSym) || opId.equals(opSym.iffSym))) {
                    term vTerm = null;
                    term def = null;
                    int vIndex = 0;
                    while (vIndex < vars.size()) {
                        vTerm = new term(vars.elementAt(vIndex));
                        term lhs = subterm.arg(0);
                        term rhs = subterm.arg(1);
                        if (x.isEquiv(vTerm, lhs)) {
                            def = rhs;
                        } else if (x.isEquiv(vTerm, rhs)) {
                            def = lhs;
                        }
                        if (def != null) break;
                        ++vIndex;
                    }
                    if (def != null && !def.occursFreely(vars.elementAt(vIndex))) {
                        subterms.remove(i);
                        t = simplify.unflatten(op, subterms, isAnd ? booleans.trueTerm : booleans.falseTerm);
                        if (sigma == null) {
                            sigma = new substitution();
                        }
                        sigma.add(vTerm, def);
                        t = sigma.map(t);
                        if (tOther != null) {
                            term[] args = new term[]{isConclusion ? t : sigma.map(tOther), isConclusion ? sigma.map(tOther) : t};
                            t = new term(args, booleans.impliesOp);
                        }
                        qfrs.remove(vIndex);
                        return simplify.applyQuantifiers(qfrs, t);
                    }
                }
            }
            ++i;
        }
        return tOriginal;
    }

    private static term applyQuantifiers(Vector<quantifier> qfrs, term t) {
        int i = 0;
        while (i < qfrs.size()) {
            t = new term(qfrs.elementAt(i), t);
            ++i;
        }
        return t;
    }

    public static term vacuousQfr(term t) {
        term tOriginal = t;
        boolean eliminated = false;
        Vector<quantifier> qfrs = new Vector<quantifier>();
        while (t.kind() == 1) {
            if (!t.subterm().occursFreely(t.qfr().var())) {
                eliminated = true;
            } else {
                qfrs.addElement(t.qfr());
            }
            t = t.subterm();
        }
        return eliminated ? simplify.applyQuantifiers(qfrs, t) : tOriginal;
    }
}

