/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class signature
extends Unit
implements SPrintable {
    private sort[] domain;
    private sort range;
    private String asString;
    private int hashVal;

    public sort domain(int n) {
        if (n < 0 || this.domain.length <= n) {
            throw new InternalError("signature.dom");
        }
        return this.domain[n];
    }

    public sort range() {
        return this.range;
    }

    public signature(sort rng) {
        this.range = rng;
        this.domain = new sort[0];
        this.computeHashAndStringRep();
    }

    public signature(sort dom1, sort rng) {
        this.range = rng;
        sort[] d = new sort[]{dom1};
        this.domain = d;
        this.computeHashAndStringRep();
    }

    public signature(sort dom1, sort dom2, sort rng) {
        this.range = rng;
        sort[] d = new sort[]{dom1, dom2};
        this.domain = d;
        this.computeHashAndStringRep();
    }

    public signature(sort dom1, sort dom2, sort dom3, sort rng) {
        this.range = rng;
        sort[] d = new sort[]{dom1, dom2, dom3};
        this.domain = d;
        this.computeHashAndStringRep();
    }

    public signature(sort rng, sort[] dom) {
        this.domain = dom;
        this.range = rng;
        this.computeHashAndStringRep();
    }

    public signature(sort s, int n) {
        if (n < 0) {
            throw new InternalError("signature: negative arity");
        }
        this.domain = new sort[n];
        int i = 0;
        while (i < n) {
            this.domain[n] = s;
            ++i;
        }
        this.range = s;
        this.computeHashAndStringRep();
    }

    public int arity() {
        return this.domain.length;
    }

    public boolean equals(signature sig) {
        return this.asString.equals(sig.asString);
    }

    public boolean similar(signature sig) {
        return this.asString.equals(sig.asString);
    }

    public int hashCode() {
        return this.hashVal;
    }

    private void computeHashAndStringRep() {
        this.asString = "";
        this.hashVal = this.range.hashCode();
        int i = 0;
        while (i < this.domain.length) {
            if (i > 0) {
                this.asString = String.valueOf(this.asString) + ",";
            }
            this.asString = String.valueOf(this.asString) + this.domain[i].toString();
            this.hashVal = 17 * this.hashVal ^ this.domain[i].hashCode();
            ++i;
        }
        this.asString = String.valueOf(this.asString) + "->" + this.range.toString();
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill();
        if (this.domain.length != 0) {
            pp.list(this.domain, ",").blank();
        }
        return pp.put("->").blank().print(this.range).end();
    }

    public String toString() {
        return this.asString;
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = new SList();
        int i = 0;
        while (i < this.domain.length) {
            list.add(this.domain[i].toSValue());
            ++i;
        }
        SList v = SExp.makeSList(list, this.range.toSValue());
        return v;
    }
}

