/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.util.Iprintable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class replacement<T extends SPrintable, C>
implements Prettyprintable,
Iprintable {
    T from;
    C part;
    T to;
    boolean identity;
    boolean derived;
    private int hashVal;

    replacement(T from, C part) {
        if (from == null || part == null) {
            throw new InternalError("renaming.replacement: " + from + " " + part);
        }
        this.from = from;
        this.part = part;
        this.to = null;
        this.hashVal = 17 * from.hashCode() ^ part.hashCode();
    }

    boolean same(replacement<T, C> r) {
        return this.from.equals(r.from);
    }

    protected T cache(T to) {
        if (this.to != null && !this.to.equals(to) || to == null) {
            throw new InternalError("renamingMap.cache");
        }
        this.to = to;
        this.identity = this.from.equals(to);
        return to;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.align(0).fill();
        if (this.to instanceof operator) {
            if (this.part == null) {
                pp.put("<null>");
            } else {
                pp.print((Prettyprintable)this.part);
            }
        } else if (this.to == null) {
            pp.put("<null>");
        } else {
            pp.print((Prettyprintable)this.to);
        }
        pp.blank().put("for").blank();
        if (this.from == null) {
            pp.put("<null>");
        } else {
            pp.print((Prettyprintable)this.from);
        }
        return pp.end().end();
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SValue fromSV = this.from == null ? SExp.makeSValue("<null>") : this.from.toSValue();
        SValue toSV = this.to == null ? SExp.makeSValue("<null>") : this.to.toSValue();
        return SExp.makeSList(fromSV, toSV);
    }

    public int hashCode() {
        return this.hashVal;
    }
}

