/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.notions.replacement;
import com.veromodo.tioa.util.Iprintable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class renamingMap<T extends SPrintable, C>
implements Prettyprintable,
Iprintable,
Cloneable {
    private Hashtable<T, replacement<T, C>> tab;
    protected boolean trivial;
    protected boolean nonEmpty;
    private int hashVal;

    public renamingMap() {
        this(1);
    }

    public renamingMap(int size) {
        this.tab = new Hashtable(size);
        this.trivial = true;
        this.nonEmpty = false;
    }

    public boolean add(T from, C oldpart, C newpart) {
        if (newpart == null) {
            throw new InternalError("renaming.replacement.add");
        }
        replacement<T, C> r = new replacement<T, C>(from, newpart);
        replacement<T, C> oldVal = this.tab.put(from, r);
        this.nonEmpty = true;
        if (oldVal != null && !oldVal.part.equals(newpart)) {
            return false;
        }
        if (oldpart.equals(newpart)) {
            return true;
        }
        this.hashVal = 17 * this.hashVal ^ r.hashCode();
        this.trivial = false;
        return true;
    }

    public replacement<T, C> delete(T from) {
        return this.tab.remove(from);
    }

    protected T cache(T from, C part, T to) {
        if (from == null || part == null || to == null) {
            throw new InternalError("renaming.replacement.cache");
        }
        replacement<T, C> r = new replacement<T, C>(from, part);
        r.to = to;
        r.derived = true;
        replacement<T, C> oldVal = this.tab.put(from, r);
        if (oldVal != null && oldVal.part.equals(part) && oldVal.to != null && !oldVal.to.equals(to)) {
            throw new InternalError("renamingMap.cache");
        }
        return to;
    }

    public replacement<T, C> get(T from) {
        return this.tab.get(from);
    }

    public boolean same(int kind2, renaming r1, renaming r2, renamingMap<T, C> m2) {
        replacement<T, C> rep;
        renamingMap m1 = this;
        Enumeration<replacement<T, C>> e = m1.tab.elements();
        while (e.hasMoreElements()) {
            rep = e.nextElement();
            if (rep.identity || rep.to == r2.map(kind2, rep.from)) continue;
            return false;
        }
        e = m2.tab.elements();
        while (e.hasMoreElements()) {
            rep = e.nextElement();
            if (rep.identity || rep.to == r1.map(kind2, rep.from)) continue;
            return false;
        }
        return true;
    }

    public Enumeration<T> domain() {
        return this.tab.keys();
    }

    public renamingMap<T, C> clone() {
        renamingMap<T, C> r = new renamingMap<T, C>();
        r.tab = (Hashtable)this.tab.clone();
        r.trivial = this.trivial;
        r.hashVal = this.hashVal;
        return r;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.align(0);
        replacement<T, C> toPrint = null;
        Enumeration<replacement<T, C>> e = this.tab.elements();
        while (e.hasMoreElements()) {
            replacement<T, C> r = e.nextElement();
            if (r.identity || r.derived) continue;
            if (toPrint != null) {
                toPrint.print(pp.fill()).put(",").blank().end();
            }
            toPrint = r;
        }
        if (toPrint != null) {
            toPrint.print(pp.fill()).end();
        }
        return pp.end();
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = new SList();
        Enumeration<replacement<T, C>> e = this.tab.elements();
        while (e.hasMoreElements()) {
            replacement<T, C> r = e.nextElement();
            if (r.identity) continue;
            list.add(r.toSValue());
        }
        return list;
    }
}

