/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.PrintableString;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.actual;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.renamingMap;
import com.veromodo.tioa.notions.replacement;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortConstructor;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class renaming
extends Unit
implements Cloneable {
    private static renaming theIdentity;
    private renamingMap<sort, sort> sortMap;
    private renamingMap<sortConstructor, PrintableString> constructorMap;
    private renamingMap<operator, opSym> opMap;
    private renamingMap<variable, PrintableString> varMap;
    private Hashtable<variable, Integer> order;
    private int nextOrdinal = 1;
    private Hashtable<String, variable> inverseVarMap;
    private boolean trivial;
    private boolean frozen;
    private int hashVal;

    public static renaming theIdentity() {
        if (theIdentity == null) {
            theIdentity = new renaming();
            theIdentity.freeze();
        }
        return theIdentity;
    }

    public variable[] precedenceOrder() {
        variable[] ordered = new variable[this.order.size()];
        Enumeration<variable> e = this.order.keys();
        while (e.hasMoreElements()) {
            variable v;
            ordered[this.order.get((Object)v).intValue() - 1] = v = e.nextElement();
        }
        return ordered;
    }

    public renaming() {
        this(1);
    }

    public renaming(int size) {
        this.sortMap = new renamingMap(size);
        this.constructorMap = new renamingMap();
        this.opMap = new renamingMap(size);
        this.varMap = new renamingMap();
        this.frozen = false;
        this.trivial = true;
        this.inverseVarMap = new Hashtable();
        this.order = new Hashtable();
    }

    public boolean add(sort from, sort to) {
        if (this.frozen || from == null || to == null) {
            throw new InternalError("renaming.add sort " + from + "->" + to);
        }
        if (!this.sortMap.add(from, from, to)) {
            return false;
        }
        replacement<sort, sort> r = this.sortMap.get(from);
        if (from.hasNumerals()) {
            to.makeNumeral();
        }
        r.cache(to);
        return true;
    }

    public boolean add(sortConstructor from, String to) {
        if (this.frozen) {
            throw new InternalError("renaming.add sort constructor");
        }
        return this.constructorMap.add(from, new PrintableString(from.id()), new PrintableString(to));
    }

    public boolean add(operator from, opSym newId) {
        if (this.frozen) {
            throw new InternalError("renaming.add operator");
        }
        return this.opMap.add(from, from.id(), newId);
    }

    public boolean clashes(variable v) {
        if (!this.frozen) {
            throw new InternalError("renaming.clashes");
        }
        sort s = this.map(v.sort());
        variable image = v.sort() == s ? v : new variable(v.id(), s, v.kind());
        variable preimage = this.inverseVarMap.get(image.toString());
        return preimage != null;
    }

    public variable add(variable v) {
        if (!this.frozen || this.order.get(v) != 0 || this.varMap.get(v) != null) {
            throw new InternalError("renaming.add(variable)");
        }
        sort s = this.map(v.sort());
        variable image = v.sort() == s ? v : new variable(v.id(), s, v.kind());
        variable preimage = this.inverseVarMap.get(image.toString());
        if (this.clashes(v)) {
            image = image.makeDifferentExternal();
        }
        this.order.put(v, this.nextOrdinal++);
        this.inverseVarMap.put(image.toString(), v);
        this.varMap.cache(v, new PrintableString(v.id()), image);
        this.freeze();
        return image;
    }

    public void add(variable[] v) {
        int i = 0;
        while (i < v.length) {
            this.add(v[i]);
            ++i;
        }
    }

    public variable delete(variable v) {
        variable to;
        if (!this.frozen) {
            throw new InternalError("renaming.delete(variable)");
        }
        this.order.remove(v);
        replacement<variable, PrintableString> cached = this.varMap.delete(v);
        variable variable2 = to = cached == null || cached.to == null ? null : (variable)cached.to;
        if (to != null) {
            this.inverseVarMap.remove(to.toString());
        }
        this.freeze();
        return to;
    }

    public variable[] delete(variable[] from) {
        variable[] to = new variable[from.length];
        int i = 0;
        while (i < from.length) {
            to[i] = this.delete(from[i]);
            ++i;
        }
        return to;
    }

    public void freeze() {
        this.frozen = true;
        this.hashVal = this.sortMap.hashCode() ^ 17 * this.constructorMap.hashCode();
        this.hashVal ^= 17 * (this.opMap.hashCode() ^ 17 * this.varMap.hashCode());
        this.hashVal ^= 17 * (this.inverseVarMap.hashCode() ^ 17 * this.order.hashCode());
        this.sortMap.trivial = this.sortMap.trivial && this.constructorMap.trivial;
        this.trivial = this.sortMap.trivial && this.opMap.trivial && this.varMap.trivial;
    }

    public boolean frozen() {
        return this.frozen;
    }

    public renaming compose(renaming r) {
        operator op;
        actual s;
        if (!this.frozen || !r.frozen) {
            throw new InternalError("renaming.compose");
        }
        if (this.trivial) {
            return r;
        }
        renaming result = new renaming();
        Enumeration<actual> e = this.sortMap.domain();
        while (e.hasMoreElements()) {
            s = e.nextElement();
            result.add((sort)s, r.map(this.map((sort)s)));
        }
        e = r.sortMap.domain();
        while (e.hasMoreElements()) {
            s = e.nextElement();
            result.add((sort)s, r.map((sort)s));
        }
        e = this.constructorMap.domain();
        while (e.hasMoreElements()) {
            s = (sortConstructor)e.nextElement();
            result.add((sortConstructor)s, ((sortConstructor)r.constructorMap.get((sortConstructor)s).to).id());
        }
        e = r.constructorMap.domain();
        while (e.hasMoreElements()) {
            s = (sortConstructor)e.nextElement();
            sortConstructor s1 = (sortConstructor)this.constructorMap.get((sortConstructor)s).to;
            result.add((sortConstructor)s, ((sortConstructor)r.constructorMap.get((sortConstructor)s1).to).id());
        }
        e = this.opMap.domain();
        while (e.hasMoreElements()) {
            op = (operator)e.nextElement();
            result.add(op, r.map(this.map(op)).id());
        }
        e = r.opMap.domain();
        while (e.hasMoreElements()) {
            op = (operator)e.nextElement();
            result.add(op, r.map(op).id());
        }
        result.freeze();
        return result;
    }

    public sort map(sort s) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(sort)");
        }
        if (this.sortMap.trivial) {
            return s;
        }
        replacement<sort, sort> cached = this.sortMap.get(s);
        if (cached != null) {
            if (cached.to == null) {
                this.sortMap.print(prettyprinter.stdout());
                throw new InternalError("renaming.map(sort): " + s + " " + cached.part);
            }
            return (sort)cached.to;
        }
        if (s.isSimple()) {
            return s;
        }
        sortConstructor con = s.constructor();
        sort[] subsorts = new sort[s.nSubsorts()];
        int i = 0;
        while (i < subsorts.length) {
            subsorts[i] = this.map(s.subsort(i));
            ++i;
        }
        sort s1 = s.reuse(con, subsorts);
        if (s.hasNumerals()) {
            s1.makeNumeral();
        }
        return this.sortMap.cache(s, s, s1);
    }

    public sortConstructor map(sortConstructor c) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(sortConstructor)");
        }
        if (this.constructorMap.trivial || c == null) {
            return c;
        }
        replacement<sortConstructor, PrintableString> cached = this.constructorMap.get(c);
        if (cached != null) {
            if (cached.to == null) {
                throw new InternalError("renaming.map(sortConstructor)");
            }
            return (sortConstructor)cached.to;
        }
        return c;
    }

    public operator map(operator op) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(operator)");
        }
        if (this.opMap.trivial && this.sortMap.trivial) {
            return op;
        }
        replacement<operator, opSym> cached = this.opMap.get(op);
        if (cached != null && cached.to != null) {
            return (operator)cached.to;
        }
        signature sig = this.sortMap.trivial ? op.sig() : this.map(op.sig());
        opSym id = cached == null ? op.id() : (opSym)cached.part;
        operator op1 = sig == op.sig() && id.equals(op.id()) ? op : new operator(id, sig);
        return cached == null ? this.opMap.cache(op, op.id(), op1) : cached.cache(op1);
    }

    public variable map(variable v) {
        if (!this.frozen()) {
            throw new InternalError("renaming.map(variable)");
        }
        replacement<variable, PrintableString> cached = this.varMap.get(v);
        if (cached == null || cached.to == null) {
            throw new InternalError("renaming.map(variable): " + v + ":" + v.toSValue() + " not cached");
        }
        return (variable)cached.to;
    }

    public variable[] map(variable[] v) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(variable[]");
        }
        boolean changed = false;
        variable[] w = new variable[v.length];
        int i = 0;
        while (i < v.length) {
            w[i] = this.map(v[i]);
            if (v[i] != w[i]) {
                changed = true;
            }
            ++i;
        }
        return changed ? w : v;
    }

    public signature map(signature sig) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(signature)");
        }
        if (this.sortMap.trivial) {
            return sig;
        }
        boolean sameDomain = true;
        sort[] dom = new sort[sig.arity()];
        int i = 0;
        while (i < dom.length) {
            dom[i] = this.map(sig.domain(i));
            sameDomain &= dom[i] == sig.domain(i);
            ++i;
        }
        sort range = this.map(sig.range());
        return sameDomain && range == sig.range() ? sig : new signature(range, dom);
    }

    public term map(term t) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(term)");
        }
        if (this.trivial) {
            return t;
        }
        switch (t.kind()) {
            case 0: {
                operator op = this.map(t.op());
                term[] args = new term[t.nArgs()];
                int i = 0;
                while (i < args.length) {
                    args[i] = this.map(t.arg(i));
                    ++i;
                }
                return t.reuse(op, args);
            }
            case 1: {
                quantifier q = t.qfr();
                this.add(q.var());
                variable v = this.map(q.var());
                term t1 = this.map(t.subterm());
                this.delete(q.var());
                return v == q.var() && t1 == t.subterm() ? t : new term(new quantifier(q.kind(), v), t1);
            }
            case 2: {
                variable v = this.map(t.var());
                return v == t.var() ? t : new term(v);
            }
        }
        throw new InternalError("renaming.map(term)");
    }

    public term[] map(term[] t) {
        if (!this.frozen) {
            throw new InternalError("renaming.map(term[]");
        }
        boolean changed = false;
        term[] u = new term[t.length];
        int i = 0;
        while (i < t.length) {
            u[i] = this.map(t[i]);
            if (t[i] != u[i]) {
                changed = true;
            }
            ++i;
        }
        return changed ? u : t;
    }

    protected <T> Object map(int kind2, T n) {
        switch (kind2) {
            case 1: {
                return this.map((sort)n);
            }
            case 2: {
                return this.map((sortConstructor)n);
            }
            case 3: {
                return this.map((operator)n);
            }
            case 4: {
                return this.map((variable)n);
            }
        }
        throw new InternalError("renaming.map(Object)");
    }

    public boolean isIdentity() {
        if (!this.frozen) {
            throw new InternalError("renaming.isIdentity");
        }
        return this.trivial;
    }

    public boolean equals(renaming r) {
        if (!this.frozen || !r.frozen) {
            throw new InternalError("renaming.equals");
        }
        return this.hashVal == r.hashVal && this.trivial == r.trivial && this.sortMap.same(1, this, r, r.sortMap) && this.constructorMap.same(2, this, r, r.constructorMap) && this.opMap.same(3, this, r, r.opMap) && this.varMap.same(4, this, r, r.varMap);
    }

    public Object clone() {
        renaming r = new renaming();
        r.sortMap = this.sortMap.clone();
        r.constructorMap = this.constructorMap.clone();
        r.opMap = this.opMap.clone();
        r.varMap = this.varMap.clone();
        r.inverseVarMap = (Hashtable)this.inverseVarMap.clone();
        r.order = (Hashtable)this.order.clone();
        r.trivial = this.trivial;
        r.frozen = this.frozen;
        r.hashVal = this.hashVal;
        return r;
    }

    public int hashCode() {
        if (!this.frozen) {
            throw new InternalError("renaming.hashCode");
        }
        return this.hashVal;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        if (this.trivial) {
            return pp;
        }
        variable[] ordered = this.precedenceOrder();
        if (ordered.length > 0) {
            pp.align(0).fill().put("[");
            int i = 0;
            while (i < ordered.length) {
                pp.print(ordered[i]);
                if (i < ordered.length - 1) {
                    pp.put(",").blank();
                }
                ++i;
            }
            pp.put("]").eol().end().end();
        }
        this.sortMap.print(pp);
        if (this.sortMap.nonEmpty && this.constructorMap.nonEmpty) {
            pp.put(",").blank();
        }
        this.constructorMap.print(pp);
        if ((this.sortMap.nonEmpty || this.constructorMap.nonEmpty) && this.opMap.nonEmpty) {
            pp.put(",").blank();
        }
        this.opMap.print(pp);
        return pp;
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("rename"));
        variable[] ordered = this.precedenceOrder();
        SList plist = new SList();
        int i = 0;
        while (i < ordered.length) {
            plist.add(ordered[i].toSValue());
            ++i;
        }
        list.add(plist);
        list.addAll((Collection)((Object)this.sortMap.toSValue()));
        list.addAll((Collection)((Object)this.constructorMap.toSValue()));
        list.addAll((Collection)((Object)this.opMap.toSValue()));
        list.addAll((Collection)((Object)this.varMap.toSValue()));
        return list;
    }
}

