/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class quantifier
extends Unit
implements SPrintable {
    private int kind;
    public static int ALL = 0;
    public static int EXISTS = 1;
    private String[] symbols = new String[]{"\\A ", "\\E "};
    private variable var;
    private int hashVal;

    public boolean isAll() {
        return this.kind == ALL;
    }

    public boolean isExists() {
        return this.kind == EXISTS;
    }

    public int kind() {
        return this.kind;
    }

    public variable var() {
        return this.var;
    }

    public quantifier(int k, variable v) {
        if (k != ALL && k != EXISTS) {
            throw new InternalError("quantifier.quantifier");
        }
        this.kind = k;
        this.var = v;
        this.hashVal = 17 * k + v.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof quantifier ? this.equals((quantifier)obj) : false;
    }

    public boolean equals(quantifier q) {
        return q != null && this.kind == q.kind && this.var.equals(q.var);
    }

    public int hashCode() {
        return this.hashVal;
    }

    public prettyprinter print(prettyprinter pp) {
        return pp.put(this.symbols[this.kind]).print(this.var);
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue(this.kind == ALL ? "all" : "exists"));
        list.add(this.var.toSValue());
        return list;
    }
}

