/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.actual;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class operator
extends actual
implements SPrintable {
    private opSym id;
    private signature sig;
    private String asString;
    private int uid;
    private HashSet<Scope> knownScopes = new HashSet();
    private static int nextUid = 0;
    private static Hashtable<String, Integer> allOpsHashtable = new Hashtable(20);
    private static Vector<operator> allOpsVector = new Vector(30);
    private static Hashtable<sort, operator> eqOps = new Hashtable(20);

    public opSym id() {
        return this.id;
    }

    public signature sig() {
        return this.sig;
    }

    public int uid() {
        return this.uid;
    }

    public static operator get(int n) {
        int low = 0;
        int high = allOpsVector.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            operator op = allOpsVector.elementAt(mid);
            if (op.uid == n) {
                return op;
            }
            if (op.uid < n) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return null;
    }

    public operator(opSym id, signature s) {
        this.id = id;
        this.sig = s;
        this.asString = id + ":" + s.toString();
        Integer UID = allOpsHashtable.get(this.asString);
        if (UID == null) {
            if (this.isNumeral()) {
                try {
                    this.uid = Integer.parseInt(id.string());
                }
                catch (NumberFormatException e) {
                    this.uid = nextUid++;
                }
            } else {
                this.uid = nextUid++;
            }
            allOpsHashtable.put(this.asString, new Integer(this.uid));
            allOpsVector.addElement(this);
            if (id.equals(opSym.eqSym)) {
                eqOps.put(s.domain(0), this);
            }
        } else {
            this.uid = UID;
        }
    }

    public void addDeclarationScope(Scope s) {
        this.knownScopes.add(s);
    }

    public void undefine() {
        allOpsVector.removeElement(this);
        allOpsHashtable.remove(this.asString);
    }

    public boolean isNumeral() {
        return this.sig.arity() == 0 && this.id.isNumeral();
    }

    public int arity() {
        return this.sig.arity();
    }

    public int opKind() {
        return this.id.kind();
    }

    public boolean equals(Object obj) {
        return obj instanceof operator ? this.equals((operator)obj) : false;
    }

    public boolean equals(operator op) {
        return this.similar(op);
    }

    public boolean similar(operator op) {
        return op != null && this.id.equals(op.id) && this.sig.similar(op.sig);
    }

    public int hashCode() {
        return 17 * this.id.hashCode() + this.sig.hashCode();
    }

    public prettyprinter print(prettyprinter pp) {
        return pp.fill().print(this.id).put(":").blank().print(this.sig).end();
    }

    public static prettyprinter print(prettyprinter pp, operator[] list, factoring f) {
        boolean inFactor = false;
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                pp.put(",").blank();
            }
            if (f.last(i)) {
                list[i].print(pp);
                if (inFactor) {
                    pp.end();
                }
                inFactor = false;
            } else {
                if (!inFactor) {
                    pp.fill();
                }
                pp.print(list[i].id());
                inFactor = true;
            }
            ++i;
        }
        return pp;
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public iprinter iprintLit(iprinter ip) {
        return this.isNumeral() ? ip.fill().put("lit").print(this.sig.range()).put(this.id.string()).end() : this.print(ip);
    }

    public SValue litSValue() {
        if (this.isNumeral()) {
            SList list = SExp.makeSList(SExp.makeSValue("lit"));
            list.add(this.sig.range().toSValue());
            list.add(SExp.makeSValue(this.id.string()));
            return list;
        }
        return this.toSValue();
    }

    public SValue toSValue() {
        return SExp.makeSValue("op" + this.uid);
    }

    public static iprinter printAll(iprinter ip, Scope sc) {
        return operator.allToSValue().print(ip);
    }

    public static SValue allToSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("ops"));
        Enumeration<operator> e = allOpsVector.elements();
        while (e.hasMoreElements()) {
            operator op = e.nextElement();
            if (op.isNumeral() && op.sig().range().hasNumerals()) continue;
            SList scopeList = SExp.makeSList(SExp.makeSValue("scope"));
            for (Scope s : op.knownScopes) {
                scopeList.add(SExp.makeSValue(s.toString()));
            }
            list.add(SExp.makeSList(op.toSValue(), op.id().toSValue(), op.sig().toSValue(), scopeList));
        }
        return list;
    }

    public int compareTo(operator op) {
        if (this.isNumeral()) {
            if (!op.isNumeral()) {
                return -1;
            }
            int c = this.id.string().compareTo(op.id.string());
            return c == 0 ? this.sig.range().compareTo(op.sig().range()) : c;
        }
        if (op.isNumeral()) {
            return 1;
        }
        return this.uid < op.uid ? -1 : (this.uid == op.uid ? 0 : 1);
    }

    public static operator eqOp(sort s) {
        return eqOps.get(s);
    }
}

