/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.util.StringOps;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class opSym
extends Unit
implements SPrintable {
    private String string;
    private String closeString;
    private int arity;
    private boolean argBefore;
    private boolean argAfter;
    private int priority;
    private int hashVal;
    private int kind;
    public static final int CONST = 0;
    public static final int FCT = 1;
    public static final int IF = 2;
    public static final int INFIX = 3;
    public static final int MIXFIX = 4;
    public static final int NUMERAL = 5;
    public static final int POSTFIX = 6;
    public static final int PREFIX = 7;
    public static final int QFR = 8;
    public static final int SELECT = 9;
    public static final int SOMEFIX = 10;
    private static final int[] priorities = new int[]{10, 10, 1, 6, 7, 10, 6, 6, 9, 6, 6};
    private static final int[] arities;
    private static final boolean[] argBefores;
    private static final boolean[] argAfters;
    public static opSym allSym;
    public static opSym andSym;
    public static opSym dotSym;
    public static opSym derivSym;
    public static opSym eqSym;
    public static opSym existsSym;
    public static opSym falseSym;
    public static opSym ifSym;
    public static opSym iffSym;
    public static opSym impliesSym;
    public static opSym neqSym;
    public static opSym notSym;
    public static opSym orSym;
    public static opSym trueSym;

    static {
        int[] nArray = new int[11];
        nArray[1] = -1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = -1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[9] = 1;
        nArray[10] = -1;
        arities = nArray;
        boolean[] blArray = new boolean[11];
        blArray[3] = true;
        blArray[6] = true;
        blArray[9] = true;
        argBefores = blArray;
        boolean[] blArray2 = new boolean[11];
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[7] = true;
        argAfters = blArray2;
        allSym = new opSym(8, "\\A", 9);
        andSym = new opSym(3, "/\\", 4);
        derivSym = new opSym(1, "d", 10);
        dotSym = new opSym(3, ".", 8);
        eqSym = new opSym(3, "=", 5);
        existsSym = new opSym(8, "\\E", 9);
        falseSym = new opSym(0, "false", 10);
        ifSym = new opSym(2, "if", 1);
        iffSym = new opSym(3, "<=>", 2);
        impliesSym = new opSym(3, "=>", 3);
        neqSym = new opSym(3, "~=", 5);
        notSym = new opSym(7, "~", 6);
        orSym = new opSym(3, "\\/", 4);
        trueSym = new opSym(0, "true", 10);
    }

    public String string() {
        return this.string;
    }

    public String closeString() {
        return this.closeString;
    }

    public int arity() {
        return this.arity;
    }

    public boolean argBefore() {
        return this.argBefore;
    }

    public boolean argAfter() {
        return this.argAfter;
    }

    public int priority() {
        return this.priority;
    }

    public int kind() {
        return this.kind;
    }

    public opSym(int kind2, String s) {
        if (kind2 < 0 || kind2 > 10 || kind2 == 4) {
            throw new InternalError("opSym.opSym");
        }
        this.kind = kind2;
        this.string = s;
        if (kind2 == 0 || kind2 == 5) {
            if (StringOps.allCharsIn(this.string, "0123456789")) {
                this.kind = 5;
            } else if (this.kind == 5) {
                throw new InternalError("opSym.opSym bad numeral");
            }
        }
        this.arity = arities[this.kind];
        this.argBefore = argBefores[this.kind];
        this.argAfter = argAfters[this.kind];
        this.priority = priorities[this.kind];
        this.computeHash();
    }

    private opSym(int kind2, String s, int p) {
        this(kind2, s);
        this.priority = p;
        this.computeHash();
    }

    public opSym(boolean argBefore, String openString, int argsBetween, String closeString, boolean argAfter) {
        this.kind = 4;
        this.string = openString;
        this.closeString = closeString;
        this.priority = priorities[4];
        this.argBefore = argBefore;
        this.argAfter = argAfter;
        this.arity = argsBetween + (argBefore ? 1 : 0) + (argAfter ? 1 : 0);
        this.computeHash();
    }

    public void setArity(int n) {
        if (this.arity >= 0) {
            throw new InternalError("opSym.setArity");
        }
        this.arity = n;
        if (this.arity == 0) {
            this.kind = StringOps.allCharsIn(this.string, "0123456789") ? 5 : 0;
        } else if (this.arity == 2 && this.kind == 10) {
            this.kind = 3;
        } else {
            return;
        }
        this.arity = arities[this.kind];
        this.argBefore = argBefores[this.kind];
        this.argAfter = argAfters[this.kind];
        this.priority = priorities[this.kind];
        this.computeHash();
    }

    public void setKind(int n) {
        if (this.kind != 10) {
            throw new InternalError("opSym.setKind");
        }
        this.kind = n;
        this.arity = arities[this.kind];
        this.argBefore = argBefores[this.kind];
        this.argAfter = argAfters[this.kind];
        this.priority = priorities[this.kind];
        this.computeHash();
    }

    public void setSelectionMarker(boolean present) {
        if (this.kind != 9) {
            throw new InternalError("opSym.setSelectionMarker");
        }
        this.argBefore = present;
    }

    public int hashCode() {
        return this.hashVal;
    }

    private void computeHash() {
        this.hashVal = 17 * this.kind + this.string.hashCode();
        if (this.kind == 4) {
            this.hashVal ^= 19 * this.closeString.hashCode() ^ 17 * this.arity ^ (this.argBefore ? 4 : 0) ^ (this.argAfter ? 8 : 0);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof opSym ? this.equals((opSym)obj) : false;
    }

    public boolean equals(opSym op) {
        if (op == null || this.kind != op.kind || this.hashVal != op.hashVal) {
            return false;
        }
        switch (this.kind) {
            case 2: {
                return true;
            }
            case 4: {
                return this.string.equals(op.string) && this.closeString.equals(op.closeString) && this.arity == op.arity && this.argBefore == op.argBefore && this.argAfter == op.argAfter;
            }
        }
        return this.string.equals(op.string);
    }

    public boolean similar(opSym op) {
        return op == null ? false : (this.canBeZeroary() && op.canBeZeroary() ? op.string.equals(this.string) : (this.isSomefix() && op.isSomefix() ? op.string.equals(this.string) : this.equals(op)));
    }

    public boolean isEqualitySym() {
        return this.equals(eqSym) || this.equals(neqSym);
    }

    public boolean isNumeral() {
        return this.kind == 5;
    }

    public boolean isLogicalSym() {
        return this.equals(andSym) || this.equals(orSym) || this.equals(impliesSym) || this.equals(iffSym);
    }

    public boolean isComparisonSym() {
        return this.kind == 3 && (this.string.equals("<") || this.string.equals("<=") || this.string.equals(">") || this.string.equals(">="));
    }

    public boolean canBeZeroary() {
        switch (this.kind) {
            case 0: 
            case 1: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isSomefix() {
        switch (this.kind) {
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean leftAssociative() {
        return this.equals(iffSym) || this.equals(andSym) || this.equals(orSym) || this.equals(dotSym);
    }

    public static opSym bracketOp(boolean argBefore, int argsBetween, boolean argAfter) {
        return new opSym(argBefore, "[", argsBetween, "]", argAfter);
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill();
        if (this.argBefore) {
            pp.put("__");
        }
        if (this.kind == 9) {
            return pp.put("." + this.string).end();
        }
        pp.put(this.string);
        if (this.closeString != null) {
            int n = this.arity;
            if (this.argBefore) {
                --n;
            }
            if (this.argAfter) {
                --n;
            }
            int i = 0;
            while (i < n) {
                pp.put("__");
                if (i < n - 1) {
                    pp.put(",").blank(0);
                }
                ++i;
            }
            pp.put(this.closeString);
        }
        if (this.kind == 2) {
            pp.put("__").put("then").put("__").put("else");
        }
        if (this.argAfter) {
            pp.put("__");
        }
        return pp.end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        switch (this.kind()) {
            case 0: {
                return SExp.makeSList(SExp.makeSValue("id"), SExp.makeSValue(this.string));
            }
            case 5: {
                return SExp.makeSList(SExp.makeSValue("const"), SExp.makeSValue(this.string));
            }
            case 1: {
                return SExp.makeSList(SExp.makeSValue("id"), SExp.makeSValue(this.string));
            }
            case 2: {
                return SExp.makeSList(SExp.makeSValue("if"));
            }
            case 3: {
                return SExp.makeSList(SExp.makeSValue("infix"), SExp.makeSValue(this.string));
            }
            case 4: {
                SList l = SExp.makeSList(SExp.makeSValue("mixfix"), SExp.makeSValue(this.arity), SExp.makeSValue(this.argBefore), SExp.makeSValue(this.argAfter), SExp.makeSValue(this.string));
                l.add(SExp.makeSValue(this.closeString));
                return l;
            }
            case 6: {
                return SExp.makeSList(SExp.makeSValue("postfix"), SExp.makeSValue(this.string));
            }
            case 7: {
                return SExp.makeSList(SExp.makeSValue("prefix"), SExp.makeSValue(this.string));
            }
            case 9: {
                return SExp.makeSList(SExp.makeSValue("select"), SExp.makeSValue(this.string));
            }
        }
        throw new InternalError("opSym.print");
    }
}

