/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortConstructor;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;

public class formal
extends Unit
implements SPrintable {
    private kind theKind;
    private term constant;
    private operator op;
    private sort type;
    private sortConstructor typeCon;
    private variable var;

    public kind kind() {
        return this.theKind;
    }

    public String kind2String() {
        switch (this.theKind) {
            case CONST: {
                return "const";
            }
            case OP: {
                return "operator";
            }
            case TYPE: {
                return "type";
            }
            case TYPECON: {
                return "type constructor";
            }
            case VAR: {
                return "variable";
            }
        }
        throw new InternalError("formal.kind2String");
    }

    public term constant() {
        if (this.theKind != kind.CONST) {
            throw new InternalError("formal.constant");
        }
        return this.constant;
    }

    public operator op() {
        if (this.theKind != kind.OP) {
            throw new InternalError("formal.op");
        }
        return this.op;
    }

    public sort type() {
        if (this.theKind != kind.TYPE) {
            throw new InternalError("formal.type");
        }
        return this.type;
    }

    public sortConstructor typeCon() {
        if (this.theKind != kind.TYPECON) {
            throw new InternalError("formal.typeCon");
        }
        return this.typeCon;
    }

    public variable var() {
        if (this.theKind != kind.VAR) {
            throw new InternalError("formal.var");
        }
        return this.var;
    }

    public formal(term t) {
        this.theKind = kind.CONST;
        this.constant = t;
    }

    public formal(operator o) {
        this.theKind = kind.OP;
        this.op = o;
    }

    public formal(sort s) {
        this.theKind = kind.TYPE;
        this.type = s;
    }

    public formal(sortConstructor s) {
        this.theKind = kind.TYPECON;
        this.typeCon = s;
    }

    public formal(variable v) {
        this.theKind = kind.VAR;
        this.var = v;
    }

    public sort sort() {
        switch (this.theKind) {
            case CONST: {
                return this.constant.sort();
            }
            case TYPE: {
                return sort.typeSort;
            }
            case VAR: {
                return this.var.sort();
            }
        }
        throw new InternalError("formal.sort");
    }

    public boolean equals(Object obj) {
        return obj instanceof formal ? this.equals((formal)obj) : false;
    }

    public boolean equals(formal f) {
        if (f == null || f.theKind != this.theKind) {
            return false;
        }
        switch (this.theKind) {
            case CONST: {
                return this.constant.equals(f.constant);
            }
            case OP: {
                return this.op.equals(f.op);
            }
            case TYPE: {
                return this.type.equals(f.type);
            }
            case TYPECON: {
                return this.typeCon.equals(f.typeCon);
            }
            case VAR: {
                return this.var.equals(f.var);
            }
        }
        throw new InternalError("formal.equals");
    }

    public static boolean sameTypes(formal[] f1, formal[] f2) {
        if (f1 == null || f2 == null || f1.length != f2.length) {
            return false;
        }
        int i = 0;
        while (i < f1.length) {
            if (!f1[i].sort().equals(f2[i].sort())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public prettyprinter print(prettyprinter pp) {
        switch (this.theKind) {
            case CONST: {
                return pp.fill().put("const").blank().print(this.constant).end();
            }
            case OP: {
                return pp.print(this.op);
            }
            case TYPE: {
                return pp.fill().print(this.type).put(":").blank().put("type").end();
            }
            case TYPECON: {
                return pp.print(this.typeCon);
            }
            case VAR: {
                return pp.print(this.var);
            }
        }
        throw new InternalError("formal.print(prettyprinter)");
    }

    public static prettyprinter print(prettyprinter pp, formal[] list, factoring f) {
        pp.fill(1).put("(");
        boolean inFactor = false;
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                pp.put(",").blank();
            }
            if (f.last(i)) {
                list[i].print(pp);
                if (inFactor) {
                    pp.end();
                }
                inFactor = false;
            } else {
                if (!inFactor) {
                    pp.fill();
                }
                switch (list[i].theKind) {
                    case TYPE: {
                        pp.print(list[i].type);
                        break;
                    }
                    case VAR: {
                        pp.put(list[i].var.id());
                        break;
                    }
                    default: {
                        pp.flush();
                        throw new InternalError("formal: factored print");
                    }
                }
                inFactor = true;
            }
            ++i;
        }
        return pp.put(")").end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        switch (this.theKind) {
            case CONST: {
                SList constantList = SExp.makeSList(SExp.makeSValue("const"));
                constantList.add(this.constant.toSValue());
                return constantList;
            }
            case OP: {
                return this.op.toSValue();
            }
            case TYPE: {
                return this.type.toSValue();
            }
            case TYPECON: {
                return this.typeCon.toSValue();
            }
            case VAR: {
                return this.var.toSValue();
            }
        }
        throw new InternalError("formal.print(iprinter)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum kind {
        CONST,
        OP,
        TYPE,
        TYPECON,
        VAR;

    }
}

