/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;

public class booleans {
    private static signature[] boolSigs = new signature[]{new signature(sort.boolSort), new signature(sort.boolSort, sort.boolSort), new signature(sort.boolSort, sort.boolSort, sort.boolSort), new signature(sort.boolSort, sort.boolSort, sort.boolSort, sort.boolSort)};
    public static operator andOp = new operator(opSym.andSym, boolSigs[2]);
    public static operator falseOp = new operator(opSym.falseSym, boolSigs[0]);
    public static term falseTerm = term.make(falseOp);
    public static operator iffOp = new operator(opSym.iffSym, boolSigs[2]);
    public static operator impliesOp = new operator(opSym.impliesSym, boolSigs[2]);
    public static operator notOp = new operator(opSym.notSym, boolSigs[1]);
    public static operator orOp = new operator(opSym.orSym, boolSigs[2]);
    public static operator trueOp = new operator(opSym.trueSym, boolSigs[0]);
    public static term trueTerm = term.make(trueOp);

    public static term negate(term operand) {
        if (operand.isTrue()) {
            return falseTerm;
        }
        if (operand.isFalse()) {
            return trueTerm;
        }
        if (operand.kind() == 0 && operand.op().equals(notOp)) {
            return operand.arg(0);
        }
        return term.make(notOp, operand);
    }

    public static term conjoin(term[] terms) {
        if (terms.length == 0) {
            return trueTerm;
        }
        term result = terms[0];
        int i = 1;
        while (i < terms.length) {
            result = booleans.conjoin(result, terms[i]);
            ++i;
        }
        return result;
    }

    public static term disjoin(term[] terms) {
        if (terms.length == 0) {
            return falseTerm;
        }
        term result = terms[0];
        int i = 1;
        while (i < terms.length) {
            result = booleans.disjoin(result, terms[i]);
            ++i;
        }
        return result;
    }

    public static term imply(term[] antecedants, term consequent) {
        if (antecedants.length == 0) {
            return trueTerm;
        }
        term antecedant = booleans.conjoin(antecedants);
        return booleans.imply(antecedant, consequent);
    }

    public static term conjoin(term left, term right) {
        if (left.isTrue()) {
            return right;
        }
        if (right.isTrue() || left.equals(right)) {
            return left;
        }
        if (left.isFalse() || right.isFalse()) {
            return falseTerm;
        }
        return term.make(andOp, left, right);
    }

    public static term disjoin(term left, term right) {
        if (left.isFalse()) {
            return right;
        }
        if (right.isFalse() || left.equals(right)) {
            return left;
        }
        if (left.isTrue() || right.isTrue()) {
            return trueTerm;
        }
        return term.make(orOp, left, right);
    }

    public static term imply(term antecedant, term consequent) {
        if (antecedant.isFalse()) {
            return trueTerm;
        }
        if (consequent.isTrue()) {
            return consequent;
        }
        return term.make(impliesOp, antecedant, consequent);
    }
}

