/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.util.Iprintable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Vector;

public class Scope
implements Prettyprintable,
Iprintable,
SPrintable {
    private int scopeId;
    private static int nextScopeId = 0;
    private String description;
    private static Scope root = null;
    private Scope parent;
    private Vector<Scope> children;
    private int kind;
    public static int varsOnly = 1;
    public static int boundVarsOnly = 2;
    public static int automaticOps = 4;
    public static int automaticVars = 8;

    public String description() {
        return this.description;
    }

    private Scope(int kind2, String d) {
        this.kind = kind2;
        this.description = d;
        this.scopeId = nextScopeId++;
        this.children = new Vector();
        this.parent = null;
    }

    public static Scope root() {
        if (root == null) {
            root = new Scope(0, "root");
        }
        return root;
    }

    public Scope makeSubscope(String d) {
        return this.makeSubscope(0, d);
    }

    public Scope makeSubscope(int kind2, String d) {
        if ((~(varsOnly | automaticOps | automaticVars | boundVarsOnly) & kind2) != 0) {
            throw new InternalError("Scope.makeSubscope");
        }
        Scope child = new Scope(this.kind | kind2, d);
        this.children.addElement(child);
        child.parent = this;
        return child;
    }

    public Scope parent() {
        return this.parent;
    }

    public int nChildren() {
        return this.children.size();
    }

    public Scope child(int n) {
        return n < 0 || this.children.size() <= n ? null : this.children.elementAt(n);
    }

    public Scope topAncestor() {
        if (this.parent == null) {
            return null;
        }
        Scope result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public boolean varsOnly() {
        return (this.kind & (varsOnly | boundVarsOnly)) != 0;
    }

    public boolean boundVarsOnly() {
        return (this.kind & boundVarsOnly) != 0;
    }

    public boolean automaticVars() {
        return (this.kind & automaticVars) != 0;
    }

    public Scope opDeclarationAncestor() {
        Scope s = this;
        while (s.varsOnly() && s.parent != null) {
            s = s.parent;
        }
        return s;
    }

    public Scope varDeclarationAncestor() {
        Scope s = this;
        while (s.boundVarsOnly() && s.parent != null) {
            s = s.parent;
        }
        return s;
    }

    public boolean equals(Scope sc) {
        return this.scopeId == sc.scopeId;
    }

    public boolean contains(Scope sc) {
        while (sc != null) {
            if (this.equals(sc)) {
                return true;
            }
            sc = sc.parent;
        }
        return false;
    }

    public int hashCode() {
        return this.scopeId;
    }

    public prettyprinter print(prettyprinter pp) {
        return pp.put(this.toString());
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        return SExp.makeSList(SExp.makeSValue("scope"), SExp.makeSValue(this.toString()));
    }

    public iprinter printSubscope(iprinter ip) {
        return this.parent == null ? ip : ip.fill().put("subscope").put(this.toString()).put(this.parent.toString()).end();
    }

    public String toString() {
        return String.valueOf(this.scopeId);
    }

    public int compareTo(Scope sc) {
        return this.scopeId < sc.scopeId ? -1 : (this.scopeId == sc.scopeId ? 0 : 1);
    }
}

