/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.notions;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.cNode;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
extends Unit {
    private HashSet<cNode> forest;
    private Hashtable<term, cNode> t2cNode;
    private Hashtable<operator, HashSet<cNode>> op2cNodeSet;
    private Hashtable<sort, HashSet<cNode>> sort2QfrcNodeSet;
    private Hashtable<sort, HashSet<cNode>> sort2cNodeSet;
    private boolean unsound = false;

    public boolean unsound() {
        return this.unsound;
    }

    public Context() {
        this(1);
    }

    public Context(int n) {
        this.forest = new HashSet(n);
        this.t2cNode = new Hashtable(n);
        this.op2cNodeSet = new Hashtable(n);
        this.sort2QfrcNodeSet = new Hashtable(n);
        this.sort2cNodeSet = new Hashtable(n);
    }

    private cNode find(term t) {
        cNode c = this.t2cNode.get(t);
        if (c != null) {
            return c.root();
        }
        switch (t.kind()) {
            case 0: {
                operator op = t.op();
                cNode[] cArgs = new cNode[t.nArgs()];
                int i = 0;
                while (i < t.nArgs()) {
                    cArgs[i] = this.find(t.arg(i));
                    ++i;
                }
                HashSet<cNode> opSet = this.op2cNodeSet.get(op);
                if (opSet == null) {
                    opSet = new HashSet();
                    this.op2cNodeSet.put(op, opSet);
                }
                Iterator<cNode> i2 = opSet.iterator();
                while (c == null && i2.hasNext()) {
                    cNode candidate = i2.next();
                    boolean equiv = true;
                    int j = 0;
                    while (equiv && j < t.nArgs()) {
                        if (cArgs[j] != this.find(candidate.originalTerm().arg(j))) {
                            equiv = false;
                        }
                        ++j;
                    }
                    if (!equiv) continue;
                    c = candidate;
                }
                if (c == null) {
                    c = new cNode(t);
                }
                this.t2cNode.put(t, c);
                opSet.add(c);
                int i22 = 0;
                while (i22 < cArgs.length) {
                    cArgs[i22].precede(c);
                    ++i22;
                }
                break;
            }
            case 1: {
                quantifier q = t.qfr();
                sort s = q.var().sort();
                cNode cArg = this.find(t.subterm());
                HashSet<cNode> qfrSet = this.sort2QfrcNodeSet.get(s);
                if (qfrSet == null) {
                    qfrSet = new HashSet();
                    this.sort2QfrcNodeSet.put(s, qfrSet);
                }
                Iterator<cNode> i = qfrSet.iterator();
                while (c == null && i.hasNext()) {
                    cNode candidate = i.next();
                    term t2 = candidate.originalTerm();
                    quantifier q2 = t2.qfr();
                    if (q.equals(q2)) {
                        if (cArg != this.find(candidate.originalTerm().subterm())) continue;
                        c = candidate;
                        continue;
                    }
                    if (q2.kind() != q.kind()) continue;
                    Context x1 = this.copy();
                    x1.equate(new term(q.var()), new term(q2.var()));
                    if (!x1.isEquiv(t.subterm(), t2.subterm())) continue;
                    c = candidate;
                }
                if (c == null) {
                    c = new cNode(t);
                }
                this.t2cNode.put(t, c);
                qfrSet.add(c);
                cArg.precede(c);
                break;
            }
            case 2: {
                c = new cNode(t);
                this.t2cNode.put(t, c);
                break;
            }
            default: {
                throw new InternalError("Context.find");
            }
        }
        HashSet<cNode> s = this.sort2cNodeSet.get(t.sort());
        if (s == null) {
            s = new HashSet();
            this.sort2cNodeSet.put(t.sort(), s);
        }
        s.add(c);
        this.forest.add(c.root());
        return c;
    }

    public void assertTrue(term t) {
        this.equate(t, booleans.trueTerm);
    }

    public void assertFalse(term t) {
        this.equate(t, booleans.falseTerm);
    }

    public void equate(term t1, term t2) {
        if (!t1.sort().equals(t2.sort())) {
            throw new InternalError("Cannot equate terms of unlike sort");
        }
        cNode c1 = this.find(t1);
        cNode c2 = this.find(t2);
        this.forest.remove(c1.root());
        this.forest.remove(c2.root());
        this.unsound |= c1.equate(c2);
        this.forest.add(c1.root());
        if (this.unsound) {
            return;
        }
        this.checkNegation(t1);
        this.checkNegation(t2);
        if (simplify.isNegation(t1) && simplify.isNegation(t2)) {
            this.equate(t1.arg(0), t2.arg(0));
        }
        this.splitAndsOrs(t1);
        this.splitAndsOrs(t2);
        this.close(c1, c2);
    }

    private void close(cNode c1, cNode c2) {
        Vector<cNode> eq1 = new Vector<cNode>();
        Vector<cNode> eq2 = new Vector<cNode>();
        block4: for (cNode pred1 : c1.predecessors()) {
            term t1 = pred1.originalTerm();
            Iterator<cNode> i2 = c2.predecessors().iterator();
            switch (t1.kind()) {
                case 0: {
                    term t2;
                    cNode pred2;
                    while (i2.hasNext()) {
                        pred2 = i2.next();
                        if (pred1 == pred2 || (t2 = pred2.originalTerm()).kind() != 0 || !t2.op().equals(t1.op())) continue;
                        boolean equal = true;
                        int i = 0;
                        while (equal && i < t1.nArgs()) {
                            if (!this.isEquiv(t1, t2)) {
                                equal = false;
                            }
                            ++i;
                        }
                        if (!equal) continue;
                        eq1.addElement(pred1);
                        eq2.addElement(pred2);
                        break;
                    }
                }
                case 1: {
                    term t2;
                    cNode pred2;
                    while (i2.hasNext()) {
                        pred2 = i2.next();
                        if (pred1 == pred2 || (t2 = pred2.originalTerm()).kind() != 1 || t2.qfr().kind() != t1.qfr().kind() || !t1.qfr().var().sort().equals(t2.qfr().var().sort())) continue;
                        Context x1 = this.copy();
                        x1.equate(new term(t1.qfr().var()), new term(t2.qfr().var()));
                        if (!x1.isEquiv(t1.subterm(), t2.subterm())) continue;
                        eq1.addElement(pred1);
                        eq2.addElement(pred2);
                    }
                    continue block4;
                }
                default: {
                    throw new InternalError("Context.close");
                }
            }
        }
        int i = 0;
        while (i < eq1.size()) {
            ((cNode)eq1.elementAt(i)).equate((cNode)eq2.elementAt(i));
            ++i;
        }
    }

    private void checkNegation(term t) {
        if (!simplify.isNegation(t)) {
            return;
        }
        if (this.isTrue(t)) {
            this.assertFalse(t.arg(0));
        } else if (this.isFalse(t)) {
            this.assertTrue(t.arg(0));
        }
    }

    private void splitAndsOrs(term t) {
        if (t.kind() != 0) {
            return;
        }
        operator op = t.op();
        if (this.isTrue(t) && op.equals(booleans.andOp)) {
            this.assertTrue(t.arg(0));
            this.assertTrue(t.arg(1));
        } else if (this.isFalse(t) && op.equals(booleans.orOp)) {
            this.assertFalse(t.arg(0));
            this.assertFalse(t.arg(1));
        }
    }

    public boolean isTrue(term t) {
        return this.isEquiv(booleans.trueTerm, t);
    }

    public boolean isFalse(term t) {
        return this.isEquiv(booleans.falseTerm, t);
    }

    public boolean isEquiv(term t1, term t2) {
        if (this.unsound && t1.sort().equals(t2.sort())) {
            return true;
        }
        return this.find(t1).root() == this.find(t2).root();
    }

    public Context copy() {
        cNode cc;
        cNode cc2;
        Context result = new Context();
        Enumeration<Object> e = this.t2cNode.keys();
        while (e.hasMoreElements()) {
            HashSet<cNode> s;
            term t = e.nextElement();
            cc2 = result.t2cNode.get(t);
            if (cc2 == null) {
                cc2 = new cNode(t);
                result.t2cNode.put(t, cc2);
            }
            if ((s = result.sort2cNodeSet.get(t.sort())) == null) {
                s = new HashSet();
                result.sort2cNodeSet.put(t.sort(), s);
            }
            s.add(cc2);
        }
        e = this.t2cNode.elements();
        while (e.hasMoreElements()) {
            cNode c = (cNode)e.nextElement();
            cc2 = this.original2Copy(c, result);
            cc2.parent = this.original2Copy(c.parent, result);
        }
        e = this.op2cNodeSet.keys();
        while (e.hasMoreElements()) {
            operator op = (operator)e.nextElement();
            HashSet<cNode> opSet = this.op2cNodeSet.get(op);
            HashSet<cNode> opSet2 = new HashSet<cNode>();
            result.op2cNodeSet.put(op, opSet2);
            for (cNode c : opSet) {
                cc = this.original2Copy(c, result);
                opSet2.add(cc);
            }
        }
        e = this.sort2QfrcNodeSet.keys();
        while (e.hasMoreElements()) {
            sort s = (sort)e.nextElement();
            HashSet<cNode> qfrSet = this.sort2QfrcNodeSet.get(s);
            HashSet<cNode> qfrSet2 = new HashSet<cNode>();
            result.sort2QfrcNodeSet.put(s, qfrSet2);
            for (cNode c : qfrSet) {
                cc = this.original2Copy(c, result);
                qfrSet2.add(cc);
            }
        }
        for (cNode root : this.forest) {
            cNode cRoot = this.original2Copy(root, result);
            result.forest.add(cRoot);
            HashSet<cNode> predecessors = root.predecessors();
            Iterator<cNode> i2 = predecessors.iterator();
            while (i2.hasNext()) {
                cRoot.precede(i2.next());
            }
        }
        return result;
    }

    private cNode original2Copy(cNode c, Context x) {
        return x.t2cNode.get(c.originalTerm());
    }

    public boolean equals(Object obj) {
        return obj instanceof Context ? this.equals((cNode)obj) : false;
    }

    public boolean equals(Context x) {
        return this.unsound == x.unsound && this.forest.equals(x.forest) && this.t2cNode.equals(x.t2cNode) && this.op2cNodeSet.equals(x.op2cNodeSet) && this.sort2QfrcNodeSet.equals(x.sort2QfrcNodeSet) && this.sort2cNodeSet.equals(x.sort2cNodeSet);
    }

    public HashSet<term> equivClass(term t) {
        HashSet<term> terms = new HashSet<term>();
        if (this.unsound) {
            HashSet<cNode> eClass = this.sort2cNodeSet.get(t.sort());
            Enumeration<term> e = this.t2cNode.keys();
            while (e.hasMoreElements()) {
                if (!eClass.contains(this.find(e.nextElement()).root())) continue;
                terms.add(t);
            }
        } else {
            cNode c = this.find(t).root();
            Enumeration<term> e = this.t2cNode.keys();
            while (e.hasMoreElements()) {
                if (c != this.find(e.nextElement()).root()) continue;
                terms.add(t);
            }
        }
        return terms;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.align(0);
        pp.put("unsound = ");
        pp.print(this.unsound ? booleans.trueTerm : booleans.falseTerm).eol();
        for (cNode root : this.forest) {
            pp.fill().put("[").print(root.originalTerm()).put("] =").blank();
            pp.put("{");
            HashSet<term> eClass = this.equivClass(root.originalTerm());
            Iterator<term> t = eClass.iterator();
            while (t.hasNext()) {
                pp.print(t.next());
                if (!t.hasNext()) continue;
                pp.put(",").blank();
            }
            pp.put("}").end().eol();
        }
        return pp.end();
    }

    @Override
    public iprinter print(iprinter ip) {
        ip.align();
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("Context"));
        SValue soundVal = this.unsound ? booleans.trueTerm.toSValue() : booleans.falseTerm.toSValue();
        list.add(SExp.makeSList(SExp.makeSValue("unsound"), soundVal));
        for (cNode root : this.forest) {
            SList classList = new SList();
            HashSet<term> eClass = this.equivClass(root.originalTerm());
            Iterator<term> t = eClass.iterator();
            while (t.hasNext()) {
                classList.add(t.next().toSValue());
            }
            SList exList = SExp.makeSList(root.originalTerm().toSValue(), classList);
            list.add(exList);
        }
        return list;
    }
}

