/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.checker.AmbiguousException;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.checkVocab;
import com.veromodo.tioa.checker.constructorTable;
import com.veromodo.tioa.checker.numeralsAndOps;
import com.veromodo.tioa.checker.opTable;
import com.veromodo.tioa.checker.predefined;
import com.veromodo.tioa.checker.sortTable;
import com.veromodo.tioa.checker.varTable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortConstructor;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.builtIns;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.signatureNode;
import com.veromodo.tioa.parser.sortConstructorNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.parser.vocabNode;
import com.veromodo.tioa.util.Iprintable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class symTable
implements Prettyprintable,
Iprintable,
Cloneable {
    private static symTable theTable = null;
    private opTable ops = new opTable();
    public sortTable sorts = new sortTable();
    public constructorTable constructors = new constructorTable();
    private varTable vars = new varTable();

    private symTable() {
        this.declare(predefined.boolSort);
        int i = 0;
        while (i < predefined.boolOps.length) {
            this.declare(predefined.boolOps[i]);
            ++i;
        }
    }

    public static symTable get() {
        if (theTable == null) {
            theTable = new symTable();
        }
        return theTable;
    }

    public boolean declare(sortNode sn) {
        int n;
        sortNode declared = this.find(sn);
        if (declared != null) {
            if (sn.makeAbstract() != null && sn.makeAbstract().hasNumerals()) {
                declared.makeAbstract().makeNumeral();
            }
            return false;
        }
        this.sorts.declare(sn);
        if (!sn.restricted() && !sn.equals(sort.realSortD)) {
            this.declare(predefined.eqOp(sn));
            this.declare(predefined.neqOp(sn));
            this.declare(predefined.ifOp(sn));
        }
        ltoken tok = (n = sn.nSubsorts()) == 0 ? sn.id() : sn.constructor().id();
        nameNode nn = new nameNode(new opSym(0, tok.toString()), tok.scope());
        this.declare(new operatorNode(nn, predefined.typeSig0));
        if (n > 0) {
            nameNode b = new nameNode(opSym.bracketOp(true, n, false), sn.scope());
            this.declare(new operatorNode(b, new signatureNode(predefined.typeSort, n + 1)));
        }
        return true;
    }

    public boolean declare(sortConstructorNode con) {
        sortConstructorNode declared = this.constructors.find(con);
        if (declared != null) {
            return false;
        }
        this.constructors.declare(con);
        return true;
    }

    public boolean declare(variableNode v) {
        if (this.vars.find(v) != null) {
            return false;
        }
        this.vars.declare(v, v.scope().varDeclarationAncestor());
        return true;
    }

    public void declareBoundVar(variableNode v) {
        this.vars.declareBoundVar(v);
    }

    public void declareVarWithOp(variableNode v, operator op) {
        this.vars.declareVarWithOp(v, op);
    }

    public boolean declare(operatorNode op) {
        if (this.ops.isAutomaticNumeral(op)) {
            return false;
        }
        try {
            if (this.ops.find(op) != null) {
                return false;
            }
        }
        catch (AmbiguousException msg) {
            throw new InternalError("symTable.declare(operatorNode) " + msg);
        }
        this.ops.declare(op);
        return true;
    }

    public void declare(signatureNode sig) {
        int i = 0;
        while (i < sig.arity()) {
            this.declare(sig.domain(i));
            ++i;
        }
        this.declare(sig.range());
    }

    public operatorNode find(operatorNode op) throws AmbiguousException {
        if (op.sig() != null) {
            int i = 0;
            while (i < op.sig().arity()) {
                this.find(op.sig().domain(i));
                ++i;
            }
            this.find(op.sig().range());
        }
        return this.ops.find(op);
    }

    public sortNode find(sortNode sn) {
        sortNode result = this.sorts.find(sn);
        if (result != null) {
            return result;
        }
        String vName = (sn.nSubsorts() == 0 ? sn.id() : sn.constructor().id()).toString();
        vocabNode vn = builtIns.getVocab(vName, sn.nSubsorts());
        if (vn == null) {
            return null;
        }
        switch (vn.status()) {
            case UNCHECKED: {
                checkVocab.check(vn);
            }
            case OK: {
                break;
            }
            default: {
                return null;
            }
        }
        renaming r = renaming.theIdentity();
        if (vn.defines() != null) {
            r = new renaming(sn.nSubsorts());
            int i = 0;
            while (i < sn.nSubsorts()) {
                sortNode ss = checkSort.now(sn.subsort(i));
                if (ss == null) {
                    return null;
                }
                r.add(vn.defines().subsort(i).makeAbstract(), ss.makeAbstract());
                ++i;
            }
            r.freeze();
        }
        this.extend(sn.scope(), vn.scope(), r);
        return this.sorts.find(sn);
    }

    public sortConstructorNode find(sortConstructorNode sn) {
        sortConstructorNode result = this.constructors.find(sn);
        if (result != null) {
            return result;
        }
        vocabNode vn = builtIns.getVocab(sn.id().toString(), sn.arity());
        if (vn == null) {
            return null;
        }
        switch (vn.status()) {
            case UNCHECKED: {
                checkVocab.check(vn);
            }
            case OK: {
                break;
            }
            default: {
                return null;
            }
        }
        this.declare(sn);
        return this.constructors.find(sn);
    }

    public variableNode find(variableNode v) {
        return this.vars.find(v);
    }

    public variableNode findVar4Op(operator o) {
        return this.vars.find(o);
    }

    public Enumeration<operatorNode> matchingOps(nameNode id) {
        return new numeralsAndOps(id, this.ops, this.sorts);
    }

    public Enumeration<variableNode> matchingVars(String id, Scope sc) {
        return this.vars.matches(id, sc);
    }

    public Enumeration<operatorNode> allOps(Scope include, Scope exclude) {
        return this.ops.all(include, exclude);
    }

    public Enumeration<sortNode> allSorts(Scope include, Scope exclude) {
        return this.sorts.all(include, exclude);
    }

    public Enumeration<sortConstructorNode> allConstructors(Scope include, Scope exclude) {
        return this.constructors.all(include, exclude);
    }

    public void extend(Scope sc1, Scope sc2, renaming r) {
        Scope exclude = r.isIdentity() ? sc1 : null;
        HashSet<sortNode> simpSorts = new HashSet<sortNode>();
        HashSet compSorts = new HashSet();
        Iterator e = this.allSorts(sc2, null);
        while (e.hasMoreElements()) {
            sortNode sn = e.nextElement();
            sort s0 = sn.makeAbstract();
            if (exclude != null && exclude.contains(sn.scope()) && !s0.hasNumerals()) continue;
            sortNode sn1 = new sortNode(r.map(s0), sc1);
            HashSet<sortNode> sortSet = sn1.nSubsorts() == 0 ? simpSorts : compSorts;
            sortNode dec = this.sorts.find(sn1);
            if (dec == null) {
                sortSet.add(sn1);
            } else if (s0.hasNumerals()) {
                dec.makeAbstract().makeNumeral();
            }
            if (!sn.restricted()) continue;
            sn1.restrict();
            if (sn1.nSubsorts() == 0) continue;
            throw new InternalError("Restricted compound sort?");
        }
        e = this.allConstructors(sc2, null);
        while (e.hasMoreElements()) {
            sortConstructorNode scn = (sortConstructorNode)e.nextElement();
            this.declare(new sortConstructorNode(r.map(scn.makeAbstract()), sc1));
        }
        e = simpSorts.iterator();
        while (e.hasNext()) {
            this.sorts.declare((sortNode)e.next());
        }
        e = compSorts.iterator();
        while (e.hasNext()) {
            this.sorts.declare((sortNode)e.next());
        }
        HashSet<operatorNode> newOps = new HashSet<operatorNode>();
        Object e2 = this.allOps(sc2, exclude);
        while (e2.hasMoreElements()) {
            operatorNode op = new operatorNode(r.map(((operatorNode)e2.nextElement()).makeAbstract()), sc1);
            try {
                if (this.ops.find(op) != null) continue;
                newOps.add(op);
            }
            catch (AmbiguousException msg) {
                throw new InternalError("symTable.extend: " + msg);
            }
        }
        e2 = newOps.iterator();
        while (e2.hasNext()) {
            this.declare((operatorNode)e2.next());
        }
    }

    public void redeclareVars(Scope newScope, Scope oldScope) {
        HashSet<variableNode> newVars = new HashSet<variableNode>();
        Enumeration<variableNode> e = this.vars.all(oldScope, newScope);
        while (e.hasMoreElements()) {
            variableNode vn = e.nextElement();
            variableNode vn1 = new variableNode(vn.makeAbstract(), newScope);
            vn1.setKind(vn.kind());
            newVars.add(vn1);
        }
        for (variableNode vn : newVars) {
            this.vars.declare(vn, newScope);
        }
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        return this.print(pp, Scope.root());
    }

    public prettyprinter print(prettyprinter pp, Scope sc) {
        pp.align(0).fill(0).put("# Scope ").print(sc);
        if (sc.parent() != null) {
            pp.put(" child of ").print(sc.parent());
        }
        pp.put(": ").put(sc.description()).eol();
        boolean prev = false;
        if (sc.varsOnly()) {
            pp.put("varsOnly").blank();
            prev = true;
        }
        if (sc.boundVarsOnly()) {
            if (prev) {
                pp.put(",").blank();
            }
            pp.put("boundVarsOnly");
            prev = true;
        }
        if (sc.automaticVars()) {
            if (prev) {
                pp.put(",").blank();
            }
            pp.put("automaticVars");
            prev = true;
        }
        if (prev) {
            pp.eol();
        }
        this.sorts.printDecs(pp, sc);
        this.ops.printDecs(pp, sc);
        this.vars.printDecs(pp, sc);
        pp.end();
        int i = 0;
        while (i < sc.nChildren()) {
            pp.eol();
            this.print(pp, sc.child(i));
            ++i;
        }
        return pp.end();
    }

    public prettyprinter printSorts(prettyprinter pp, Scope sc) {
        return this.sorts.print(pp, sc);
    }

    public prettyprinter printOps(prettyprinter pp, Scope sc) {
        return this.ops.print(pp, sc);
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.print(ip, Scope.root());
    }

    public iprinter print(iprinter ip, Scope sc) {
        sort.printAll(ip, sc);
        sortConstructor.printAll(ip, sc);
        operator.printAll(ip, sc);
        variable.printAll(ip, sc);
        return ip;
    }
}

