/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.checker.ILDeclarations;
import com.veromodo.tioa.checker.allDeclarations;
import com.veromodo.tioa.checker.idDeclarations;
import com.veromodo.tioa.checker.stKey;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sortAlgorithms;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class sortTable
implements Cloneable {
    private Hashtable<stKey, Vector<sortNode>> tab = new Hashtable();

    protected sortTable() {
    }

    protected void declare(sortNode sn) {
        assert (sn != null && sn.scope() != null);
        if (sn.declaration() != null) {
            if (sn.declaration() == sn) {
                return;
            }
            throw new InternalError("sortTable.declare");
        }
        sn.setDeclaration(null);
        Scope sc = sn.scope().opDeclarationAncestor();
        stKey k = new stKey(sn, sc);
        Vector<sortNode> bindings = this.tab.get(k);
        if (bindings == null) {
            bindings = new Vector();
            this.tab.put(k, bindings);
        }
        bindings.addElement(sn);
    }

    protected sortNode find(sortNode sn) {
        assert (sn != null && sn.scope() != null);
        if (sn.nSubsorts() > 0) {
            int i = 0;
            while (i < sn.nSubsorts()) {
                if (this.find(sn.subsort(i)) == null) {
                    return null;
                }
                ++i;
            }
            if (symTable.get().find(sn.constructor()) == null) {
                return null;
            }
        }
        Scope sc = sn.scope().opDeclarationAncestor();
        idDeclarations e = new idDeclarations(this.tab, sn, sc);
        while (e.hasMoreElements()) {
            sortNode dec = (sortNode)e.nextElement();
            if (!sn.equals(dec)) continue;
            if (sn.declaration() == null) {
                sn.setDeclaration(dec);
            } else assert (sn.declaration() == dec);
            return dec;
        }
        return null;
    }

    protected Enumeration<sortNode> all(Scope include, Scope exclude) {
        if (exclude != null) {
            exclude = exclude.opDeclarationAncestor();
        }
        return new allDeclarations(this.tab, include, exclude);
    }

    public prettyprinter print(prettyprinter pp, Scope sc) {
        pp.align(0);
        Enumeration<sortNode> e = this.all(sc, null);
        while (e.hasMoreElements()) {
            pp.print(e.nextElement());
            if (!e.hasMoreElements()) continue;
            pp.put(",").eol();
        }
        return pp.eol().put("").eol().end();
    }

    public void printDecs(prettyprinter pp, Scope sc) {
        Vector<sortNode> v = new Vector<sortNode>();
        Enumeration<sortNode> e = this.all(sc, sc.parent());
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        sortAlgorithms.quicksort(v);
        pp.align(0);
        e = v.elements();
        while (e.hasMoreElements()) {
            sortNode dec = e.nextElement();
            sort s = dec.makeAbstract();
            pp.fill().put("s" + s.uid()).blank(2).print(dec);
            if (s.hasNumerals()) {
                pp.blank().put("numerals");
            }
            pp.end().eol();
        }
        pp.end();
    }

    public iprinter print(iprinter ip, Scope sc) {
        ILDeclarations e = new ILDeclarations(this.tab, sc);
        ip.align().put("sorts");
        while (e.hasMoreElements()) {
            sortNode sNode = (sortNode)e.nextElement();
            sort s = sNode.makeAbstract();
            ip.fill().print(s);
            ip.quote(s.nSubsorts() == 0 ? s.id() : s.constructor().id());
            ip.list("", s.cloneSubsorts());
            if (s.hasNumerals()) {
                ip.put("lit");
            }
            ip.print(sNode.scope()).end();
        }
        return ip.end();
    }
}

