/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.checker.Check;
import com.veromodo.tioa.checker.checkShorthand;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.actualNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.shorthandNode;
import com.veromodo.tioa.parser.sortDclNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.specs;
import com.veromodo.tioa.parser.vocabNode;
import com.veromodo.tioa.parser.vocabRefNode;
import com.veromodo.tioa.util.StringOps;
import com.veromodo.tioa.util.error;

public class checkVocab
extends Check {
    private vocabNode theVocab;
    private static symTable syms = symTable.get();

    private checkVocab(vocabNode vn) {
        this.theVocab = vn;
    }

    public static void check(vocabNode v) {
        if (v.status() != Node.status.UNCHECKED) {
            return;
        }
        v.setStatus(Node.status.CHECKING_SYMBOLS);
        checkVocab vc = new checkVocab(v);
        vc.checkDefines();
        vc.checkSymbols();
        vc.checkFormals();
        v.setFinalStatus(!vc.errors());
    }

    public void checkDefines() {
        sortNode sn = this.theVocab.defines();
        if (sn == null) {
            return;
        }
        boolean ok = true;
        int i = 0;
        while (i < sn.nSubsorts()) {
            sortNode sub = sn.subsort(i);
            String msg = null;
            int j = 0;
            while (j < i && msg == null) {
                if (sn.subsort(j).status() == Node.status.OK && sub.equals(sn.subsort(j))) {
                    msg = "type used twice in template for type constructor";
                }
                ++j;
            }
            if (msg != null || !syms.declare(sub)) {
                msg = "type in template for type constructor is already defined";
            }
            if (msg != null) {
                error.msg(sub, msg);
            }
            sub.setStatus(msg == null ? Node.status.OK : Node.status.BAD);
            ok &= msg == null;
            ++i;
        }
        if (!syms.declare(sn.constructor())) {
            error.msg(sn.constructor(), "type constructor already defined");
            ok = false;
        }
        sn.constructor().setFinalStatus(ok);
        sn.setFinalStatus(ok);
        if (ok) {
            syms.declare(sn);
        }
        if (this.theVocab.nFormals() > 0) {
            error.msg(this.theVocab, "vocabulary defining a type constructor cannot have parameters");
        }
    }

    public void checkSymbols() {
        int i = 0;
        while (i < this.theVocab.nImports()) {
            checkVocab.checkVocabRef(this.theVocab.imports(i));
            ++i;
        }
        if (this.errors()) {
            return;
        }
        i = 0;
        while (i < this.theVocab.nSorts()) {
            this.checkSortDcl(i);
            ++i;
        }
        i = 0;
        while (i < this.theVocab.nOperators()) {
            this.checkOpDcl(i);
            ++i;
        }
    }

    public static boolean checkVocabRef(vocabRefNode ref) {
        if (ref.status() != Node.status.UNCHECKED) {
            return ref.status() == Node.status.OK;
        }
        String name = ref.id().toString();
        vocabNode spec = specs.getVocabulary(name);
        if (spec == null) {
            error.msg(ref, "couldn't find imported vocabulary " + name);
            ref.setBadStatus();
            return false;
        }
        switch (spec.status()) {
            case OK: {
                break;
            }
            case MISSING: {
                error.msg(ref, "couldn't find imported vocabulary " + name);
                ref.setBadStatus();
                return false;
            }
            case UNPARSABLE: {
                error.msg(ref, "couldn't parse imported vocabulary " + name);
                ref.setBadStatus();
                return false;
            }
            case UNCHECKED: {
                checkVocab.check(spec);
                if (spec.status() == Node.status.OK || spec.status() == Node.status.OK || spec.status() == Node.status.OK) break;
            }
            case BAD: 
            case BAD_IMPORTS: {
                error.msg(ref, "imported vocabulary " + name + " contains errors");
                ref.setBadStatus();
                return false;
            }
            case CHECKING_SYMBOLS: {
                error.msg(ref, "circular reference to imported vocabulary " + name);
                spec.setStatus(Node.status.BAD_IMPORTS);
                ref.setBadStatus();
                return false;
            }
            default: {
                throw new InternalError("checkVocab.checkVocabRef");
            }
        }
        ref.theVocab(spec);
        int errors = error.count();
        if (ref.nActuals() == 0) {
            ref.renaming(renaming.theIdentity());
        } else {
            ref.renaming(new renaming(ref.nActuals()));
            if (ref.theVocab().nFormals() < ref.nActuals()) {
                if (ref.theVocab().nFormals() == 0) {
                    error.msg(ref.id(), "vocabulary " + name + " has no formal parameters");
                } else {
                    error.msg(ref.id(), "too many parameters for vocabulary " + name);
                }
                ref.setBadStatus();
            }
            int i = 0;
            while (i < ref.nActuals() && i < ref.theVocab().nFormals()) {
                checkVocab.checkActual(ref.theVocab().formal(i), ref.actual(i), ref.renaming());
                ++i;
            }
        }
        ref.renaming().freeze();
        ref.setStatus(error.count() > errors ? Node.status.BAD : Node.status.OK);
        if (ref.status() == Node.status.BAD) {
            return false;
        }
        syms.extend(ref.scope(), ref.theVocab().scope(), ref.renaming());
        return true;
    }

    public void checkFormals() {
        int i = 0;
        while (i < this.theVocab.nFormals()) {
            formalNode fn;
            fn.setStatus(checkVocab.checkFormal(fn = this.theVocab.formal(i)) ? Node.status.OK : Node.status.BAD);
            int j = 0;
            while (j < i && fn.status() == Node.status.OK) {
                if (this.theVocab.formal(j).status() == Node.status.OK && fn.equals(this.theVocab.formal(j))) {
                    String what;
                    fn.setBadStatus();
                    switch (fn.kind()) {
                        case OP: {
                            what = "operator";
                            break;
                        }
                        case TYPE: {
                            what = "type";
                            break;
                        }
                        case TYPECON: {
                            what = "type constructor";
                            break;
                        }
                        case VAR: {
                            what = "variable";
                            break;
                        }
                        default: {
                            throw new InternalError("checkVocab.checkFormals");
                        }
                    }
                    error.msg(fn, String.valueOf(what) + " used twice as a formal parameter");
                }
                ++j;
            }
            ++i;
        }
    }

    public static boolean checkFormal(formalNode formal2) {
        String msg = null;
        switch (formal2.kind()) {
            case TYPE: {
                if (checkSort.now(formal2.type()) == null) {
                    msg = "undeclared type " + formal2.type() + " used as a formal parameter";
                    break;
                }
                formal2.type().setStatus(Node.status.OK);
                break;
            }
            case TYPECON: {
                if (syms.find(formal2.typeCon()) == null) {
                    msg = "undeclared type constructor " + formal2.type() + " used as a formal parameter";
                    break;
                }
                formal2.typeCon().setStatus(Node.status.OK);
                break;
            }
            case OP: {
                operatorNode operatorNode2 = formal2.op();
            }
            default: {
                throw new InternalError("checkVocab.checkFormal");
            }
        }
        if (msg == null) {
            return true;
        }
        error.msg(formal2, msg);
        return false;
    }

    public static void checkActual(formalNode f, actualNode a, renaming r) {
        String label = "";
        String id = "";
        boolean mismatch = false;
        boolean duplicate = false;
        a.setFormal(f);
        switch (f.kind()) {
            case TYPE: {
                label = "type";
                boolean bl = mismatch = a.kind() != formal.kind.TYPE;
                if (mismatch) break;
                a.type().setStatus(Node.status.OK);
                syms.declare(a.type());
                duplicate = !r.add(f.type().makeAbstract(), a.type().makeAbstract());
                break;
            }
            case TYPECON: {
                label = "type constructor";
                boolean bl = mismatch = a.kind() != formal.kind.TYPECON;
                if (mismatch) break;
                a.typeCon().setStatus(Node.status.OK);
                syms.declare(a.typeCon());
                duplicate = !r.add(f.typeCon().makeAbstract(), a.typeCon().id().toString());
                break;
            }
            default: {
                throw new InternalError("checkVocab.checkActual");
            }
        }
        if (mismatch) {
            error.msg(a, "actual parameter " + a + " must be " + StringOps.addArticle(label));
        } else if (duplicate) {
            error.msg(a, String.valueOf(label) + " " + f + " already renamed");
        }
        a.setStatus(mismatch || duplicate ? Node.status.BAD : Node.status.OK);
    }

    public void checkOpDcl(int i) {
        String msg;
        operatorNode op = this.theVocab.operator(i);
        nameNode nn = op.id();
        if (nn.arity() < 0) {
            nn.setArity(op.arity());
        }
        String string = nn.arity() != op.arity() ? "arity of operator " + nn + " does not match signature" : (nn.kind() == 10 ? "missing placeholders (__) for arguments" : (msg = nn.kind() == 9 && !nn.sym().argBefore() ? "missing placeholder (__) for argument" : ""));
        if (op.setFinalStatus(msg.equals(""))) {
            if (checkSort.sig(op.sig())) {
                syms.declare(op);
            }
        } else {
            error.msg(nn, msg);
        }
    }

    public void checkSortDcl(int i) {
        sortDclNode sn = this.theVocab.sort(i);
        checkSort.declare(sn.theSortNode());
        shorthandNode sh = sn.theShorthand();
        if (sh != null) {
            checkShorthand.now(sn.theSortNode(), sh);
        }
    }
}

