/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.checker.Options;
import com.veromodo.tioa.checker.checkAutomaton;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.predefined;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.builtIns;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.signatureNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.termNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.util.StringOps;
import com.veromodo.tioa.util.error;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class checkTerm {
    private termNode theTermNode;
    private symTable syms = symTable.get();
    private checkTerm[] argChecks;
    private checkTerm subcheckTerm;
    private Vector<operatorNode> pOps;
    private Vector<variableNode> pVars;
    private Vector<sortNode> pSorts;

    private checkTerm(termNode t) {
        int arity = t.nArgs();
        this.theTermNode = t;
        this.argChecks = new checkTerm[arity];
        this.pOps = new Vector();
        this.pSorts = new Vector();
        this.pVars = new Vector();
        switch (t.kind()) {
            case 0: {
                int i = 0;
                while (i < arity) {
                    this.argChecks[i] = new checkTerm(t.arg(i));
                    ++i;
                }
                break;
            }
            case 1: {
                this.subcheckTerm = new checkTerm(t.subterm());
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new InternalError("checkTerm constructor");
            }
        }
    }

    private boolean setStatus(boolean ok) {
        return this.theTermNode.setFinalStatus(ok);
    }

    public static boolean someSort(termNode t) {
        checkTerm tc = new checkTerm(t);
        if (!tc.annotate()) {
            return tc.theTermNode.setFinalStatus(false);
        }
        if (tc.pSorts.size() == 1) {
            return tc.theTermNode.setFinalStatus(tc.disambiguate(tc.pSorts.firstElement()));
        }
        error.msg(tc.theTermNode, "more than one possible type for term");
        error.msgStartDetails("Possible types:").blank().list(tc.pSorts.toArray(new sortNode[0]), ",");
        error.msgEndDetails();
        return tc.theTermNode.setFinalStatus(false);
    }

    public static boolean someSort(termNode t, sortNode[] sorts) {
        checkTerm tc = new checkTerm(t);
        if (!tc.annotate()) {
            return tc.theTermNode.setFinalStatus(false);
        }
        int i = 0;
        while (i < sorts.length) {
            if (sorts[i].subsortIn(tc.pSorts)) {
                return tc.theTermNode.setFinalStatus(tc.disambiguate(sorts[i]));
            }
            ++i;
        }
        error.msg(tc.theTermNode, "wrong types for term");
        error.msgStartDetails("Allowed types:").blank().list(sorts, ",");
        error.msgEndDetails();
        error.msgStartDetails("Possible types:").blank().list(tc.pSorts.toArray(new sortNode[0]), ",");
        error.msgEndDetails();
        return tc.theTermNode.setFinalStatus(false);
    }

    public static boolean boolSort(termNode t) {
        return checkTerm.thisSort(t, predefined.boolSort);
    }

    public static boolean thisSort(termNode t, sortNode sn) {
        if (sn == null) {
            return checkTerm.someSort(t);
        }
        checkTerm tc = new checkTerm(t);
        if (!tc.annotate()) {
            return tc.setStatus(false);
        }
        if (sn.subsortIn(tc.pSorts)) {
            return tc.setStatus(tc.disambiguate(sn));
        }
        error.msg(t, "type of term must be " + sn);
        error.msgStartDetails("Possible types for term:").blank().list(tc.pSorts.toArray(new sortNode[0]), ",");
        error.msgEndDetails();
        tc.theTermNode.setBadStatus();
        return tc.setStatus(false);
    }

    public static boolean assignable(termNode t1, termNode t2) {
        checkTerm tc1 = new checkTerm(t1);
        checkTerm tc2 = new checkTerm(t2);
        if (!(tc1.annotate() & tc2.annotate())) {
            return tc1.setStatus(tc2.setStatus(false));
        }
        checkTerm.deleteRestrictedSorts(tc1.pSorts);
        checkTerm.deleteRestrictedSorts(tc2.pSorts);
        boolean ok = true;
        if (tc1.pSorts.size() == 0) {
            error.msg(t1, "undeclared constant or variable " + t1.id());
            ok = false;
        }
        if (tc2.pSorts.size() == 0) {
            error.msg(t2, "undeclared constant or variable " + t2.id());
            ok = false;
        }
        if (!ok) {
            return tc1.setStatus(tc2.setStatus(false));
        }
        HashSet<sortNode> commonSorts = new HashSet<sortNode>();
        Enumeration<sortNode> e1 = tc1.pSorts.elements();
        while (e1.hasMoreElements()) {
            sortNode sn1 = e1.nextElement();
            Enumeration<sortNode> e2 = tc2.pSorts.elements();
            while (e2.hasMoreElements()) {
                if (!sortNode.isSubsort(e2.nextElement(), sn1)) continue;
                commonSorts.add(sn1);
            }
        }
        switch (commonSorts.size()) {
            case 0: {
                error.msg(t1, "no common type for :=");
                error.msgStartDetails("Possible types for lhs:").blank().list(tc1.pSorts.toArray(new sortNode[0]), ",");
                error.msgEndDetails();
                error.msgStartDetails("Possible types for rhs:").blank().list(tc2.pSorts.toArray(new sortNode[0]), ",");
                error.msgEndDetails();
                return tc1.setStatus(tc2.setStatus(false));
            }
            case 1: {
                sortNode sn = commonSorts.toArray(new sortNode[0])[0];
                return tc1.setStatus(tc2.setStatus(tc1.disambiguate(sn) & tc2.disambiguate(sn)));
            }
        }
        error.msg(t1, "more than one possible type for :=");
        error.msgStartDetails("Possible types:").blank().list(commonSorts.toArray(new sortNode[0]), ",");
        error.msgEndDetails();
        return tc1.setStatus(tc2.setStatus(false));
    }

    private static void deleteRestrictedSorts(Vector<sortNode> v) {
        int i = 0;
        while (i < v.size()) {
            sortNode sn = v.elementAt(i);
            if (sn.restricted()) {
                v.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    private boolean annotate() {
        boolean ok = this.theTermNode.qual() == null || checkSort.now(this.theTermNode.qual()) != null;
        switch (this.theTermNode.kind()) {
            case 0: {
                return ok & this.annotateOpTerm();
            }
            case 1: {
                return ok & this.annotateQfrTerm();
            }
            case 2: {
                if (this.annotateZeroaryTerm()) {
                    return true;
                }
                error.msg(this.theTermNode.id(), "undeclared constant or variable " + this.theTermNode.id());
                return false;
            }
        }
        throw new InternalError("checkTerm.annotate");
    }

    private boolean annotateOpTerm() {
        int i;
        int arity = this.argChecks.length;
        nameNode selectOp = null;
        if (this.theTermNode.id().isDot()) {
            checkTerm arg2 = this.argChecks[1];
            if (!(arg2.theTermNode.parens() || arg2.theTermNode.id().kind() != 1 && arg2.theTermNode.id().kind() != 0 || arg2.argChecks.length != 0)) {
                selectOp = nameNode.makeSelection(this.theTermNode.id(), arg2.theTermNode.id());
            }
        }
        boolean idMatches = false;
        boolean selectOpMatches = false;
        if (selectOp == null) {
            boolean ok = true;
            i = 0;
            while (i < arity) {
                ok &= this.argChecks[i].annotate();
                ++i;
            }
            if (!ok) {
                return false;
            }
            idMatches = this.findOps(this.theTermNode.id(), arity);
        } else {
            if (!this.argChecks[0].annotate()) {
                return false;
            }
            selectOpMatches = this.findOps(selectOp, 1);
            this.argChecks[1].annotateZeroaryTerm();
            if (this.argChecks[1].pSorts.size() == 0) {
                arity = 1;
            } else {
                idMatches = this.findOps(this.theTermNode.id(), 2);
            }
        }
        nameNode id = this.theTermNode.id();
        if (this.pOps.size() == 0) {
            if (id.isLogicalOp() || id.isEqualityOp()) {
                error.msg(id, "illegal signature for operator " + id);
            } else if (id.kind() == 2) {
                error.msg(id, "illegal signature for conditional operator");
            } else if (!idMatches && !selectOpMatches) {
                error.msg(id, "undeclared " + (selectOp == null ? String.valueOf(arity) + "-ary operator " + id : "operator " + selectOp));
            } else if (this.theTermNode.qual() != null) {
                error.msg(id, "no operator " + id + " with matching signature");
            } else {
                error.msg(id, "no operator " + id + " with matching domain types");
            }
            if (idMatches || selectOpMatches) {
                i = 0;
                while (i < arity) {
                    error.msgStartDetails("Possible types for argument " + (i + 1) + ":").blank().list(this.argChecks[i].pSorts.toArray(new sortNode[0]), ",");
                    error.msgEndDetails();
                    ++i;
                }
                if (this.theTermNode.qual() != null) {
                    error.msgStartDetails("Range type:").blank().print(this.theTermNode.qual());
                    error.msgEndDetails();
                }
            }
            return false;
        }
        Enumeration<operatorNode> e = this.pOps.elements();
        while (e.hasMoreElements()) {
            sortNode rng = e.nextElement().sig().range();
            if (this.pSorts.contains(rng)) continue;
            this.pSorts.addElement(rng);
        }
        return true;
    }

    private boolean findOps(nameNode id, int arity) {
        Vector<operatorNode> S = new Vector<operatorNode>();
        Enumeration<operatorNode> e = this.syms.matchingOps(id);
        while (e.hasMoreElements()) {
            operatorNode op = e.nextElement();
            if (op.arity() != arity) continue;
            boolean OK = true;
            int i = 0;
            while (OK && i < arity) {
                OK &= op.sig().domain(i).subsortIn(this.argChecks[i].pSorts);
                ++i;
            }
            if (OK && this.theTermNode.qual() != null) {
                OK &= sortNode.isSubsort(op.sig().range(), this.theTermNode.qual());
            }
            if (!OK) continue;
            S.addElement(op);
        }
        if (S.size() == 0) {
            return false;
        }
        for (operatorNode op : S) {
            if (!checkTerm.maximalIn(S, op)) continue;
            this.pOps.addElement(op);
        }
        return true;
    }

    private static boolean maximalIn(Vector<operatorNode> S, operatorNode op) {
        for (operatorNode op1 : S) {
            if (op.equals(op1) || !op1.canReplace(op)) continue;
            return false;
        }
        return true;
    }

    private boolean annotateQfrTerm() {
        variableNode v = this.theTermNode.qfr().var();
        if (v.sort() == null) {
            this.pVars = checkTerm.enum2vector(this.syms.matchingVars(v.id().toString(), v.scope()));
        } else {
            if (checkSort.now(v.sort()) == null) {
                return false;
            }
            if (!this.occursFreely(v)) {
                v.setKind(15);
            }
            this.syms.declareBoundVar(v);
            this.pVars.addElement(v);
        }
        if (!this.subcheckTerm.annotate()) {
            return false;
        }
        this.pSorts.addElement(predefined.boolSort);
        return true;
    }

    private boolean annotateZeroaryTerm() {
        sortNode sn;
        Scope sc = this.theTermNode.scope();
        String id = this.theTermNode.id().string();
        nameNode nn = this.theTermNode.id();
        this.findOps(nn, 0);
        if (builtIns.getVocab(nn.string(), 0) != null) {
            this.pOps.addElement(new operatorNode(nn, predefined.typeSig0));
        }
        Enumeration<Node> e = this.pOps.elements();
        while (e.hasMoreElements()) {
            operatorNode op = e.nextElement();
            sortNode sn2 = op.sig().range();
            if (this.pSorts.contains(sn2)) continue;
            this.pSorts.addElement(sn2);
        }
        if (this.theTermNode.qual() == null) {
            this.pVars = checkTerm.enum2vector(this.syms.matchingVars(id, sc));
            if (this.pVars.size() == 0 && sc.automaticVars()) {
                e = this.syms.allSorts(sc, null);
                while (e.hasMoreElements()) {
                    sn = (sortNode)e.nextElement();
                    if (sn.restricted() || sn.equals(sort.realSortD) || this.pSorts.contains(sn)) continue;
                    variableNode v = new variableNode(id, sn, sc);
                    variableNode vn = this.syms.find(v);
                    this.pVars.addElement(vn == null ? v : vn);
                }
            }
        } else {
            variableNode v = new variableNode(id, this.theTermNode.qual(), sc);
            variableNode vn = this.syms.find(v);
            if (vn != null) {
                this.pVars.addElement(vn);
            } else if (sc.automaticVars()) {
                this.pVars.addElement(v);
            }
        }
        e = this.pVars.elements();
        while (e.hasMoreElements()) {
            sn = ((variableNode)e.nextElement()).sort();
            if (this.pSorts.contains(sn)) continue;
            this.pSorts.addElement(sn);
        }
        return this.pSorts.size() > 0;
    }

    private static Vector<variableNode> enum2vector(Enumeration<variableNode> e) {
        Vector<variableNode> result = new Vector<variableNode>();
        while (e.hasMoreElements()) {
            result.addElement(e.nextElement());
        }
        return result;
    }

    private boolean disambiguate(sortNode sn) {
        switch (this.theTermNode.kind()) {
            case 0: {
                return this.disambiguateOpTerm(sn);
            }
            case 1: {
                return this.disambiguateQfrTerm(sn);
            }
            case 2: {
                return this.disambiguateZeroaryTerm(sn);
            }
        }
        throw new InternalError("checkTerm.disambiguate");
    }

    private boolean disambiguateOpTerm(sortNode sn) {
        operatorNode op = null;
        boolean ambiguous = false;
        Enumeration<operatorNode> e = this.pOps.elements();
        while (e.hasMoreElements()) {
            operatorNode op1 = e.nextElement();
            if (!sortNode.isSubsort(op1.sig().range(), sn)) continue;
            if (op == null) {
                op = op1;
                continue;
            }
            if (op.id().kind() == 9) {
                if (op1.id().kind() != 9) continue;
                ambiguous = true;
                break;
            }
            if (op1.id().kind() == 9) {
                ambiguous = false;
                op = op1;
                continue;
            }
            operatorNode op2 = this.resolveNumericOps(op, op1);
            if (op2 != null) {
                op = op2;
                continue;
            }
            ambiguous = true;
        }
        if (ambiguous) {
            error.msg(this.theTermNode.id(), "ambiguous operator " + op.id());
            error.msgStartDetails("Possible signatures:");
            boolean selectOp = op.id().kind() == 9;
            Enumeration<operatorNode> e2 = this.pOps.elements();
            while (e2.hasMoreElements()) {
                operatorNode op1 = e2.nextElement();
                if (!sn.equals(op1.sig().range()) || selectOp && op1.id().kind() != 9) continue;
                error.moreDetails().eol().print(op1.sig());
            }
            error.msgEndDetails();
            return false;
        }
        if (op == null) {
            error.msg(this.theTermNode.id(), "no operator " + this.theTermNode.id() + " declared with range " + sn);
            error.msgStartDetails("Possible signatures:");
            e = this.pOps.elements();
            while (e.hasMoreElements()) {
                error.moreDetails().eol().print(e.nextElement().sig());
            }
            error.msgEndDetails();
            return false;
        }
        int arity = op.sig().arity();
        boolean ok = true;
        int i = 0;
        while (i < arity) {
            ok &= this.argChecks[i].disambiguate(op.sig().domain(i));
            ++i;
        }
        if (!ok) {
            return false;
        }
        term[] args = new term[arity];
        int i2 = 0;
        while (i2 < arity) {
            args[i2] = this.argChecks[i2].theTermNode.makeAbstract();
            ++i2;
        }
        term theTerm = new term(args, op.makeAbstract());
        sort theSort = null;
        if (op.sig().range().equals(predefined.typeSort)) {
            termNode conTerm = this.argChecks[0].theTermNode;
            Scope sc = op.scope();
            if (conTerm.nArgs() > 0) {
                throw new InternalError("checkTerm.disambiguateOpTerm");
            }
            sortNode[] subsorts = new sortNode[arity - 1];
            int i3 = 1;
            while (i3 < arity) {
                subsorts[i3 - 1] = new sortNode(this.argChecks[i3].theTermNode.makeAbstractSort(), op.scope());
                ++i3;
            }
            sortNode s = new sortNode(new ltoken(conTerm.id().toString(), sc), subsorts);
            if ((s = checkSort.now(s)) == null) {
                return false;
            }
            theSort = s.makeAbstract();
        }
        this.pOps = new Vector();
        this.pOps.addElement(op);
        this.theTermNode.disambiguate(theTerm, theSort);
        return true;
    }

    private operatorNode resolveNumericOps(operatorNode op1, operatorNode op2) {
        nameNode id = op1.id();
        if (!id.equals(op2.id())) {
            return null;
        }
        signatureNode sig1 = op1.sig();
        signatureNode sig2 = op2.sig();
        int compare = sortNode.compare(sig1.range(), sig2.range());
        if (compare == -2) {
            return null;
        }
        int i = 0;
        while (i < sig1.arity()) {
            int x = sortNode.compare(sig1.domain(i), sig2.domain(i));
            if (x == -2) {
                return null;
            }
            if (compare != x) {
                if (compare == 0) {
                    compare = x;
                }
                return null;
            }
            ++i;
        }
        return compare <= 0 ? op1 : op2;
    }

    private boolean disambiguateQfrTerm(sortNode sn) {
        if (!this.subcheckTerm.disambiguate(sn)) {
            return false;
        }
        variableNode var = null;
        variableNode backup = null;
        Enumeration<variableNode> e = this.pVars.elements();
        while (e.hasMoreElements()) {
            variableNode vn = e.nextElement();
            if (this.subcheckTerm.occursFreely(vn)) {
                if (var != null) {
                    error.msg(this.theTermNode.id(), "ambiguous variable");
                    return false;
                }
                var = vn;
                continue;
            }
            backup = vn;
        }
        if (var == null) {
            var = backup;
        }
        if (var == null) {
            var = this.theTermNode.qfr().var();
            error.msg(var, "undeclared variable " + var.id());
            return false;
        }
        if (var.declaration() == null) {
            this.syms.declareBoundVar(var);
        }
        int kind2 = this.theTermNode.qfr().universal() ? quantifier.ALL : quantifier.EXISTS;
        quantifier q = new quantifier(kind2, var.makeAbstract());
        term subterm = this.subcheckTerm.theTermNode.makeAbstract();
        this.theTermNode.disambiguate(new term(q, subterm), null);
        return true;
    }

    public static boolean theseKinds(termNode t, BitSet kinds2) {
        if (!t.disambiguated()) {
            throw new InternalError("checkTerm.theseKinds");
        }
        boolean ok = true;
        HashSet<variable> freeVars = t.makeAbstract().freeVars();
        for (variable v : freeVars) {
            variableNode vn;
            sortNode sn;
            symTable syms;
            if (kinds2.get(v.kind())) continue;
            error.msg(t, "illegal use of " + variable.kindAsString(v.kind()) + " " + v.id());
            if (Options.debug()) {
                syms = symTable.get();
                sn = checkSort.now(new sortNode(v.sort(), t.scope()));
                vn = syms.find(new variableNode(v.id(), sn, t.scope()));
                error.msgStartDetails("Permissible variable kinds:");
                int j = 0;
                while (j <= kinds2.length()) {
                    error.moreDetails().eol().put(variable.kindAsString(j));
                    ++j;
                }
                error.msgEndDetails();
            }
            syms = symTable.get();
            sn = checkSort.now(new sortNode(v.sort(), t.scope()));
            vn = syms.find(new variableNode(v.id(), sn, t.scope()));
            if (vn.kind() != 3 && vn.kind() != 8 && vn.kind() != 4 && vn.kind() != 9 && vn.kind() != 6 && vn.kind() != 11) {
                error.warn(vn, "here is declaration of " + v + " as " + StringOps.addArticle(variable.kindAsString(vn.kind())));
            }
            ok = false;
        }
        return ok;
    }

    private boolean occursFreely(variableNode v) {
        switch (this.theTermNode.kind()) {
            case 0: {
                int i = 0;
                while (i < this.argChecks.length) {
                    if (this.argChecks[i].occursFreely(v)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 1: {
                return !v.equals(this.theTermNode.qfr().var()) && this.subcheckTerm.occursFreely(v);
            }
            case 2: {
                Enumeration<variableNode> e = this.pVars.elements();
                while (e.hasMoreElements()) {
                    if (!v.equals(e.nextElement())) continue;
                    return true;
                }
                return false;
            }
        }
        throw new InternalError("checkTerm.occursFreely");
    }

    private boolean disambiguateZeroaryTerm(sortNode sn) {
        variableNode pVar = null;
        Enumeration<variableNode> e = this.pVars.elements();
        while (e.hasMoreElements()) {
            variableNode vn = e.nextElement();
            if (!sortNode.isSubsort(vn.sort(), sn) || pVar != null && !sortNode.isSubsort(vn.sort(), pVar.sort())) continue;
            pVar = vn;
        }
        if (pVar != null) {
            if (this.theTermNode.scope().automaticVars() && this.syms.find(pVar) == null) {
                checkAutomaton.checkVar(7, pVar, null, true);
            }
            this.pVars = new Vector();
            this.pVars.addElement(pVar);
            this.theTermNode.disambiguate(new term(pVar.makeAbstract()), null);
            return true;
        }
        operatorNode pOp = null;
        Enumeration<operatorNode> e2 = this.pOps.elements();
        while (e2.hasMoreElements()) {
            operatorNode op = e2.nextElement();
            sortNode r = op.sig().range();
            if (!sortNode.isSubsort(r, sn) || pOp != null && !sortNode.isSubsort(r, pOp.sig().range())) continue;
            pOp = op;
        }
        if (pOp != null) {
            sort theSort = null;
            if (pOp.sig().range().equals(predefined.typeSort)) {
                sortNode sn1 = new sortNode(pOp.id().string(), this.theTermNode.scope());
                if (!this.syms.declare(sn1)) {
                    sn1 = checkSort.now(sn1);
                }
                theSort = sn1.makeAbstract();
                if (pOp.declaration() == null) {
                    this.syms.declare(pOp);
                }
            }
            this.theTermNode.disambiguate(new term(new term[0], pOp.makeAbstract()), theSort);
            return true;
        }
        error.msg(this.theTermNode.id(), "undeclared constant or variable of type " + sn);
        return false;
    }
}

