/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.checker.Check;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.sortEnum;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.sortUnion;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.Abstractify;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.fieldNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.shorthandNode;
import com.veromodo.tioa.parser.signatureNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.util.error;

public class checkShorthand
extends Check {
    private shorthandNode sh;
    private sortNode sort;
    private symTable syms = symTable.get();

    private checkShorthand(sortNode sn, shorthandNode sh) {
        this.sort = sn;
        this.sh = sh;
    }

    public static boolean now(sortNode sn, shorthandNode sh, boolean checkDups) {
        if (sh.status() != Node.status.UNCHECKED) {
            return sh.status() == Node.status.OK;
        }
        checkShorthand c = new checkShorthand(sn, sh);
        switch (sh.kind()) {
            case 0: {
                return c.checkEnumeration(checkDups);
            }
            case 1: {
                return c.checkTuple();
            }
            case 2: {
                return c.checkUnion();
            }
        }
        throw new InternalError("checkShorthand.now");
    }

    public static boolean now(sortNode sn, shorthandNode sh) {
        return checkShorthand.now(sn, sh, true);
    }

    private boolean checkEnumeration(boolean checkDups) {
        boolean ok = true;
        Abstractifiable[] theElems = new operatorNode[this.sh.nElems()];
        signatureNode sig = new signatureNode(this.sort);
        int i = 0;
        while (i < this.sh.nElems() && ok) {
            ltoken t = this.sh.elem(i);
            theElems[i] = new operatorNode(new nameNode(0, t), sig);
            if (ok &= !checkDups || !checkShorthand.isDuplicate((operatorNode[])theElems, i, false)) {
                this.syms.declare(theElems[i]);
            } else {
                error.msg(t, "duplicate element " + t + " in enumeration");
            }
            ++i;
        }
        nameNode n = nameNode.makeFunction("succ", 1, this.sh.scope());
        operatorNode succ = new operatorNode(n, new signatureNode(this.sort, this.sort));
        this.syms.declare(succ);
        if (ok) {
            Object[] Aops = new operator[theElems.length];
            sortEnum result = new sortEnum(this.sort.makeAbstract(), (operator[])Abstractify.map((Abstractifiable[])theElems, (Object[])Aops), succ.makeAbstract());
            this.sh.abstractify(result);
        }
        return ok;
    }

    private boolean checkTuple() {
        boolean ok = true;
        int n = this.sh.nElems();
        Abstractifiable[] gets = new operatorNode[n];
        Abstractifiable[] sets = new operatorNode[n];
        String[] fieldNames = new String[n];
        sortNode[] fieldSorts = new sortNode[n];
        int i = 0;
        while (i < this.sh.nElems()) {
            fieldNode fn = this.sh.field(i);
            fieldSorts[i] = fn.sort();
            ok &= checkSort.declare(fn.sort());
            if (fn.sort().status() != Node.status.BAD && this.sort.equals(fn.sort())) {
                error.msg(fn.sort(), "field type " + fn.sort() + " must differ from tuple type " + this.sort);
                fn.sort().setBadStatus();
                ok = false;
            }
            ltoken id = fn.id();
            fieldNames[i] = id.toString();
            gets[i] = new operatorNode(new nameNode(9, id), new signatureNode(this.sort, fn.sort()));
            sets[i] = new operatorNode(nameNode.makeFunction("set_" + id, 2, this.sh.scope()), new signatureNode(this.sort, fn.sort(), this.sort));
            this.syms.declare((operatorNode)gets[i]);
            this.syms.declare((operatorNode)sets[i]);
            if (checkShorthand.isDuplicate((operatorNode[])gets, i, true)) {
                error.msg(id, "duplicate field " + id + " in tuple");
                ok = false;
            }
            ++i;
        }
        nameNode b = new nameNode(opSym.bracketOp(false, n, false), this.sh.scope());
        operatorNode makeOp = new operatorNode(b, new signatureNode(fieldSorts, this.sort));
        this.syms.declare(makeOp);
        if (ok) {
            Object[] Agets = new operator[gets.length];
            Object[] Asets = new operator[sets.length];
            sortTuple result = new sortTuple(this.sort.makeAbstract(), fieldNames, (operator[])Abstractify.map((Abstractifiable[])gets, (Object[])Agets), (operator[])Abstractify.map((Abstractifiable[])sets, (Object[])Asets), makeOp.makeAbstract());
            this.sh.abstractify(result);
        }
        return ok;
    }

    public boolean checkUnion() {
        boolean ok = true;
        int n = this.sh.nElems();
        String[] fieldNames = new String[n];
        Abstractifiable[] toS = new operatorNode[n];
        Abstractifiable[] fromS = new operatorNode[n];
        sortNode tagS = this.sort.changeId(this.sort.id() + "_tag");
        ok &= checkSort.declare(tagS);
        ltoken[] elements = new ltoken[n];
        int i = 0;
        while (i < this.sh.nElems()) {
            ltoken id;
            fieldNode fn = this.sh.field(i);
            ok &= checkSort.declare(fn.sort());
            if (fn.sort().status() != Node.status.BAD && this.sort.equals(fn.sort())) {
                error.msg(fn.sort(), "field type " + fn.sort() + "' must differ from union type " + this.sort);
                fn.sort().setBadStatus();
                ok = false;
            }
            elements[i] = id = fn.id();
            fieldNames[i] = id.toString();
            fromS[i] = new operatorNode(new nameNode(9, id), new signatureNode(this.sort, fn.sort()));
            toS[i] = new operatorNode(nameNode.makeFunction(id.toString(), 1, id.scope()), new signatureNode(fn.sort(), this.sort));
            this.syms.declare((operatorNode)fromS[i]);
            this.syms.declare((operatorNode)toS[i]);
            if (checkShorthand.isDuplicate((operatorNode[])fromS, i, false)) {
                error.msg(id, "duplicate field " + id + " in union");
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            return ok;
        }
        shorthandNode e = new shorthandNode(elements);
        nameNode tag = nameNode.makeFunction("tag", 1, this.sh.scope());
        operatorNode tagOp = new operatorNode(tag, new signatureNode(this.sort, tagS));
        this.syms.declare(tagOp);
        if (!(ok &= checkShorthand.now(tagS, e, false))) {
            return ok;
        }
        Object[] Afrom = new operator[fromS.length];
        Object[] Ato = new operator[toS.length];
        sortUnion result = new sortUnion(this.sort.makeAbstract(), fieldNames, (operator[])Abstractify.map((Abstractifiable[])fromS, (Object[])Afrom), (operator[])Abstractify.map((Abstractifiable[])toS, (Object[])Ato), (sortEnum)e.makeAbstract(), tagOp.makeAbstract());
        this.sh.abstractify(result);
        return ok;
    }

    private static boolean isDuplicate(operatorNode[] v, int n, boolean checkSort2) {
        int i = 0;
        while (i < n) {
            if (v[i] != null && (checkSort2 ? v[n].equals(v[i]) : v[n].id().equals(v[i].id()))) {
                v[n] = null;
                return true;
            }
            ++i;
        }
        return false;
    }
}

