/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.automaton.component;
import com.veromodo.tioa.automaton.resorting;
import com.veromodo.tioa.automaton.stateVariable;
import com.veromodo.tioa.automaton.value;
import com.veromodo.tioa.checker.Check;
import com.veromodo.tioa.checker.Options;
import com.veromodo.tioa.checker.acPair;
import com.veromodo.tioa.checker.checkAutomaton;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.checkTerm;
import com.veromodo.tioa.checker.predefined;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.Abstractify;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.actionActuals;
import com.veromodo.tioa.parser.actionNode;
import com.veromodo.tioa.parser.actionSetNode;
import com.veromodo.tioa.parser.automatonDefNode;
import com.veromodo.tioa.parser.basicAutomatonNode;
import com.veromodo.tioa.parser.componentNode;
import com.veromodo.tioa.parser.compositionNode;
import com.veromodo.tioa.parser.declarationNode;
import com.veromodo.tioa.parser.detFireNode;
import com.veromodo.tioa.parser.detFollowNode;
import com.veromodo.tioa.parser.detScheduleNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.statesNode;
import com.veromodo.tioa.parser.termNode;
import com.veromodo.tioa.parser.transitionNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.parser.withNode;
import com.veromodo.tioa.util.Factorable;
import com.veromodo.tioa.util.error;
import com.veromodo.tioa.util.factoring;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class checkComposition
extends checkAutomaton {
    private compositionNode composition;
    private component[] components;
    private componentNode[] compNodes;

    private checkComposition(automatonDefNode a) {
        super(a);
        this.composition = a.compositionBody();
        this.components = new component[this.composition.nElems()];
    }

    public static boolean now(automatonDefNode a) {
        checkComposition c = new checkComposition(a);
        return c.checkComponents() && c.checkWithBlock() && c.extractStates() && c.checkSignature() && c.checkSchedule();
    }

    private boolean checkComponents() {
        boolean ok = true;
        int i = 0;
        while (i < this.composition.nElems()) {
            componentNode c = this.composition.elem(i);
            this.components[i] = this.checkComponent(c);
            if (this.components[i] == null) {
                ok = false;
            } else {
                syms.extend(this.ad.scope(), c.automaton().scope(), c.sortMap());
            }
            ++i;
        }
        if (!ok) {
            this.ad.setBadStatus();
        }
        return ok;
    }

    private component checkComponent(componentNode c) {
        automatonDefNode base;
        boolean ok = true;
        Check chk = new Check();
        Abstractifiable[] formals = new variableNode[c.nFormals()];
        int i = 0;
        while (i < c.nFormals()) {
            formals[i] = c.formal(i);
            ok = formals[i].newFactor() && checkSort.now(formals[i].sort()) == null ? false : (ok &= checkComposition.checkVar(16, formals[i], null, true));
            ++i;
        }
        if (c.where() != null) {
            ok &= (ok &= checkTerm.boolSort(c.where())) ? checkTerm.theseKinds(c.where(), variable.componentKinds()) : false;
        }
        if ((base = checkComposition.findAutomaton(c.automatonName())) == null) {
            return null;
        }
        if (base.status() != Node.status.OK) {
            c.makeAbstract(null, base);
            error.msg(base.name(), "automaton " + base.name() + " for component contains errors");
            return null;
        }
        if (base.nFormals() != c.nActuals()) {
            error.msg(base.name(), "too " + (base.nFormals() < c.nActuals() ? "many " : "few ") + "actual parameters for " + base.name());
            return null;
        }
        term[] autActuals = new term[c.nActuals()];
        resorting r = new resorting(c.nActuals());
        int i2 = 0;
        while (i2 < c.nActuals() && i2 < base.nFormals()) {
            termNode actual2;
            formalNode f = base.formal(i2);
            if (f.kind() == formal.kind.TYPE && (ok &= checkTerm.thisSort(actual2 = c.actual(i2), predefined.typeSort))) {
                r.add(f.type().makeAbstract(), actual2.makeAbstractSort());
                autActuals[i2] = c.actual(i2).makeAbstract();
            }
            ++i2;
        }
        r.freeze();
        Scope sc = c.scope();
        int i32 = 0;
        while (i32 < c.nActuals()) {
            formalNode f = base.formal(i32);
            if (f.kind() == formal.kind.VAR) {
                sort formalSort = r.map(f.var().sort().makeAbstract());
                if (ok &= (ok &= checkTerm.thisSort(c.actual(i32), new sortNode(formalSort, sc))) ? checkTerm.theseKinds(c.actual(i32), variable.componentKinds()) : false) {
                    autActuals[i32] = c.actual(i32).makeAbstract();
                }
            }
            ++i32;
        }
        if (!ok) {
            return null;
        }
        if (Options.expand()) {
            if (base.isComposite()) {
                error.msg(base, "can't (yet) expand composite components of compositions");
                return null;
            }
            basicAutomatonNode i32 = base.basicBody();
        }
        Object[] Aformals = new variable[formals.length];
        component result = new component(this.ad.statesVar().makeAbstract(), c.name().toString(), (variable[])Abstractify.map((Abstractifiable[])formals, (Object[])Aformals), new factoring((Factorable[])formals), base.makeAbstract(), autActuals, Abstractify.predicate(c.where()), r);
        c.makeAbstract(result, base);
        return result;
    }

    private boolean checkSignature() {
        boolean ok = true;
        Hashtable<String, acPair> acts = new Hashtable<String, acPair>();
        int i = 0;
        while (i < this.composition.nElems()) {
            componentNode component2 = this.composition.elem(i);
            if (component2.automaton().isComposite()) {
                Options.compositeComponent(true);
                if (this.composition.hidden().length > 0) {
                    error.warn(component2, "Warning: ignoring all hidden statements because they may refer to action(s) of a composite component.");
                }
            }
            automaton base = component2.automaton().makeAbstract();
            int j = 0;
            while (j < base.nActions()) {
                action a = base.action(j);
                acPair p = acts.get(a.name());
                if (p == null) {
                    acts.put(a.name(), new acPair(a, component2));
                } else {
                    ok &= checkComposition.compareActionParameters(a, component2, p.a, p.c);
                    if (a.kind() == action.kinds.OUTPUT) {
                        acts.put(a.name(), new acPair(a, component2));
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!Options.compositeComponent()) {
            ok &= this.checkHidden(acts);
        }
        return ok;
    }

    private boolean checkHidden(Hashtable<String, acPair> acts) {
        boolean ok = true;
        int i = 0;
        while (i < this.composition.hidden().length) {
            actionSetNode as = this.composition.hidden()[i];
            acPair p = acts.get(as.name().toString());
            if (p == null) {
                error.msg(as.name(), "unknown action " + as.name());
                ok = false;
            } else if (p.a.kind() != action.kinds.OUTPUT) {
                error.msg(as.name(), "only output actions can be hidden");
                ok = false;
            } else {
                ok &= this.checkActionActuals(as, p.a, p.c);
            }
            ++i;
        }
        return ok;
    }

    private static boolean compareActionParameters(action a1, componentNode c1, action a2, componentNode c2) {
        boolean ok = true;
        if (a1.nFormals() != a2.nFormals()) {
            error.msg(c1.name(), "arity of action " + a1.name() + " differs in components " + c1.name() + ", " + c2.name());
            ok = false;
        }
        int k = 0;
        while (k < Math.min(a1.nFormals(), a2.nFormals())) {
            sort s2;
            sort s1 = c1.sortMap().map(a1.formal(k).sort());
            if (!s1.equals(s2 = c2.sortMap().map(a2.formal(k).sort()))) {
                error.msg(c1.name(), "different types for parameter " + (k + 1) + " of action " + a1.name());
                error.msgStartDetails("  ").fill().print(s1).blank().put("in").blank().print(c1.name()).end().eol().fill().print(s2).blank().put("in").blank().print(c2.name()).end();
                error.msgEndDetails();
                ok = false;
            }
            ++k;
        }
        return ok;
    }

    private boolean checkActionActuals(actionActuals aa, action a, componentNode c) {
        boolean ok = true;
        if (a.nFormals() != aa.nActuals()) {
            error.msg(aa.name(), "too " + (a.nFormals() < aa.nActuals() ? "many " : "few ") + "actual parameters for " + a.name());
            ok = false;
        }
        Scope sc = c.scope();
        int i = 0;
        while (i < Math.min(a.nFormals(), aa.nActuals())) {
            sort formalSort = c.sortMap().map(a.formal(i).sort());
            ok &= (ok &= checkTerm.thisSort(aa.actual(i), new sortNode(formalSort, sc))) ? checkTerm.theseKinds(aa.actual(i), variable.hiddenKinds()) : false;
            ++i;
        }
        if (aa.nActuals() > 0) {
            syms.redeclareVars(aa.scope(), aa.actual(0).scope());
        }
        if (aa.where() != null) {
            ok &= (ok &= checkTerm.boolSort(aa.where())) ? checkTerm.theseKinds(aa.where(), variable.hiddenKinds()) : false;
        }
        return ok;
    }

    private boolean extractStates() {
        boolean ok = true;
        variableNode[] withStateVars = null;
        variableNode[] withPrimedStateVars = null;
        variableNode[] stateVars = new variableNode[this.composition.nElems()];
        variableNode[] primedStateVars = new variableNode[stateVars.length];
        int counterAdded = 0;
        int withAdded = 0;
        int i = 0;
        while (i < stateVars.length) {
            variableNode vPrime;
            variableNode v;
            stateVars[counterAdded] = v = this.makeStateVariable(this.composition.elem(i));
            primedStateVars[counterAdded] = vPrime = new variableNode(String.valueOf(v.id().toString()) + "'", v.sort(), v.scope());
            ++counterAdded;
            ++i;
        }
        if (this.composition.schedule() != null && this.composition.schedule().hasWithBlock()) {
            withNode wNode = this.composition.schedule().withBlock();
            withAdded = wNode.nDeclarations();
            withStateVars = new variableNode[withAdded];
            withPrimedStateVars = new variableNode[withStateVars.length];
            int i2 = 0;
            while (i2 < withStateVars.length) {
                variableNode vPrime;
                variableNode v;
                withStateVars[i2] = v = this.makeStateVariable(this.compNodes[i2]);
                withPrimedStateVars[i2] = vPrime = new variableNode(String.valueOf(v.id().toString()) + "'", v.sort(), v.scope());
                ++i2;
            }
        }
        int totalStates = counterAdded + withAdded;
        variableNode[] allStateVars = new variableNode[totalStates];
        variableNode[] allPrimedStateVars = new variableNode[totalStates];
        stateVariable[] states = new stateVariable[totalStates];
        variable[] primedStates = new variable[totalStates];
        int a = 0;
        while (a < totalStates) {
            if (a < counterAdded) {
                allStateVars[a] = stateVars[a];
                allPrimedStateVars[a] = primedStateVars[a];
            } else {
                allStateVars[a] = withStateVars[a - counterAdded];
                allPrimedStateVars[a] = withPrimedStateVars[a - counterAdded];
            }
            ++a;
        }
        ok &= this.makeStateTuple(this.ad, allStateVars, allPrimedStateVars);
        a = 0;
        while (a < totalStates) {
            states[a] = new stateVariable(allStateVars[a].makeAbstract(), new value(), this.ad.statesVar().sort().makeAbstract());
            primedStates[a] = allPrimedStateVars[a].makeAbstract();
            ++a;
        }
        this.composition.states(states);
        this.composition.primedStates(primedStates);
        return ok;
    }

    private variableNode makeStateVariable(componentNode c) {
        automatonDefNode base = c.automaton();
        resorting r = c.sortMap();
        sortNode sn = new sortNode(r.map(base.statesVar().sort().makeAbstract()), c.scope());
        if (c.nFormals() == 0) {
            return new variableNode(c.name().toString(), sn, this.composition.scope());
        }
        sortNode[] subsorts = new sortNode[c.nFormals() + 1];
        int j = 0;
        while (j < c.nFormals()) {
            subsorts[j] = c.formal(j).sort();
            ++j;
        }
        subsorts[c.nFormals()] = sn;
        sortNode mapSort = new sortNode("Map", subsorts, this.composition.scope());
        checkSort.now(mapSort);
        return new variableNode(c.name().toString(), mapSort, this.composition.scope());
    }

    @Override
    protected boolean checkSchedule() {
        boolean ok = true;
        detScheduleNode schedule2 = this.composition.schedule();
        if (schedule2 == null) {
            return true;
        }
        if (schedule2.states() != null) {
            ok &= this.checkCompNDRStates(schedule2.states(), this.ad);
        }
        if (schedule2.program() != null && schedule2.program().nStatements() != 0) {
            ok &= this.checkProgram(schedule2.program(), variable.scheduleKinds());
        }
        if (!ok) {
            schedule2.setBadStatus();
        }
        return ok;
    }

    @Override
    protected boolean checkDetFire(detFireNode f) {
        boolean ok = true;
        ltoken comp = null;
        automatonDefNode adf = null;
        if (f.name() == null) {
            return true;
        }
        if (this.composition.schedule().hasWithBlock()) {
            comp = this.composition.getAutNameByCompName(this.composition.schedule().withBlock().getCompName(f.compName()));
        }
        if (comp == null) {
            comp = this.composition.getAutNameByCompName(f.compName());
            if (comp == null) {
                error.msg(f.name(), f.compName() + " is not a valid component name ");
                return false;
            }
            componentNode compN = this.composition.getComponentByName(f.compName());
            if (compN.nFormals() != 0) {
                error.msg(f.name(), " components based on " + f.compName() + " must be declared in a with block ");
                return false;
            }
        }
        adf = checkComposition.findAutomaton(comp);
        basicAutomatonNode basicBody = adf.basicBody();
        int actionIndex = this.findAction(f.name(), f.kind(), basicBody.nActions(), basicBody);
        if (actionIndex < 0) {
            error.msg(f.name(), String.valueOf(action.kind2String(f.kind())) + " action " + f.name() + " not in automaton's signature");
            return false;
        }
        actionNode aNode = basicBody.action(actionIndex);
        transitionNode tNode = this.getTransitionForCase(f.name(), aNode, f.caseName());
        if (tNode != null) {
            ok &= this.checkInvocation(tNode, f);
            f.setTransition(tNode);
        }
        if (!ok) {
            f.setBadStatus();
        }
        return ok;
    }

    @Override
    protected boolean checkDetFollow(detFollowNode f) {
        ltoken comp = this.composition.getAutNameByCompName(f.compName());
        if (comp == null) {
            error.msg(f.name(), f.compName() + " is not a valid component name ");
            return false;
        }
        basicAutomatonNode basicBody = checkComposition.findAutomaton(comp).basicBody();
        boolean ok = false;
        int i = 0;
        while (!ok && i < basicBody.nTrajectories()) {
            if (basicBody.trajectory(i).name().equals(f.name())) {
                f.setTrajectory(basicBody.trajectory(i));
                ok = true;
            }
            ++i;
        }
        if (!ok) {
            error.msg(f.name(), "undefined trajectory " + f.name());
        }
        if (!(ok &= checkTerm.thisSort(f.howLong(), predefined.augmentedRealSort))) {
            f.setBadStatus();
        }
        return ok;
    }

    private int findAction(ltoken name, action.kinds k, int n, basicAutomatonNode bB) {
        int i = 0;
        while (i < n) {
            actionNode aNode = bB.action(i);
            if (name.equals(aNode.name()) && (k == aNode.kind() || k == null)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean checkWithBlock() {
        boolean ok = true;
        termNode tn = null;
        Object cn = null;
        variableNode vn = null;
        sortNode sn = null;
        detScheduleNode schedule2 = this.composition.schedule();
        if (schedule2 == null) {
            return true;
        }
        declarationNode ino = null;
        Hashtable<ltoken, ltoken> duplicateTest = new Hashtable<ltoken, ltoken>();
        if (!schedule2.hasWithBlock()) {
            return true;
        }
        withNode in = schedule2.withBlock();
        this.compNodes = new componentNode[in.nDeclarations()];
        int a = 0;
        while (a < in.nDeclarations()) {
            ino = in.declaration(a);
            boolean canCheckTerms = true;
            ltoken baseCompName = ino.compName();
            ltoken handle = ino.handleName();
            if (handle == null) {
                error.msg(in, "illegal handle name");
                return false;
            }
            if (duplicateTest.put(handle, handle) != null) {
                error.msg(ino, "duplicate handle name " + handle);
                ok = false;
            }
            if (this.composition.getAutNameByCompName(handle) != null) {
                error.msg(ino, handle + " already used as a component name");
                ok = false;
            }
            componentNode compBase = this.composition.getComponentByName(baseCompName);
            componentNode newComp = new componentNode();
            if (compBase == null) {
                error.msg(ino, baseCompName + " is not a valid component name");
                canCheckTerms = false;
                ok = false;
            }
            if (compBase != null && ino.nTerms() != compBase.nFormals()) {
                if (ino.nTerms() > compBase.nFormals()) {
                    error.msg(ino, " too many formals specified for component " + compBase.name());
                } else {
                    error.msg(ino, " too few formals specified for component " + compBase.name());
                }
                ok = false;
                canCheckTerms = false;
            }
            if (ok) {
                newComp.set(compBase, compBase, null);
                newComp.changeName(ino.handleName());
                newComp.setFormals(null);
                Abstractifiable[] formals = new variableNode[newComp.nFormals()];
                int i = 0;
                while (i < newComp.nFormals()) {
                    formals[i] = newComp.formal(i);
                    ++i;
                }
                term[] autActuals = new term[newComp.nActuals()];
                automatonDefNode base = checkComposition.findAutomaton(newComp.automatonName());
                resorting r = new resorting(newComp.nActuals());
                r.freeze();
                Object[] Aformals = new variable[formals.length];
                component abstractComponent = new component(this.ad.statesVar().makeAbstract(), newComp.name().toString(), (variable[])Abstractify.map((Abstractifiable[])formals, (Object[])Aformals), new factoring((Factorable[])formals), base.makeAbstract(), autActuals, Abstractify.predicate(newComp.where()), r);
                newComp.makeAbstract(abstractComponent, base);
                syms.extend(this.ad.scope(), newComp.automaton().scope(), newComp.sortMap());
                this.compNodes[a] = newComp;
            }
            if (canCheckTerms) {
                int b = 0;
                while (b < ino.nTerms()) {
                    tn = ino.term(b);
                    vn = compBase.formal(b);
                    sn = vn.sort();
                    tn.setScope(sn.scope());
                    ok &= checkTerm.thisSort(tn, sn);
                    ++b;
                }
            }
            ++a;
        }
        return ok;
    }

    private boolean checkCompNDRStates(statesNode sn, Node ad) {
        boolean ok = true;
        ok = checkAutomaton.checkNDRStates(sn, ad);
        if (this.composition.schedule().hasWithBlock()) {
            withNode wNode = this.composition.schedule().withBlock();
            int nVars = sn.nVars();
            int i = 0;
            while (i < nVars) {
                variableNode var = sn.var(i);
                if (wNode.getCompName(var.id()) != null) {
                    error.msg(var, var.id() + " used both as a state variable and a handle name");
                    ok = false;
                }
                ++i;
            }
        }
        return ok;
    }
}

