/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.checker.checkAutomaton;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.checkTerm;
import com.veromodo.tioa.checker.predefined;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.actionActuals;
import com.veromodo.tioa.parser.actionNode;
import com.veromodo.tioa.parser.actionSetNode;
import com.veromodo.tioa.parser.automatonDefNode;
import com.veromodo.tioa.parser.detChoiceNode;
import com.veromodo.tioa.parser.forNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.funcDeclNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.signatureNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.statesNode;
import com.veromodo.tioa.parser.taskNode;
import com.veromodo.tioa.parser.termNode;
import com.veromodo.tioa.parser.trajectoryNode;
import com.veromodo.tioa.parser.transitionNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.util.error;
import com.veromodo.tioa.util.location;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;

public class checkBasicAutomaton
extends checkAutomaton {
    static operator augDerivOp = new operator(opSym.derivSym, new signature(sort.augmentedRealSort, sort.augmentedRealSort));
    static operator realDerivOp = new operator(opSym.derivSym, new signature(sort.realSort, sort.realSort));

    protected checkBasicAutomaton(automatonDefNode a) {
        super(a);
        this.basicBody = a.basicBody();
    }

    public static boolean now(automatonDefNode a) {
        boolean ok = true;
        checkBasicAutomaton c = new checkBasicAutomaton(a);
        int i = 0;
        while (i < c.basicBody.nActions()) {
            ok &= c.checkAction(i);
            ++i;
        }
        boolean statesOK = c.checkStateVars();
        ok &= c.checkInitialStates();
        if (statesOK) {
            int j = 0;
            while (j < c.basicBody.nFuncDecls()) {
                ok &= checkBasicAutomaton.checkFuncDecl(c.basicBody.funcDecl(j));
                ++j;
            }
            ok &= c.checkAllTransitionParameters(a);
            int i2 = 0;
            while (i2 < c.basicBody.nTransitions()) {
                ok &= c.checkTransitionBody(c.basicBody.transition(i2));
                ++i2;
            }
            ok &= c.checkTrajectories();
            ok &= c.checkTasks();
            ok &= c.checkSchedule();
        }
        if (!(ok &= statesOK)) {
            a.setBadStatus();
        }
        return ok;
    }

    private boolean checkAction(int n) {
        int earlierIndex;
        boolean ok = true;
        actionNode aNode = this.basicBody.action(n);
        String err = "";
        if (!this.checkActionFormals(aNode)) {
            aNode.setBadStatus();
            return false;
        }
        if (aNode.where() != null) {
            if (!(ok &= checkTerm.boolSort(aNode.where()))) {
                return false;
            }
            ok &= checkTerm.theseKinds(aNode.where(), variable.actionFormalKinds());
        }
        if ((earlierIndex = this.findAction(aNode.name(), aNode.kind(), n)) < 0) {
            earlierIndex = this.findAction(aNode.name(), null, n);
        } else {
            err = String.valueOf(action.kind2String(aNode.kind())) + " action already defined";
            ok = false;
        }
        if (ok && earlierIndex >= 0) {
            actionNode anotherNode = this.basicBody.action(earlierIndex);
            if (aNode.nFormals() == anotherNode.nFormals()) {
                int j = 0;
                while (j < aNode.nFormals() && ok) {
                    formal f1 = aNode.formal(j).makeAbstract();
                    formal f2 = anotherNode.formal(j).makeAbstract();
                    if (f1 != null && f2 != null && !f1.sort().equals(f2.sort())) {
                        err = "conflicting parameter types";
                        ok = false;
                    }
                    ++j;
                }
                if (ok && aNode.where() == null && anotherNode.where() == null) {
                    err = "conflicting kinds";
                    ok = false;
                }
            } else {
                err = "different number of parameters than before";
                ok = false;
            }
        }
        if (!ok) {
            error.msg(aNode.name(), String.valueOf(err) + " for action " + aNode.name());
            error.msg(this.basicBody.action(earlierIndex).name(), "<- conflicting definition");
            aNode.setBadStatus();
        }
        return ok;
    }

    private boolean checkTransitionLocals(automatonDefNode a, transitionNode tn) {
        boolean ok = true;
        sortNode autSortNode = new sortNode(a.name(), this.ad.scope()).restrict();
        int nTypeParams = 0;
        int i = 0;
        while (i < a.nFormals()) {
            if (a.formal(i).kind() == formal.kind.TYPE) {
                ++nTypeParams;
            }
            ++i;
        }
        sortNode[] subsorts = new sortNode[nTypeParams + 4];
        subsorts[0] = autSortNode;
        int j = 1;
        int i2 = 0;
        while (i2 < a.nFormals()) {
            formalNode f = a.formal(i2);
            if (f.kind() == formal.kind.TYPE) {
                subsorts[j++] = new sortNode(f.type().id());
            }
            ++i2;
        }
        subsorts[j++] = new sortNode(tn.name(), a.scope()).restrict();
        subsorts[j++] = new sortNode(action.kind2SortName(tn.kind()), a.scope()).restrict();
        subsorts[j++] = new sortNode("c" + tn.transitionIndex(), a.scope()).restrict();
        sortNode localSort = new sortNode(new ltoken("_Locals", new location("CONSTRUCTED", 0, 0, 0, 0), a.scope()), subsorts);
        syms.declare(localSort.constructor());
        int i3 = 0;
        while (i3 < subsorts.length) {
            syms.declare(subsorts[i3]);
            ++i3;
        }
        syms.declare(localSort);
        variableNode localsVar = new variableNode(a.name().toString(), localSort, tn.scope());
        variableNode primedLocalsVar = new variableNode(String.valueOf(a.name().toString()) + "'", localSort, tn.scope());
        ok &= checkBasicAutomaton.checkVar(8, localsVar, null, true);
        ok &= checkBasicAutomaton.checkVar(9, primedLocalsVar, null, true);
        tn.localsVar(localsVar);
        tn.primedLocalsVar(primedLocalsVar);
        variableNode[] primedLocalVars = new variableNode[tn.nLocals()];
        int i4 = 0;
        while (i4 < tn.nLocals()) {
            variableNode vPrime;
            variableNode vn = tn.local(i4);
            if (vn.newFactor() && checkSort.now(vn.sort()) == null) {
                ok = false;
            }
            primedLocalVars[i4] = vPrime = new variableNode(String.valueOf(vn.id().toString()) + "'", vn.sort(), vn.scope());
            ++i4;
        }
        tn.primedLocals(primedLocalVars);
        if (tn.nLocals() != 0) {
            ok &= checkBasicAutomaton.makeLocalTuple(this.ad, tn);
        }
        tn.setFinalStatus(ok);
        if (tn.status() == Node.status.BAD) {
            this.ad.setBadStatus();
        }
        return ok;
    }

    private boolean checkActionFormals(actionNode act) {
        formalNode fn;
        boolean ok = true;
        int i = 0;
        while (i < act.nFormals()) {
            fn = act.formal(i);
            if (fn.kind() == formal.kind.VAR) {
                ok &= checkBasicAutomaton.checkFormalVariable(fn, 2);
            }
            ++i;
        }
        i = 0;
        while (i < act.nFormals()) {
            fn = act.formal(i);
            if (fn.kind() == formal.kind.CONST) {
                ok &= checkBasicAutomaton.checkFormalConst(act.formal(i), variable.actionFormalKinds());
            }
            ++i;
        }
        if (!ok) {
            act.setBadStatus();
        }
        return ok;
    }

    protected static boolean checkFormalVariable(formalNode fn, int varKind) {
        boolean ok = true;
        if (fn.kind() != formal.kind.VAR) {
            throw new InternalError("checkAutomaton.checkFormalVariable");
        }
        ok = fn.newFactor() && checkSort.now(fn.sort()) == null ? false : (ok &= checkBasicAutomaton.checkVar(varKind, fn.var(), null, true));
        if (ok) {
            fn.setStatus(Node.status.OK);
            fn.var().setStatus(Node.status.OK);
        } else {
            fn.setBadStatus();
        }
        return ok;
    }

    protected static boolean checkFormalConst(formalNode fn, BitSet kinds2) {
        boolean ok = true;
        if (fn.kind() != formal.kind.CONST) {
            throw new InternalError("checkAutomaton.checkFormalConst");
        }
        if (ok &= (ok &= checkTerm.someSort(fn.constant())) ? checkTerm.theseKinds(fn.constant(), kinds2) : false) {
            sortNode sn = fn.sort();
            if (sn == null) {
                throw new InternalError("checkAutomaton.checkFormalConst");
            }
            if (sn.restricted() || sn.equals(predefined.typeSort) || sn.equals(sort.realSortD)) {
                error.msg(fn, "const parameter cannot have type " + sn);
                fn.constant().setBadStatus();
                ok = false;
            } else {
                fn.constant().setStatus(Node.status.OK);
            }
        }
        return fn.setFinalStatus(ok);
    }

    public boolean checkInitialStates() {
        boolean ok = true;
        BitSet vkinds = new BitSet();
        vkinds.set(1);
        vkinds.set(5);
        statesNode states = this.basicBody.states();
        int i = 0;
        while (i < states.nVars()) {
            if (states.var(i).status() != Node.status.BAD) {
                sortNode sort2 = states.var(i).sort();
                if (states.value(i) != null) {
                    ok = states.value(i).isTerm() ? (ok &= (ok &= checkTerm.thisSort(states.value(i).term(), sort2)) ? checkTerm.theseKinds(states.value(i).term(), variable.initValueKinds()) : false) : (ok &= this.checkChoose(new termNode(states.var(i)), states.value(i).choose(), vkinds, variable.initValueKinds()));
                }
            }
            ++i;
        }
        return ok;
    }

    private boolean checkStateVars() {
        boolean ok = true;
        statesNode states = this.basicBody.states();
        states.setAutomatonSort(this.ad.statesVar().sort());
        variableNode[] stateVars = new variableNode[states.nVars()];
        variableNode[] primedStateVars = new variableNode[states.nVars()];
        int i = 0;
        while (i < states.nVars()) {
            variableNode var = states.var(i);
            if (checkSort.now(var.sort()) == null) {
                ok = false;
                var.setBadStatus();
                states.setBadStatus();
            }
            stateVars[i] = var;
            variableNode vPrime = new variableNode(String.valueOf(var.id().toString()) + "'", var.sort(), var.scope());
            states.state(i).primedVar(vPrime);
            primedStateVars[i] = vPrime;
            ++i;
        }
        if (ok) {
            ok &= this.makeStateTuple(this.ad, stateVars, primedStateVars);
            if (states.initially() != null) {
                ok &= (ok &= checkTerm.boolSort(states.initially())) ? checkTerm.theseKinds(states.initially(), variable.initiallyKinds()) : false;
                detChoiceNode dcn = states.ndr();
                if (dcn != null) {
                    if (dcn.yield() != null) {
                        error.msg(dcn.yield(), "Yield statement not supported in initially predicate");
                        ok = false;
                    } else {
                        ok &= this.checkProgram(dcn.program(), variable.initiallyKinds());
                    }
                }
            }
        }
        if (states.status() == Node.status.BAD) {
            this.ad.setBadStatus();
        } else {
            states.setFinalStatus(ok);
        }
        return ok;
    }

    private boolean checkAllTransitionParameters(automatonDefNode a) {
        boolean ok = true;
        int i = 0;
        while (i < this.basicBody.nTransitions()) {
            ok &= this.checkTransitionLocals(a, this.basicBody.transition(i));
            ok &= this.checkTransitionActuals(this.basicBody.transition(i));
            ++i;
        }
        i = 0;
        while (i < this.basicBody.nActions()) {
            actionNode aNode = this.basicBody.action(i);
            if (aNode.nTransitions() <= 0) {
                error.msg(aNode, "no transition specified for " + action.kind2String(aNode.kind()) + " action " + aNode.name());
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            a.setBadStatus();
        }
        return ok;
    }

    private boolean checkTransitionActuals(transitionNode t) {
        boolean ok = true;
        int actionIndex = this.findAction(t.name(), t.kind(), this.basicBody.nActions());
        if (actionIndex < 0) {
            error.msg(t.name(), String.valueOf(action.kind2String(t.kind())) + " action " + t.name() + " not in automaton's signature");
            t.setBadStatus();
            return false;
        }
        actionNode aNode = this.basicBody.action(actionIndex);
        aNode.addTransition(t);
        t.setAction(aNode);
        if (aNode.status() == Node.status.BAD) {
            return false;
        }
        ok &= checkBasicAutomaton.checkActionActuals(t, aNode, variable.transitionActualKinds());
        if (t.caseName() != null) {
            Enumeration<transitionNode> e = aNode.getTransitions();
            while (e.hasMoreElements()) {
                transitionNode t2 = e.nextElement();
                if (t.equals(t2) || t2.caseName() == null || !t2.caseName().equals(t.caseName())) continue;
                error.msg(t.caseName(), "repeated case label " + t.caseName() + " for " + action.kind2String(t.kind()) + " transition " + t.name());
                t.setBadStatus();
                return false;
            }
        }
        if (!ok) {
            t.setBadStatus();
        }
        return ok;
    }

    private boolean checkTrajectories() {
        boolean ok = true;
        int i = 0;
        while (i < this.basicBody.nTrajectories()) {
            trajectoryNode traj = this.basicBody.trajectory(i);
            int j = 0;
            while (j < traj.nInvariants()) {
                ok &= checkTerm.boolSort(traj.invariant(j));
                ++j;
            }
            if (traj.stopWhen() != null) {
                ok &= checkTerm.boolSort(traj.stopWhen());
            }
            j = 0;
            while (j < traj.nFuncDecls()) {
                ok &= checkBasicAutomaton.checkFuncDecl(traj.funcDecl(j));
                ++j;
            }
            j = 0;
            while (j < traj.nEvolvePredicates()) {
                ok &= this.checkEvolvePredicate(traj.evolvePredicate(j));
                ++j;
            }
            ++i;
        }
        return ok;
    }

    public static boolean checkFuncDecl(funcDeclNode f) {
        boolean ok = true;
        sortNode[] dom = new sortNode[f.nFormals()];
        int i = 0;
        while (i < f.nFormals()) {
            variableNode vn = f.formal(i);
            ok = vn.newFactor() && checkSort.now(vn.sort()) == null ? false : (ok &= checkBasicAutomaton.checkVar(19, vn, null, true));
            dom[i] = vn.sort();
            ++i;
        }
        if (!(ok &= checkTerm.someSort(f.def()))) {
            f.setBadStatus();
        }
        if (ok) {
            sortNode range = new sortNode(f.def().sort(), f.scope());
            signatureNode sig = new signatureNode(dom, range);
            nameNode nn = new nameNode(1, f.name());
            operatorNode op = new operatorNode(nn, sig);
            if (op.equals(predefined.derivOp)) {
                error.msg(f.name(), "use of d:Real->Real reserved for derivative operator");
            }
            if (syms.declare(op)) {
                f.setOperator(op.makeAbstract());
            } else {
                error.msg(f.name(), "function " + f.name() + " already defined");
                f.setBadStatus();
            }
        }
        return ok;
    }

    private boolean checkEvolvePredicate(termNode t) {
        boolean ok;
        opSym opId = null;
        boolean bl = ok = t.nArgs() == 2;
        if (ok) {
            opId = t.id().sym();
            boolean bl2 = ok = opId.equals(opSym.eqSym) || opId.isComparisonSym();
        }
        if (!ok) {
            error.msg(opId == null ? t : t.id(), "term must be an (in)equality");
            return false;
        }
        int t0Status = checkBasicAutomaton.checkEvolveTerm(t.arg(0));
        int t1Status = checkBasicAutomaton.checkEvolveTerm(t.arg(1));
        if (opId.equals(opSym.eqSym)) {
            if (t0Status == 2) {
                error.msg(t.arg(0), "term must be either an lvalue or the derivative of an lvalue");
                return false;
            }
            if (t1Status == 1) {
                error.msg(t.arg(1), "cannot have a derivative on the right side of '='");
                return false;
            }
        }
        if (t0Status == 1 && t1Status == 1) {
            error.msg(t.id(), "at most one term in comparison can be a derivative");
            return false;
        }
        if (t0Status == 3 || t1Status == 3) {
            return false;
        }
        operator op = new operator(opId, new signature(t.arg(0).makeAbstract().sort(), t.arg(1).makeAbstract().sort(), sort.boolSort));
        t.disambiguate(term.make(op, t.arg(0).makeAbstract(), t.arg(1).makeAbstract()), sort.boolSort);
        return true;
    }

    static int checkEvolveTerm(termNode t) {
        if (t.nArgs() == 1 && t.id().sym().equals(opSym.derivSym)) {
            termNode t1 = t.arg(0);
            if (!checkTerm.thisSort(t1, predefined.augmentedRealSort)) {
                return 3;
            }
            if (!checkBasicAutomaton.isLValue(t1)) {
                error.msg(t1, "term must be an lvalue");
                return 3;
            }
            if (t1.sort().equals(sort.augmentedRealSort)) {
                t.disambiguate(term.make(augDerivOp, t1.makeAbstract()), sort.augmentedRealSort);
            } else {
                t.disambiguate(term.make(realDerivOp, t1.makeAbstract()), sort.realSort);
            }
            return 1;
        }
        sortNode[] goodSorts = new sortNode[]{predefined.augmentedRealSort, predefined.realSort, predefined.augmentedRealSortD, predefined.realSortD};
        if (!checkTerm.someSort(t, goodSorts)) {
            return 3;
        }
        return checkBasicAutomaton.isLValue(t) ? 0 : 2;
    }

    static boolean isLValue(termNode tn) {
        sort s = tn.makeAbstract().sort();
        switch (tn.kind()) {
            case 2: {
                nameNode name = tn.id();
                Enumeration<variableNode> vars = syms.matchingVars(name.string(), name.scope());
                while (vars.hasMoreElements()) {
                    variableNode vn = vars.nextElement();
                    if (!s.equals(vn.sort().makeAbstract()) || vn.kind() != 5) continue;
                    return true;
                }
                return false;
            }
            case 0: {
                operator op = tn.makeAbstract().op();
                termNode head = tn.arg(0);
                sort headSort = head.makeAbstract().sort();
                if (op.opKind() == 9 || op.opKind() == 4 && headSort.nSubsorts() != 0 && (headSort.constructor().equals("Array") || headSort.constructor().equals("Map"))) {
                    return checkBasicAutomaton.isLValue(head);
                }
                return false;
            }
        }
        return false;
    }

    private boolean checkTasks() {
        boolean ok = true;
        int i = 0;
        while (i < this.basicBody.nTasks()) {
            taskNode task2 = this.basicBody.task(i);
            ok &= this.checkForNode(task2.forClause());
            int j = 0;
            while (j < task2.nActions()) {
                ok &= this.checkActionSetInTask(task2.action(j));
                ++j;
            }
            ++i;
        }
        return ok;
    }

    private boolean checkActionSetInTask(actionSetNode as) {
        boolean ok = true;
        int actionIndex = this.findAction(as.name(), null, this.basicBody.nActions());
        if (actionIndex < 0) {
            error.msg(as.name(), "unknown action " + as.name());
            ok = false;
        } else {
            actionNode aNode = this.basicBody.action(actionIndex);
            ok &= checkBasicAutomaton.checkActionActuals(as, aNode, variable.taskKinds());
        }
        if (!ok) {
            as.setBadStatus();
        }
        return ok;
    }

    private static boolean checkActionActuals(actionActuals actuals, actionNode aNode, BitSet kinds2) {
        boolean ok = true;
        if (aNode.nFormals() != actuals.nActuals()) {
            error.msg(actuals.name(), "too " + (aNode.nFormals() < actuals.nActuals() ? "many " : "few ") + "actual parameters for " + aNode.name());
            ok = false;
        }
        int i = 0;
        while (i < Math.min(aNode.nFormals(), actuals.nActuals())) {
            ok &= (ok &= checkTerm.thisSort(actuals.actual(i), aNode.formal(i).sort())) ? checkTerm.theseKinds(actuals.actual(i), kinds2) : false;
            ++i;
        }
        if (actuals.nActuals() > 0) {
            syms.redeclareVars(actuals.scope(), actuals.actual(0).scope());
        }
        if (actuals.where() != null) {
            ok &= (ok &= checkTerm.boolSort(actuals.where())) ? checkTerm.theseKinds(actuals.where(), kinds2) : false;
        }
        return ok;
    }

    private boolean checkTransitionBody(transitionNode t) {
        boolean ok = true;
        if (t.status() == Node.status.BAD) {
            return false;
        }
        int actionIndex = this.findAction(t.name(), t.kind(), this.basicBody.nActions());
        int j = 0;
        while (j < t.nFuncDecls()) {
            ok &= checkBasicAutomaton.checkFuncDecl(t.funcDecl(j));
            ++j;
        }
        if (t.nPreconditions() > 0) {
            if (t.kind() == action.kinds.INPUT) {
                error.msg(t.name(), "precondition not allowed for input action " + t.name());
                ok = false;
            }
            int i = 0;
            while (i < t.nPreconditions()) {
                ok &= (ok &= checkTerm.boolSort(t.pre(i))) ? checkTerm.theseKinds(t.pre(i), variable.preconditionKinds()) : false;
                ++i;
            }
        }
        if (t.urgency() != null) {
            ok &= checkTerm.boolSort(t.urgency());
        }
        if (t.eff() != null) {
            this.currentTrans = t;
            this.modifiedVars = t.eff().ensuring() == null ? null : new HashSet();
            ok &= this.checkProgram(t.eff().program(), variable.effectKinds());
            this.currentTrans = null;
            ok &= this.checkEnsuring(t);
        }
        if (!ok) {
            t.setBadStatus();
        }
        return ok;
    }

    boolean checkEnsuring(transitionNode t) {
        boolean ok = true;
        termNode ens = t.eff().ensuring();
        if (ens == null) {
            return true;
        }
        boolean bl = (ok &= checkTerm.boolSort(ens)) ? checkTerm.theseKinds(ens, variable.ensuringKinds()) : false;
        this.modifiedVars = null;
        if (!(ok &= bl)) {
            ens.setBadStatus();
        }
        return ok;
    }

    private boolean checkForNode(forNode fn) {
        boolean ok = true;
        if (fn == null) {
            return true;
        }
        int i = 0;
        while (i < fn.nElems()) {
            variableNode vn = fn.elem(i);
            ok = vn.newFactor() && checkSort.now(vn.sort()) == null ? false : (ok &= checkBasicAutomaton.checkVar(14, vn, null, true));
            ++i;
        }
        if (fn.where() != null) {
            ok &= (ok &= checkTerm.boolSort(fn.where())) ? checkTerm.theseKinds(fn.where(), variable.taskForKinds()) : false;
        }
        if (!ok) {
            fn.setBadStatus();
        }
        return ok;
    }
}

