/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.checker.Check;
import com.veromodo.tioa.checker.checkBasicAutomaton;
import com.veromodo.tioa.checker.checkComposition;
import com.veromodo.tioa.checker.checkShorthand;
import com.veromodo.tioa.checker.checkSort;
import com.veromodo.tioa.checker.checkTerm;
import com.veromodo.tioa.checker.checkVocab;
import com.veromodo.tioa.checker.predefined;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.actionNode;
import com.veromodo.tioa.parser.assignmentNode;
import com.veromodo.tioa.parser.automatonDefNode;
import com.veromodo.tioa.parser.basicAutomatonNode;
import com.veromodo.tioa.parser.builtIns;
import com.veromodo.tioa.parser.chooseNode;
import com.veromodo.tioa.parser.conditionalNode;
import com.veromodo.tioa.parser.detChoiceNode;
import com.veromodo.tioa.parser.detFireNode;
import com.veromodo.tioa.parser.detFollowNode;
import com.veromodo.tioa.parser.detScheduleNode;
import com.veromodo.tioa.parser.detWhileNode;
import com.veromodo.tioa.parser.detYieldNode;
import com.veromodo.tioa.parser.fieldNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.invocationNode;
import com.veromodo.tioa.parser.loopNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.programNode;
import com.veromodo.tioa.parser.shorthandNode;
import com.veromodo.tioa.parser.signatureNode;
import com.veromodo.tioa.parser.simFireNode;
import com.veromodo.tioa.parser.simFollowNode;
import com.veromodo.tioa.parser.simSubNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.specs;
import com.veromodo.tioa.parser.statementNode;
import com.veromodo.tioa.parser.statesNode;
import com.veromodo.tioa.parser.termNode;
import com.veromodo.tioa.parser.trajectoryNode;
import com.veromodo.tioa.parser.transitionNode;
import com.veromodo.tioa.parser.valueNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.util.StringOps;
import com.veromodo.tioa.util.error;
import com.veromodo.tioa.util.location;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class checkAutomaton
extends Check {
    protected static symTable syms = symTable.get();
    protected automatonDefNode ad;
    protected basicAutomatonNode basicBody;
    protected transitionNode currentTrans = null;
    protected HashSet<variableNode> modifiedVars = null;
    protected sortNode lastChoiceSort = null;

    protected checkAutomaton(automatonDefNode ad) {
        this.ad = ad;
    }

    public static boolean def(automatonDefNode ad) {
        if (ad.status() != Node.status.UNCHECKED) {
            return true;
        }
        boolean ok = true;
        int i = 0;
        while (i < ad.nImports()) {
            ok &= checkVocab.checkVocabRef(ad.imports(i));
            ++i;
        }
        checkAutomaton check = new checkAutomaton(ad);
        ad.setStatus(Node.status.CHECKING_SYMBOLS);
        if (!(ok &= check.checkAutomatonFormals())) {
            return ad.setFinalStatus(false);
        }
        ok = ad.isComposite() ? (ok &= checkComposition.now(ad)) : (ok &= checkBasicAutomaton.now(ad));
        if (ok &= !check.errors()) {
            ad.makeAbstract();
        }
        return ad.setFinalStatus(ok);
    }

    public boolean checkAutomatonFormals() {
        sortNode autSortNode = new sortNode(this.ad.name(), this.ad.scope()).restrict();
        if (!syms.declare(autSortNode) || builtIns.getVocab(this.ad.name().toString(), 0) != null) {
            error.msg(this.ad.name(), "automaton " + this.ad.name() + " cannot have the same name as a type");
        }
        int nTypeParams = 0;
        int i = 0;
        while (i < this.ad.nFormals()) {
            if (this.ad.formal(i).kind() == formal.kind.TYPE) {
                ++nTypeParams;
            }
            ++i;
        }
        sortNode[] subsorts = new sortNode[nTypeParams + 1];
        subsorts[0] = autSortNode;
        int j = 1;
        int i2 = 0;
        while (i2 < this.ad.nFormals()) {
            formalNode f = this.ad.formal(i2);
            if (f.kind() == formal.kind.TYPE) {
                if (builtIns.isSort(f.type().id().toString())) {
                    error.msg(f.type(), "can't use predefined type " + f.type() + " as a formal parameter");
                    f.setStatus(Node.status.BAD);
                    f.type().setStatus(Node.status.BAD);
                } else {
                    syms.declare(f.type());
                    f.setStatus(Node.status.OK);
                    f.type().setStatus(Node.status.OK);
                }
                sortNode sn = new sortNode(f.type().id());
                subsorts[j++] = sn;
                syms.declare(sn);
            }
            ++i2;
        }
        sortNode statesSort = new sortNode(new ltoken("_States", new location("CONSTRUCTED", 0, 0, 0, 0), this.ad.scope()), subsorts);
        syms.declare(statesSort.constructor());
        syms.declare(statesSort);
        variableNode statesVar = new variableNode(this.ad.name(), statesSort);
        variableNode primedStatesVar = new variableNode(String.valueOf(this.ad.name().toString()) + "'", statesSort, this.ad.scope());
        checkAutomaton.checkVar(3, statesVar, null, true);
        checkAutomaton.checkVar(4, primedStatesVar, null, true);
        this.ad.statesVar(statesVar);
        this.ad.primedStatesVar(primedStatesVar);
        sortNode[] vec = new sortNode[]{autSortNode};
        sortNode paramSort = new sortNode(new ltoken("_Param", new location("CONSTRUCTED", 0, 0, 0, 0), this.ad.scope()), vec);
        syms.declare(paramSort.constructor());
        syms.declare(paramSort);
        variableNode paramVar = new variableNode(this.ad.name(), paramSort);
        checkAutomaton.checkVar(20, paramVar, null, true);
        this.ad.paramVar(paramVar);
        int i3 = 0;
        while (i3 < this.ad.nFormals()) {
            formalNode f = this.ad.formal(i3);
            switch (f.kind()) {
                case TYPE: 
                case TYPECON: {
                    break;
                }
                case VAR: {
                    if (f.kind() == formal.kind.VAR && checkSort.now(f.sort()) == null) break;
                    operatorNode op = new operatorNode(new nameNode(9, f.var().id()), new signatureNode(paramSort, f.var().sort()));
                    syms.declare(op);
                    checkAutomaton.checkVar(1, f.var(), op.makeAbstract(), true);
                    f.setStatus(Node.status.OK);
                    f.var().setStatus(Node.status.OK);
                    break;
                }
                default: {
                    throw new InternalError("checkAutomaton.checkAutomatonFormals");
                }
            }
            ++i3;
        }
        if (this.ad.where() != null) {
            checkTerm.boolSort(this.ad.where());
        }
        return this.ad.setFinalStatus(!this.errors());
    }

    protected static automatonDefNode findAutomaton(ltoken name) {
        automatonDefNode aNode = specs.getAutomaton(name.toString());
        if (aNode == null) {
            error.msg(name, "couldn't find definition for automaton " + name);
            return null;
        }
        if (aNode.status() == Node.status.UNCHECKED) {
            checkAutomaton.def(aNode);
        }
        switch (aNode.status()) {
            case OK: {
                return aNode;
            }
            case MISSING: {
                error.msg(name, "couldn't find definition for automaton " + name);
                aNode.setBadStatus();
                return null;
            }
            case UNPARSABLE: {
                error.msg(name, "couldn't parse definition for " + name);
                aNode.setBadStatus();
                return null;
            }
            case BAD: {
                error.msg(name, "reference to automaton " + name + " with errors");
                return null;
            }
            case CHECKING_SYMBOLS: {
                error.msg(name, "reference to automaton within its own definition");
                return null;
            }
        }
        throw new InternalError("checkAutomaton.findAutomaton");
    }

    protected boolean makeStateTuple(automatonDefNode ad, variableNode[] stateVars, variableNode[] primedStateVars) {
        boolean ok = true;
        Vector<fieldNode> stateFields = new Vector<fieldNode>(stateVars.length);
        int i = 0;
        while (i < stateVars.length) {
            fieldNode fn = new fieldNode(stateVars[i].id(), stateVars[i].sort());
            fn.setScope(stateVars[i].scope());
            stateFields.addElement(fn);
            ++i;
        }
        shorthandNode sNode = new shorthandNode(stateFields);
        ok &= checkShorthand.now(ad.statesVar().sort(), sNode, false);
        int i2 = 0;
        while (i2 < stateVars.length) {
            operator op = ((sortTuple)sNode.makeAbstract()).get(i2);
            ok &= checkAutomaton.checkVar(5, stateVars[i2], op, true);
            ok &= checkAutomaton.checkVar(6, primedStateVars[i2], op, true);
            ++i2;
        }
        return ok;
    }

    protected static boolean makeLocalTuple(automatonDefNode ad, transitionNode tn) {
        boolean ok = true;
        Vector<fieldNode> localFields = new Vector<fieldNode>(tn.nLocals());
        int i = 0;
        while (i < tn.nLocals()) {
            fieldNode fn = new fieldNode(tn.local(i).id(), tn.local(i).sort());
            fn.setScope(tn.local(i).scope());
            localFields.addElement(fn);
            ++i;
        }
        sortNode sNode = tn.localsVar().sort();
        shorthandNode shNode = new shorthandNode(localFields);
        ok &= checkShorthand.now(sNode, shNode, false);
        int i2 = 0;
        while (i2 < tn.nLocals()) {
            operator op = ((sortTuple)shNode.makeAbstract()).get(i2);
            ok &= checkAutomaton.checkVar(10, tn.local(i2), op, true);
            ok &= checkAutomaton.checkVar(11, tn.primedLocal(i2), op, true);
            ++i2;
        }
        return ok;
    }

    protected static boolean checkVar(int k, variableNode vn, operator op, boolean declare) {
        variableNode dec = syms.find(vn);
        if (dec == null) {
            vn.setKind(k);
            if (declare) {
                if (k == 5 || k == 6 || k == 10 || k == 11 || k == 1) {
                    syms.declareVarWithOp(vn, op);
                } else if (op == null) {
                    syms.declare(vn);
                } else {
                    throw new InternalError("checkAutomaton.checkVar");
                }
            }
            return true;
        }
        if (dec.kind() == k) {
            error.msg(vn.id(), "duplicate " + variable.kindAsString(dec.kind()) + ": " + vn.id());
        } else {
            error.msg(vn.id(), vn.id() + " already used as " + StringOps.addArticle(variable.kindAsString(dec.kind())));
        }
        vn.setBadStatus();
        return false;
    }

    protected boolean checkAssignment(assignmentNode assig, BitSet kinds2) {
        variableNode v;
        boolean ok = true;
        termNode lhs = assig.lhs();
        ok = assig.rhs().isTerm() ? (ok &= (ok &= checkTerm.assignable(lhs, assig.rhs().term())) ? checkTerm.theseKinds(assig.rhs().term(), kinds2) : false) : (ok &= this.checkChoose(assig.lhs(), assig.rhs().choose(), kinds2, kinds2));
        if (lhs.status() != Node.status.OK) {
            return false;
        }
        if (!(ok &= (v = (ok &= ok ? checkTerm.theseKinds(lhs, kinds2) : false) ? this.checkLValue(lhs, assig.isInSchedule()) : null) != null)) {
            assig.setBadStatus();
        }
        return ok;
    }

    protected boolean checkChoose(termNode lhs, chooseNode cn, BitSet lhsKinds, BitSet rhsKinds) {
        boolean ok = true;
        rhsKinds.set(12);
        variableNode vn = cn.var();
        detChoiceNode dcn = cn.ndr();
        if (this.lastChoiceSort != null) {
            error.msg(cn, "choose statements may not be nested");
            cn.setBadStatus();
            return false;
        }
        if (vn == null) {
            ok &= checkTerm.someSort(lhs);
            if (this.currentTrans != null) {
                this.currentTrans.choicesAllNamed = false;
            }
            if (lhs.sort() == null) {
                error.msg(cn, "ambiguous type for choice");
                cn.setBadStatus();
                return false;
            }
        } else {
            if (vn.sort() == null) {
                ok &= checkTerm.someSort(lhs);
                if (lhs.sort() == null) {
                    error.msg(cn, "ambiguous type for choice");
                    cn.setBadStatus();
                    return false;
                }
                vn = new variableNode(vn.id(), new sortNode(lhs.sort(), vn.scope()));
                cn.setVar(vn);
            } else {
                ok &= checkTerm.thisSort(lhs, vn.sort());
            }
            if (checkSort.now(vn.sort()) == null) {
                cn.setBadStatus();
                return false;
            }
            ok &= ok ? checkTerm.theseKinds(lhs, lhsKinds) : false;
            checkAutomaton.checkVar(12, vn, null, true);
            if (this.currentTrans != null) {
                if (this.currentTrans.chooseVars.containsKey(vn.id())) {
                    this.currentTrans.chooseVarsUnique = false;
                } else {
                    this.currentTrans.chooseVars.put(vn.id(), vn);
                }
            }
            if (cn.where() != null) {
                ok &= (ok &= checkTerm.boolSort(cn.where())) ? checkTerm.theseKinds(cn.where(), rhsKinds) : false;
            }
        }
        if (dcn != null) {
            this.lastChoiceSort = vn != null ? vn.sort() : new sortNode(lhs.sort(), lhs.scope());
            ok = dcn.yield() != null ? (ok &= this.checkDetYield(dcn.yield(), rhsKinds)) : (ok &= this.checkProgram(dcn.program(), rhsKinds));
        }
        this.lastChoiceSort = null;
        if (!ok) {
            cn.setBadStatus();
        }
        return ok;
    }

    protected variableNode checkLValue(termNode tn, boolean inSchedule) {
        switch (tn.kind()) {
            case 2: {
                nameNode name = tn.id();
                sort s = tn.makeAbstract().sort();
                variableNode vn = null;
                boolean valid = false;
                Enumeration<variableNode> vars = syms.matchingVars(name.string(), name.scope());
                while (!valid && vars.hasMoreElements()) {
                    vn = vars.nextElement();
                    if ((!name.string().equals(vn.id().toString()) || !tn.makeAbstract().sort().equals(vn.sort().makeAbstract()) || !inSchedule || vn.kind() != 17) && (inSchedule || vn.kind() != 8 && vn.kind() != 3 && vn.kind() != 10 && vn.kind() != 5)) continue;
                    valid = true;
                }
                if (!valid) {
                    String msg = "cannot assign to ";
                    if (vn == null) {
                        msg = String.valueOf(msg) + "constant ";
                    }
                    msg = String.valueOf(msg) + tn.id() + " ";
                    if (inSchedule) {
                        msg = String.valueOf(msg) + "in schedule block";
                    }
                    error.msg(tn.id(), msg);
                    tn.setBadStatus();
                }
                return vn;
            }
            case 0: {
                operator op = tn.makeAbstract().op();
                termNode head = tn.arg(0);
                sort headSort = head.makeAbstract().sort();
                if (op.opKind() == 9 || op.opKind() == 4 && headSort.nSubsorts() != 0 && (headSort.constructor().id().equals("Array") || headSort.constructor().id().equals("Map"))) {
                    return this.checkLValue(head, inSchedule);
                }
                error.msg(tn.id(), "illegal lvalue");
                tn.setBadStatus();
                return null;
            }
            case 1: {
                error.msg(tn, "cannot assign to a quantified term");
                tn.setBadStatus();
                return null;
            }
        }
        throw new InternalError("checkBasicAutomaton.checkLValue");
    }

    protected boolean checkDetYield(detYieldNode y, BitSet kinds2) {
        boolean ok = true;
        if (!(ok &= (ok &= checkTerm.thisSort(y.term(), this.lastChoiceSort)) ? checkTerm.theseKinds(y.term(), kinds2) : false)) {
            y.setBadStatus();
        }
        return ok;
    }

    protected boolean checkProgram(programNode program2, BitSet kinds2) {
        boolean ok = true;
        int i = 0;
        while (i < program2.nStatements()) {
            statementNode stmt = program2.statement(i);
            switch (stmt.kind()) {
                case 1: {
                    ok &= this.checkAssignment(stmt.assign(), kinds2);
                    break;
                }
                case 2: {
                    ok &= this.checkLoop(stmt.loop(), kinds2);
                    break;
                }
                case 3: {
                    ok &= this.checkConditional(stmt.cond(), kinds2);
                    break;
                }
                case 6: {
                    ok &= this.checkDetFire(stmt.fire());
                    break;
                }
                case 8: {
                    ok &= this.checkDetFollow(stmt.follow());
                    break;
                }
                case 5: {
                    ok &= this.checkDetWhile(stmt.dwhile(), kinds2);
                    break;
                }
                case 4: {
                    ok &= this.checkDetYield(stmt.yield(), kinds2);
                    break;
                }
                case 7: {
                    ok &= this.checkSimFire(stmt.simfire(), kinds2);
                    break;
                }
                case 9: {
                    ok &= this.checkSimFollow(stmt.simfollow(), kinds2);
                    break;
                }
                default: {
                    throw new InternalError("checkBasicAutomaton.checkProgram");
                }
            }
            ++i;
        }
        if (!ok) {
            program2.setBadStatus();
        }
        return ok;
    }

    protected boolean checkLoop(loopNode loop2, BitSet kinds2) {
        boolean ok = true;
        kinds2.set(13);
        if (checkSort.now(loop2.var().sort()) == null) {
            ok = false;
        }
        loop2.var().setKind(13);
        syms.declareBoundVar(loop2.var());
        if (loop2.inSet()) {
            sortNode[] vSort = new sortNode[]{loop2.var().sort()};
            sortNode setSort = new sortNode("Set", vSort, loop2.var().scope());
            ok &= checkTerm.thisSort(loop2.term(), setSort);
        } else {
            ok &= (ok &= checkTerm.boolSort(loop2.term())) ? checkTerm.theseKinds(loop2.term(), kinds2) : false;
        }
        if (!(ok &= this.checkProgram(loop2.program(), kinds2))) {
            loop2.setBadStatus();
        }
        return ok;
    }

    protected boolean checkConditional(conditionalNode cond, BitSet kinds2) {
        boolean ok = true;
        int i = 0;
        while (i < cond.nIfs()) {
            ok &= (ok &= checkTerm.boolSort(cond.predicate(i))) ? checkTerm.theseKinds(cond.predicate(i), kinds2) : false;
            ok &= this.checkProgram(cond.thenClause(i), kinds2);
            ++i;
        }
        if (!(ok &= this.checkProgram(cond.elseClause(), kinds2))) {
            cond.setBadStatus();
        }
        return ok;
    }

    protected boolean checkDetWhile(detWhileNode w, BitSet kinds2) {
        boolean ok = true;
        ok &= (ok &= checkTerm.boolSort(w.pred())) ? checkTerm.theseKinds(w.pred(), kinds2) : false;
        if (!(ok &= this.checkProgram(w.program(), kinds2))) {
            w.setBadStatus();
        }
        return ok;
    }

    protected boolean checkDetFire(detFireNode f) {
        boolean ok = true;
        if (f.name() == null) {
            return true;
        }
        int actionIndex = this.findAction(f.name(), f.kind(), this.basicBody.nActions());
        if (actionIndex < 0) {
            error.msg(f.name(), String.valueOf(action.kind2String(f.kind())) + " action " + f.name() + " not in automaton's signature");
            return false;
        }
        actionNode aNode = this.basicBody.action(actionIndex);
        transitionNode tNode = this.getTransitionForCase(f.name(), aNode, f.caseName());
        if (tNode != null) {
            ok &= this.checkInvocation(tNode, f);
            f.setTransition(tNode);
        }
        if (!ok) {
            f.setBadStatus();
        }
        return ok;
    }

    protected boolean checkDetFollow(detFollowNode f) {
        boolean ok = false;
        int i = 0;
        while (!ok && i < this.basicBody.nTrajectories()) {
            if (this.basicBody.trajectory(i).name().equals(f.name())) {
                f.setTrajectory(this.basicBody.trajectory(i));
                ok = true;
            }
            ++i;
        }
        if (!ok) {
            error.msg(f.name(), "undefined trajectory " + f.name());
        }
        sortNode[] goodSorts = new sortNode[]{predefined.augmentedRealSort, predefined.realSort};
        return ok &= checkTerm.someSort(f.howLong(), goodSorts);
    }

    protected boolean checkSchedule() {
        boolean ok = true;
        detScheduleNode schedule2 = this.basicBody.schedule();
        if (schedule2 == null) {
            return true;
        }
        if (schedule2.states() != null) {
            ok &= checkAutomaton.checkNDRStates(schedule2.states(), this.ad);
        }
        if (schedule2.program() != null && schedule2.program().nStatements() != 0) {
            ok &= this.checkProgram(schedule2.program(), variable.scheduleKinds());
        }
        if (!ok) {
            schedule2.setBadStatus();
        }
        return ok;
    }

    protected boolean checkSimFire(simFireNode f, BitSet kinds2) {
        boolean ok = true;
        actionNode act = checkAutomaton.findAction(this.basicBody, f.name(), f.kind());
        if (act == null) {
            error.msg(f.name(), String.valueOf(action.kind2String(f.kind())) + " action " + f.name() + " not in automaton's signature");
            f.setBadStatus();
            return false;
        }
        transitionNode tNode = this.getTransitionForCase(f.name(), act, f.caseName());
        if (tNode != null) {
            ok &= this.checkInvocation(tNode, f);
            f.setTransition(tNode);
        }
        int i = 0;
        while (i < f.nSubs()) {
            simSubNode sub = f.sub(i);
            variableNode var = sub.specVar();
            termNode term2 = sub.proofval();
            variableNode foundVar = f.matchVar(sub);
            if (foundVar == null) {
                error.msg(var, "local variable " + var.id() + " not found in " + "specification transition " + f.getTransName());
                f.setBadStatus();
                return false;
            }
            kinds2.set(18);
            ok &= (ok &= checkTerm.thisSort(term2, foundVar.sort())) ? checkTerm.theseKinds(term2, kinds2) : false;
            ++i;
        }
        if (!ok) {
            f.setBadStatus();
        }
        return ok;
    }

    protected int findAction(ltoken name, action.kinds k, int n) {
        int i = 0;
        while (i < n) {
            actionNode aNode = this.basicBody.action(i);
            if (name.equals(aNode.name()) && (k == aNode.kind() || k == null)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected transitionNode getTransitionForCase(ltoken name, actionNode act, ltoken caseName) {
        transitionNode theTransition = null;
        if (caseName == null) {
            if (act.nTransitions() != 1) {
                error.msg(name, "more than one transition matches case label");
                return null;
            }
            theTransition = act.getTransitions().nextElement();
        } else {
            Enumeration<transitionNode> e = act.getTransitions();
            while (e.hasMoreElements()) {
                transitionNode t = e.nextElement();
                if (t.caseName() == null || !t.caseName().equals(caseName)) continue;
                if (theTransition != null) {
                    error.msg(name, "more than one transition matches");
                    return null;
                }
                theTransition = t;
            }
        }
        return theTransition;
    }

    protected boolean checkInvocation(transitionNode tNode, invocationNode actuals) {
        boolean ok = true;
        int nActuals = tNode.nActuals();
        int nParams = tNode.nParams();
        if (actuals.nActuals() != nParams) {
            String msg = "too " + (actuals.nActuals() < nParams ? "few" : "many") + " actual parameters for " + tNode.name();
            if (nParams > nActuals && nActuals == actuals.nActuals()) {
                msg = String.valueOf(msg) + ".  Need to specify local variables too";
            }
            error.msg(actuals.name(), msg);
            ok = false;
        }
        int i = 0;
        while (i < actuals.nActuals()) {
            if (i >= nParams) break;
            sortNode sn = i < nActuals ? tNode.theAction().formal(i).sort() : tNode.local(i - nActuals).sort();
            if (sn == null) {
                throw new InternalError("Sort not yet set for node " + tNode);
            }
            ok &= (ok &= checkTerm.thisSort(actuals.actual(i), sn)) ? checkTerm.theseKinds(actuals.actual(i), variable.invocationKinds()) : false;
            ++i;
        }
        if (!ok) {
            actuals.setBadStatus();
        }
        return ok;
    }

    protected boolean checkSimFollow(simFollowNode f, BitSet kinds2) {
        boolean ok;
        trajectoryNode traj = checkBasicAutomaton.findTrajectory(this.basicBody, f.getName());
        boolean bl = ok = traj != null;
        if (!ok) {
            error.msg(f.getName(), "trajectory " + f.getName() + " not defined");
        } else {
            f.setTrajectory(traj);
        }
        sortNode[] goodSorts = new sortNode[]{predefined.augmentedRealSort, predefined.realSort, predefined.augmentedRealSortD, predefined.realSortD};
        return f.setFinalStatus(ok &= checkTerm.someSort(f.duration(), goodSorts));
    }

    protected static boolean checkNDRStates(statesNode sn, Node ad) {
        variableNode var;
        BitSet kinds2 = new BitSet();
        int nVars = sn.nVars();
        if (sn == null || nVars == 0) {
            return true;
        }
        if (ad instanceof automatonDefNode) {
            sn.setAutomatonSort(((automatonDefNode)ad).statesVar().sort());
        }
        boolean ok = true;
        boolean varsOK = true;
        int i = 0;
        while (i < nVars) {
            var = sn.var(i);
            valueNode value2 = sn.value(i);
            if (checkSort.now(var.sort()) == null) {
                var.setBadStatus();
                sn.setBadStatus();
                varsOK = false;
            } else if (value2 != null) {
                if (value2.isTerm()) {
                    ok &= (ok &= checkTerm.thisSort(value2.term(), var.sort())) ? checkTerm.theseKinds(value2.term(), variable.ndrStatesKinds()) : false;
                } else {
                    error.msg(value2, "choose value not allowed in an NDR context");
                }
            }
            ++i;
        }
        i = 0;
        while (i < nVars) {
            var = sn.var(i);
            if (var.status() != Node.status.BAD) {
                ok &= checkAutomaton.checkVar(17, var, null, true);
            }
            ++i;
        }
        if (sn.initially() != null) {
            ok &= (ok &= checkTerm.boolSort(sn.initially())) ? checkTerm.theseKinds(sn.initially(), variable.ndrStatesKinds()) : false;
        }
        if (sn.status() == Node.status.BAD) {
            ad.setBadStatus();
        } else {
            sn.setStatus(ok ? Node.status.OK : Node.status.OK);
        }
        return ok && varsOK;
    }

    protected static actionNode findAction(basicAutomatonNode basicBody, ltoken name, action.kinds k) {
        int i = 0;
        while (i < basicBody.nActions()) {
            actionNode aNode = basicBody.action(i);
            if (name.equals(aNode.name()) && (k == aNode.kind() || k == null)) {
                return aNode;
            }
            ++i;
        }
        return null;
    }

    protected static trajectoryNode findTrajectory(basicAutomatonNode basicBody, ltoken name) {
        int i = 0;
        while (i < basicBody.nTrajectories()) {
            trajectoryNode n = basicBody.trajectory(i);
            if (name.equals(n.name())) {
                return n;
            }
            ++i;
        }
        return null;
    }
}

