/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.checker;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.checker.Check;
import com.veromodo.tioa.checker.checkAutomaton;
import com.veromodo.tioa.checker.checkBasicAutomaton;
import com.veromodo.tioa.checker.checkTerm;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.renaming;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.actionNode;
import com.veromodo.tioa.parser.assertionNode;
import com.veromodo.tioa.parser.assignmentNode;
import com.veromodo.tioa.parser.automatonDefNode;
import com.veromodo.tioa.parser.basicAutomatonNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.invariantNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.simCorrespNode;
import com.veromodo.tioa.parser.simProofNode;
import com.veromodo.tioa.parser.simulationNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.trajectoryNode;
import com.veromodo.tioa.parser.transitionNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.util.error;
import java.util.Enumeration;

public class checkAssertion
extends Check {
    public static void now(assertionNode n) {
        if (n.status() != Node.status.UNCHECKED) {
            return;
        }
        switch (n.kind()) {
            case 1: {
                checkAssertion.invariantCheck(n.invar());
                return;
            }
            case 2: {
                checkAssertion.simulationCheck(n.simul());
                return;
            }
        }
        throw new InternalError("checkAssertion.now");
    }

    private static void invariantCheck(invariantNode inv) {
        automatonDefNode aNode = checkAutomaton.findAutomaton(inv.name());
        if (aNode == null) {
            inv.setBadStatus();
            return;
        }
        renaming r = renaming.theIdentity();
        Scope s = aNode.isComposite() ? aNode.compositionBody().scope() : aNode.basicBody().states().scope();
        symTable.get().extend(inv.scope(), s, r);
        symTable.get().redeclareVars(inv.scope(), s);
        int i = 0;
        while (i < inv.nPredicates()) {
            checkTerm.boolSort(inv.predicate(i));
            ++i;
        }
    }

    private static void simulationCheck(simulationNode sim) {
        automatonDefNode implAD = checkAutomaton.findAutomaton(sim.from());
        automatonDefNode specAD = checkAutomaton.findAutomaton(sim.to());
        if (implAD == null || specAD == null) {
            sim.setBadStatus();
            return;
        }
        renaming r = renaming.theIdentity();
        Scope implScope = implAD.isComposite() ? implAD.compositionBody().scope() : implAD.basicBody().states().scope();
        Scope specScope = specAD.isComposite() ? specAD.compositionBody().scope() : specAD.basicBody().states().scope();
        symTable.get().extend(sim.scope(), implScope, r);
        symTable.get().extend(sim.scope(), specScope, r);
        variableNode implParam = new variableNode(implAD.paramVar().id().toString(), implAD.paramVar().sort(), sim.scope());
        variableNode specParam = new variableNode(specAD.paramVar().id().toString(), specAD.paramVar().sort(), sim.scope());
        variableNode implState = new variableNode(implAD.statesVar().id().toString(), implAD.statesVar().sort(), sim.scope());
        variableNode specState = new variableNode(specAD.statesVar().id().toString(), specAD.statesVar().sort(), sim.scope());
        variableNode implStatePrime = new variableNode(implAD.primedStatesVar().id().toString(), implAD.primedStatesVar().sort(), sim.scope());
        variableNode specStatePrime = new variableNode(specAD.primedStatesVar().id().toString(), specAD.primedStatesVar().sort(), sim.scope());
        checkAutomaton.checkVar(20, implParam, null, true);
        checkAutomaton.checkVar(20, specParam, null, true);
        checkAutomaton.checkVar(3, implState, null, true);
        checkAutomaton.checkVar(3, specState, null, true);
        checkAutomaton.checkVar(4, implStatePrime, null, true);
        checkAutomaton.checkVar(4, specStatePrime, null, true);
        int i = 0;
        while (i < sim.nPredicates()) {
            checkTerm.boolSort(sim.predicate(i));
            ++i;
        }
        if (sim.proof() != null) {
            checkAssertion.checkProof(sim, implAD, specAD, implState, specState);
        }
    }

    private static boolean checkProof(simulationNode sim, automatonDefNode implAD, automatonDefNode specAD, variableNode implState, variableNode specState) {
        boolean ok = true;
        if (implAD.isComposite() || specAD.isComposite()) {
            error.msg(sim.proof(), "simulation proofs are available only for simulations between primitive automata");
            sim.setBadStatus();
            return false;
        }
        if (!sim.forward()) {
            error.msg(sim.proof(), "simulation proofs are available only for forward simulations");
            sim.setBadStatus();
            return false;
        }
        basicAutomatonNode specAut = implAD.basicBody();
        int i = 0;
        while (i < specAut.nTransitions()) {
            transitionNode t = specAut.transition(i);
            if (!t.chooseVarsUnique) {
                error.msg(t, "simulation proofs are available only when all transitions have unique choose variable names");
                sim.setBadStatus();
                return false;
            }
            if (!t.choicesAllNamed) {
                error.msg(t, "simulation proof are available only when all choices to explicitly name a variable");
                sim.setBadStatus();
                return false;
            }
            ++i;
        }
        if (sim.proof().states() != null) {
            ok &= checkBasicAutomaton.checkNDRStates(sim.proof().states(), sim);
        }
        ok &= checkAssertion.checkProofStart(sim.proof(), specAD, specState);
        if (!(ok &= checkAssertion.checkProofEntries(sim.proof(), implAD, specAD))) {
            sim.setBadStatus();
        }
        return ok;
    }

    private static boolean checkProofStart(simProofNode proof, automatonDefNode specAD, variableNode specState) {
        boolean ok = true;
        checkBasicAutomaton checkSpec = new checkBasicAutomaton(specAD);
        int i = 0;
        while (i < proof.nStarts()) {
            variableNode lvalue;
            assignmentNode start = proof.getStart(i);
            if (!start.rhs().isTerm()) {
                error.msg(start.rhs(), "choose not allowed in a simulation proof");
                ok = false;
            } else if ((ok &= (ok &= (ok &= checkTerm.assignable(start.lhs(), start.rhs().term())) ? checkTerm.theseKinds(start.lhs(), variable.proofKinds()) : false) ? checkTerm.theseKinds(start.rhs().term(), variable.proofKinds()) : false) && !specState.equals(lvalue = checkSpec.checkLValue(start.lhs(), false))) {
                String msg = "expecting the aggregate state variable of specification automaton " + specAD.name();
                msg = lvalue == null ? String.valueOf(msg) + ", not " + start.lhs().id() : String.valueOf(msg) + ", not " + lvalue.id();
                error.msg(start.lhs(), msg);
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            proof.setBadStatus();
        }
        return ok;
    }

    private static boolean checkProofEntries(simProofNode proof, automatonDefNode implAD, automatonDefNode specAD) {
        boolean ok = true;
        basicAutomatonNode implAut = implAD.basicBody();
        int i = 0;
        while (i < proof.nEntries()) {
            simCorrespNode entry = proof.entry(i);
            ok = entry.duration() == null ? (ok &= checkAssertion.checkTransEntry(entry, implAut, specAD)) : (ok &= checkAssertion.checkTrajEntry(entry, implAut, specAD));
            ++i;
        }
        return ok;
    }

    private static boolean checkTrajEntry(simCorrespNode entry, basicAutomatonNode implAut, automatonDefNode specAD) {
        boolean ok = true;
        trajectoryNode traj = checkBasicAutomaton.findTrajectory(implAut, entry.name);
        if (traj == null) {
            error.msg(entry.name, "trajectory " + entry.name + " not defined in implementation automaton");
            ok = false;
        }
        ok &= checkAutomaton.checkVar(18, entry.duration(), null, true);
        checkBasicAutomaton specChecker = new checkBasicAutomaton(specAD);
        if (!(ok &= specChecker.checkProgram(entry.program(), variable.proofKinds()))) {
            entry.setBadStatus();
        }
        entry.setTrajectory(traj);
        return ok;
    }

    private static boolean checkTransEntry(simCorrespNode entry, basicAutomatonNode implAut, automatonDefNode specAD) {
        transitionNode tNode;
        boolean ok = true;
        actionNode act = checkBasicAutomaton.findAction(implAut, entry.name, entry.kind());
        if (act == null) {
            error.msg(entry.name, String.valueOf(action.kind2String(entry.kind())) + " action " + entry.name + " not in implementation automaton's signature");
            entry.setBadStatus();
            return false;
        }
        if (act.nTransitions() == 0) {
            throw new InternalError("checkAssertion.checkProofEntries:" + act.name());
        }
        if (entry.caseName != null) {
            Enumeration<transitionNode> e = act.getTransitions();
            while (e.hasMoreElements()) {
                transitionNode t = e.nextElement();
                if (t.caseName() == null || !entry.caseName.equals(t.caseName())) continue;
                entry.setTransition(t);
                break;
            }
            if (!entry.hasTransition()) {
                error.msg(entry, "proof entry does not match a transition in specification automaton");
                entry.setBadStatus();
                return false;
            }
        } else if (act.nTransitions() == 1) {
            entry.setTransition(act.getTransition());
        } else {
            error.msg(entry, "proof entry matches multiple transitions in specification automaton");
            entry.setBadStatus();
            return false;
        }
        if ((tNode = entry.getTransition()).nParams() > 0) {
            if (entry.nFormals() == 0) {
                error.msg(entry.name, String.valueOf(action.kind2String(entry.kind())) + " action " + entry.name + " requires parameters");
                entry.setBadStatus();
                return false;
            }
            ok &= checkAssertion.checkCorrespFormals(entry);
            ok &= checkAssertion.checkMatchingFormals(tNode, entry);
        } else if (entry.nFormals() > 0) {
            error.msg(entry, String.valueOf(action.kind2String(entry.kind())) + " action " + entry.name + " case " + entry.caseName + " does not take formal parameters");
            entry.setBadStatus();
            return false;
        }
        checkBasicAutomaton specChecker = new checkBasicAutomaton(specAD);
        if (!(ok &= specChecker.checkProgram(entry.program(), variable.proofKinds()))) {
            entry.setBadStatus();
        }
        return ok;
    }

    private static boolean checkCorrespFormals(simCorrespNode entry) {
        formalNode fn;
        boolean ok = true;
        int i = 0;
        while (i < entry.nFormals()) {
            fn = entry.formal(i);
            if (fn.kind() == formal.kind.VAR) {
                ok &= checkBasicAutomaton.checkFormalVariable(fn, 18);
            }
            ++i;
        }
        i = 0;
        while (i < entry.nFormals()) {
            fn = entry.formal(i);
            if (fn.kind() == formal.kind.CONST) {
                ok &= checkBasicAutomaton.checkFormalConst(fn, variable.correspKinds());
            }
            ++i;
        }
        if (!ok) {
            entry.setBadStatus();
        }
        return ok;
    }

    private static boolean checkMatchingFormals(transitionNode tNode, simCorrespNode entry) {
        String theCase;
        boolean ok = true;
        actionNode act = tNode.theAction();
        int nActuals = tNode.nActuals();
        ltoken name = entry.name;
        String string = theCase = entry.caseName == null ? "" : " case " + entry.caseName;
        if (tNode.nParams() > entry.nFormals()) {
            if (tNode.nActuals() > entry.nFormals()) {
                error.msg(name, "too few actual parameters for " + name + theCase);
            } else {
                error.msg(name, "too few actual parameters for " + name + theCase + ".  Need to specify local variables too.");
            }
            entry.setBadStatus();
            return false;
        }
        if (tNode.nParams() < entry.nFormals()) {
            error.msg(name, "too many actual parameters for " + name + theCase);
            entry.setBadStatus();
            return false;
        }
        int i = 0;
        while (i < act.nFormals()) {
            formalNode f1 = act.formal(i);
            formalNode f2 = entry.formal(i);
            if (f1.kind() != f2.kind()) {
                error.msg(f2, "type in formal parameter for " + name + " does not match kind of its original definition");
                entry.setBadStatus();
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < entry.nFormals()) {
            sortNode sn = i < nActuals ? act.formal(i).sort() : tNode.local(i - nActuals).sort();
            formalNode f1 = entry.formal(i);
            if (sn == null) {
                throw new InternalError("Null sortNode found");
            }
            if (!sn.equals(f1.sort())) {
                error.msg(f1, "type " + sn + " of formal parameter for " + name + " does not match type " + f1.sort() + " of original definition");
                entry.setBadStatus();
                return false;
            }
            ++i;
        }
        if (!ok) {
            entry.setBadStatus();
        }
        return ok;
    }
}

