/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.assignment;
import com.veromodo.tioa.automaton.conditional;
import com.veromodo.tioa.automaton.loop;
import com.veromodo.tioa.automaton.ndrfire;
import com.veromodo.tioa.automaton.ndrwhile;
import com.veromodo.tioa.automaton.ndryield;
import com.veromodo.tioa.automaton.opMap;
import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.proofsub;
import com.veromodo.tioa.automaton.simfire;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.automaton.value;
import com.veromodo.tioa.automaton.yieldprogram;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.substitution;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.factoring;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class varMap
extends substitution {
    private static varMap identityVarMap;
    private HashSet<String> avoidVars = new HashSet();

    public static varMap identityVarMap() {
        if (identityVarMap == null) {
            identityVarMap = new varMap();
        }
        return identityVarMap;
    }

    public HashSet<String> avoidVars() {
        return this.avoidVars;
    }

    public void avoid(variable v) {
        this.avoidVars.add(v.toString().intern());
    }

    public void avoid(HashSet<variable> v) {
        Iterator<variable> i = v.iterator();
        while (i.hasNext()) {
            this.avoid(i.next());
        }
    }

    public void ignore(variable v) {
        this.avoidVars.remove(v.toString().intern());
    }

    public boolean clashes(variable v) {
        return this.avoidVars.contains(v.toString().intern());
    }

    public boolean clashes(String s) {
        return this.avoidVars.contains(s.intern());
    }

    public varMap() {
        this(1);
    }

    public varMap(int size) {
        super(size);
    }

    public varMap(variable v, term t) {
        this(1);
        if (v != null && t != null) {
            this.add(v, t);
        }
    }

    public varMap(variable[] v, term[] t, HashSet<String> a) {
        this(v.length);
        if (v.length != t.length || a == null) {
            throw new InternalError("varMap");
        }
        int i = 0;
        while (i < v.length) {
            if (v[i] != null && t[i] != null) {
                this.add(v[i], t[i]);
            }
            ++i;
        }
        this.avoidVars = a;
    }

    public varMap(term[] dom, term[] rng) {
        this(dom.length);
        if (dom.length != rng.length) {
            throw new InternalError("varMap");
        }
        int i = 0;
        while (i < dom.length) {
            if (dom[i] != null && rng[i] != null) {
                this.add(dom[i], rng[i]);
            }
            ++i;
        }
    }

    public varMap(term[] dom, term[] rng, HashSet<String> a) {
        this(dom.length);
        if (dom.length != rng.length) {
            throw new InternalError("varMap");
        }
        int i = 0;
        while (i < dom.length) {
            if (dom[i] != null && rng[i] != null) {
                this.add(dom[i], rng[i]);
            }
            ++i;
        }
        this.avoidVars = a;
    }

    public formal map(formal f) {
        switch (f.kind()) {
            case CONST: {
                return new formal(this.map(f.constant()));
            }
            case TYPE: {
                return f;
            }
            case VAR: {
                return new formal(this.map(f.var()));
            }
        }
        throw new InternalError("varMap.map(formal)");
    }

    public formal[] map(formal[] f) {
        formal[] e = new formal[f.length];
        int i = 0;
        while (i < f.length) {
            e[i] = this.map(f[i]);
            ++i;
        }
        return e;
    }

    public proofsub map(proofsub p) {
        term t;
        variable v = p.var();
        term vImage = this.delete(v);
        variable vNew = null;
        Iterator<variable> i = p.value().freeVars().iterator();
        while (i.hasNext() && vNew == null) {
            if (!this.map(i.next()).occursFreely(v)) continue;
            vNew = this.changeVar(v);
        }
        term term2 = t = p.value() == null ? null : this.map(p.value());
        if (vNew != null) {
            this.delete(v);
        }
        if (vImage != null) {
            this.add(v, vImage);
        }
        return new proofsub(v, this.map(t));
    }

    public proofsub[] map(proofsub[] p) {
        proofsub[] q = new proofsub[p.length];
        int i = 0;
        while (i < p.length) {
            q[i] = this.map(p[i]);
            ++i;
        }
        return q;
    }

    public value map(value v) {
        yieldprogram ndr;
        if (v.isTerm()) {
            return new value(this.map(v.term()));
        }
        variable cv = v.chooseVar();
        if (cv == null) {
            return new value();
        }
        term cvImage = this.delete(cv);
        variable cvNew = null;
        HashSet<variable> freeVars = new HashSet<variable>();
        if (v.where() != null) {
            freeVars.addAll(v.where().freeVars());
        }
        if (v.ndr() != null) {
            freeVars.addAll(v.ndr().freeVars());
        }
        Iterator i = freeVars.iterator();
        while (i.hasNext() && cvNew == null) {
            variable fv = (variable)i.next();
            if (fv.equals(cv) || !this.map(fv).occursFreely(cv)) continue;
            cvNew = this.changeVar(cv);
        }
        term where = v.where() == null ? null : this.map(v.where());
        yieldprogram yieldprogram2 = ndr = v.ndr() == null ? null : this.map(v.ndr());
        if (cvNew != null) {
            this.delete(cv);
        } else {
            cvNew = cv;
        }
        if (cvImage != null) {
            this.add(cv, cvImage);
        }
        if (where == null && ndr == null) {
            return new value(cvNew);
        }
        if (where == null) {
            return new value(cvNew, ndr);
        }
        if (ndr == null) {
            return new value(cvNew, where);
        }
        return new value(cvNew, where, ndr);
    }

    public assignment map(assignment a) {
        return new assignment(this.map(a.lhs()), this.map(a.rhs()));
    }

    public loop map(loop l) {
        variable v = l.var();
        term vImage = this.delete(v);
        variable vNew = null;
        HashSet<variable> freeVars = l.term().freeVars();
        freeVars.addAll(l.program().freeVars());
        Iterator<variable> i = freeVars.iterator();
        while (i.hasNext() && vNew == null) {
            variable fv = i.next();
            if (fv.equals(v) || !this.map(fv).occursFreely(v)) continue;
            vNew = this.changeVar(v);
        }
        term t = this.map(l.term());
        program p = this.map(l.program());
        if (vNew != null) {
            this.delete(v);
        } else {
            vNew = v;
        }
        if (vImage != null) {
            this.add(v, vImage);
        }
        return new loop(vNew, t, p);
    }

    public conditional map(conditional c) {
        Object result = null;
        term[] tests = new term[c.nIfs()];
        program[] thenClauses = new program[c.nIfs()];
        int i = 0;
        while (i < thenClauses.length) {
            tests[i] = this.map(c.predicate(i));
            thenClauses[i] = this.map(c.thenClause(i));
            ++i;
        }
        return new conditional(tests, thenClauses, c.elseClause() == null ? null : this.map(c.elseClause()));
    }

    public ndryield map(ndryield y) {
        return new ndryield(this.map(y.yield()));
    }

    public ndrwhile map(ndrwhile w) {
        return new ndrwhile(this.map(w.predicate()), this.map(w.whileClause()));
    }

    public ndrfire map(ndrfire f) {
        return new ndrfire(f.theTransition(), this.map(f.actuals));
    }

    public simfire map(simfire s) {
        return new simfire(s.theTransition(), this.map(s.actuals), this.map(s.subs));
    }

    public statement map(statement s) {
        statement result = null;
        switch (s.kind()) {
            case 1: {
                result = this.map((assignment)s);
                break;
            }
            case 2: {
                result = this.map((loop)s);
                break;
            }
            case 3: {
                result = this.map((conditional)s);
                break;
            }
            case 4: {
                result = this.map((ndryield)s);
                break;
            }
            case 5: {
                result = this.map((ndrwhile)s);
                break;
            }
            case 6: {
                result = this.map((ndrfire)s);
                break;
            }
            case 7: {
                result = this.map((simfire)s);
                break;
            }
            default: {
                throw new InternalError("map(statement)");
            }
        }
        return result;
    }

    public program map(program p) {
        if (p == null) {
            return p;
        }
        statement[] s = new statement[p.nStatements()];
        int i = 0;
        while (i < s.length) {
            s[i] = this.map(p.statement(i));
            ++i;
        }
        return new program(s);
    }

    public yieldprogram map(yieldprogram y) {
        if (y == null) {
            return y;
        }
        statement[] s = new statement[y.nStatements()];
        int i = 0;
        while (i < s.length) {
            s[i] = this.map(y.statement(i));
            ++i;
        }
        return new yieldprogram(s);
    }

    public transition map(transition t) {
        int i;
        int i2 = 0;
        while (i2 < t.nActuals()) {
            this.avoid(this.map(t.actual(i2)).freeVars());
            ++i2;
        }
        this.avoid(t.localsVar());
        this.avoid(t.primedLocalsVar());
        term[] localImages = new term[t.nLocals()];
        boolean clash = false;
        String[] localFields = new String[t.nLocals()];
        sort[] localSorts = new sort[t.nLocals()];
        HashSet<String> avoidReps = new HashSet<String>();
        int i3 = 0;
        while (i3 < t.nLocals()) {
            if (this.clashes(t.local(i3))) {
                localImages[i3] = this.delete(t.local(i3));
                clash = true;
                localFields[i3] = t.local(i3).makeFreshExternalID(avoidReps);
            } else {
                localFields[i3] = t.local(i3).id();
            }
            localSorts[i3] = t.local(i3).sort();
            avoidReps.add(variable.externalRep(localFields[i3], localSorts[i3]));
            ++i3;
        }
        opMap m = new opMap();
        variable[] locals = (variable[])t.locals.clone();
        variable[] primedLocals = (variable[])t.primedLocals.clone();
        if (clash) {
            sortTuple localsSortTuple = new sortTuple(t.localsVar().sort(), localFields, localSorts);
            i = 0;
            while (i < t.nLocals()) {
                operator selector = localsSortTuple.get(i);
                String info2 = "op" + selector.uid();
                locals[i] = new variable(localFields[i], localSorts[i], 10, info2);
                primedLocals[i] = new variable(String.valueOf(localFields[i]) + "'", localSorts[i], 11, info2);
                m.add(t.localsSortTuple().get(i), localsSortTuple.get(i).id());
                m.add(t.localsSortTuple().set(i), localsSortTuple.set(i).id());
                ++i;
            }
        }
        m.freeze();
        term[] actuals = new term[t.nActuals()];
        i = 0;
        while (i < t.nActuals()) {
            actuals[i] = m.map(this.map(t.actual(i)));
            ++i;
        }
        term where = m.map(this.map(t.where()));
        term[] pre = new term[t.nPreconditions()];
        int i4 = 0;
        while (i4 < t.nPreconditions()) {
            pre[i4] = m.map(this.map(t.pre(i4)));
            ++i4;
        }
        program eff = m.map(this.map(t.effects()));
        term ensuring = m.map(this.map(t.ensuring()));
        factoring factors = new factoring();
        int i5 = 0;
        while (i5 < t.nLocals()) {
            this.ignore(locals[i5]);
            if (locals[i5] != t.local(i5)) {
                this.delete(t.local(i5));
            }
            if (localImages[i5] != null) {
                this.add(t.local(i5), localImages[i5]);
            }
            ++i5;
        }
        transition result = new transition(t.theAction(), actuals, t.localsVar(), t.primedLocalsVar(), locals, primedLocals, factors, where, t.caseName(), null, pre, null, eff, ensuring);
        return result;
    }

    @Override
    public substitution copy() {
        return new varMap(this.dom, this.rng, this.avoidVars);
    }

    public varMap compose(varMap s) {
        throw new InternalError("Not implemented.");
    }
}

