/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.yieldprogram;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class value
extends Unit {
    private boolean isTerm;
    private term term;
    private variable chooseVar;
    private term where;
    private yieldprogram ndr;

    public boolean isTerm() {
        return this.isTerm;
    }

    public boolean hasNothingToPrint() {
        return !this.isTerm() && this.chooseVar() == null;
    }

    public sort sort() {
        return this.isTerm ? this.term.sort() : (this.chooseVar == null ? null : this.chooseVar.sort());
    }

    public term term() {
        if (!this.isTerm) {
            throw new InternalError("value.term");
        }
        return this.term;
    }

    public variable chooseVar() {
        if (this.isTerm) {
            throw new InternalError("value.chooseVar");
        }
        return this.chooseVar;
    }

    public term where() {
        if (this.isTerm) {
            throw new InternalError("value.where");
        }
        return this.where;
    }

    public yieldprogram ndr() {
        if (this.isTerm) {
            throw new InternalError("value.ndr");
        }
        return this.ndr;
    }

    public value(term t) {
        this.isTerm = true;
        this.term = t;
    }

    public value() {
    }

    public value(variable v) {
        this.isTerm = false;
        this.chooseVar = v;
    }

    public value(variable v, yieldprogram p) {
        this.isTerm = false;
        this.chooseVar = v;
        this.ndr = p;
    }

    public value(variable v, term t) {
        if (!t.sort().equals(sort.boolSort)) {
            throw new InternalError("value constructor");
        }
        this.isTerm = false;
        if (v == null) {
            throw new InternalError("value constructor: null choose var");
        }
        this.chooseVar = v;
        this.where = t;
    }

    public value(variable v, term t, yieldprogram p) {
        if (!t.sort().equals(sort.boolSort)) {
            throw new InternalError("value constructor");
        }
        this.isTerm = false;
        this.chooseVar = v;
        this.where = t;
        this.ndr = p;
    }

    public HashSet<variable> freeVars() {
        if (this.isTerm) {
            return this.term.freeVars();
        }
        HashSet<variable> freeVars = new HashSet<variable>();
        if (this.chooseVar != null) {
            if (this.where != null) {
                freeVars = this.where.freeVars();
            }
            if (this.ndr != null) {
                freeVars.addAll(this.ndr.freeVars());
            }
            freeVars.remove(this.chooseVar.intern());
        }
        return freeVars;
    }

    public boolean occurs(term t) {
        if (this.isTerm) {
            return this.term.isSubterm(t);
        }
        if (this.chooseVar != null) {
            if (this.where != null && this.where.isSubterm(t)) {
                return true;
            }
            if (this.ndr != null) {
                return this.ndr.occurs(t);
            }
        }
        return false;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        if (this.isTerm()) {
            return this.term.print(pp);
        }
        if (this.chooseVar() == null) {
            return pp.put("choose");
        }
        pp.fill().put("choose").blank().print(this.chooseVar());
        pp.fill().blank().put("where").blank().print(this.where).end();
        if (this.ndr != null) {
            pp.eol().fill("det".length() + 1).put("det").blank();
            pp.put("do").blank().eol();
            pp.blist(this.ndr.statements, ";").end().eol().put("od");
        }
        return pp.end();
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        if (this.isTerm()) {
            return this.term.toSValue();
        }
        SList list = SExp.makeSList(SExp.makeSValue("choose"));
        SList list1 = new SList();
        if (this.chooseVar() != null) {
            list1.add(this.chooseVar.toSValue());
            if (this.where != null) {
                list1.add(this.where.toSValue());
            }
        }
        list.add(list1);
        if (this.ndr != null) {
            list.add(this.ndr.toSValue());
        }
        return list;
    }
}

