/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.component;
import com.veromodo.tioa.automaton.conditional;
import com.veromodo.tioa.automaton.loop;
import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.reduce;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.automaton.transitionTriple;
import com.veromodo.tioa.automaton.varMap;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import java.util.Enumeration;
import java.util.Vector;

class transitionTable {
    private String name;
    private String compositionName;
    private formal[] formals;
    private component[] components;
    private action[] actions;
    private varMap paramMap;
    private Vector<transitionTriple> triples;
    private term[] actuals;
    private variable localsVar;
    private variable primedLocalsVar;
    private variable[] locals;
    private variable[] primedLocals;
    private term[] wheres = new term[3];
    private term[][] pres;
    private program[] effects = new program[3];
    private term[] ensurings = new term[3];
    private transition[] transitions;
    private boolean frozen;

    public transition transition4Kind(action.kinds kind2) {
        if (!this.frozen || this.transitions[kind2.ordinal()] == null) {
            throw new InternalError("transitionTable:kind");
        }
        return this.transitions[kind2.ordinal()];
    }

    public transitionTable(String name, String compositionName, formal[] formals, component[] components) {
        this.name = name;
        this.compositionName = compositionName;
        this.formals = formals;
        this.components = components;
        this.actions = new action[action.kinds.values().length];
        this.transitions = new transition[action.kinds.values().length];
        this.frozen = false;
        this.actuals = null;
        this.paramMap = null;
        this.triples = new Vector();
        this.localsVar = null;
        this.primedLocalsVar = null;
        this.locals = null;
        this.primedLocals = null;
        this.pres = new term[action.kinds.values().length][];
    }

    private transitionTriple find(component c) {
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple triple = e.nextElement();
            if (!triple.name().equals(c.name())) continue;
            return triple;
        }
        return null;
    }

    private transitionTriple find(action.kinds kind2) {
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple triple = e.nextElement();
            if (!triple.hasKind(kind2)) continue;
            return triple;
        }
        return null;
    }

    public void addTransition(transition t, component c) {
        if (this.frozen || t == null || c == null) {
            throw new InternalError("transitionTable.addTransition");
        }
        transitionTriple triple = this.find(c);
        if (triple == null) {
            triple = new transitionTriple(c);
            this.triples.addElement(triple);
        }
        triple.addTransition(t);
    }

    public void addAction(action a) {
        if (this.frozen || a == null || this.actions[a.kind().ordinal()] != null) {
            throw new InternalError("transitionTable.addAction");
        }
        this.actions[a.kind().ordinal()] = a;
    }

    private void composeTransitions(action.kinds kind2, Context x) {
        switch (kind2) {
            case INPUT: {
                this.composeInputs();
                break;
            }
            case OUTPUT: {
                this.composeOutputs();
                break;
            }
            case INTERNAL: {
                this.composeInternals();
                break;
            }
            default: {
                throw new InternalError("transitionTable:composeTransitions(kind)");
            }
        }
        int k = kind2.ordinal();
        term term2 = this.wheres[k] = this.wheres[k] == null ? null : simplify.iterate(this.wheres[k], x);
        if (this.pres[k].length != 0) {
            this.pres[k][0] = simplify.iterate(this.pres[k][0], x);
        }
        this.effects[k] = this.effects[k] == null ? null : reduce.iterate(this.effects[k], x);
        this.ensurings[k] = this.ensurings[k] == null ? null : simplify.iterate(this.ensurings[k], x);
    }

    private void composeInputs() {
        this.wheres[action.kinds.INPUT.ordinal()] = this.composeInputWheres();
        this.pres[action.kinds.INPUT.ordinal()] = new term[0];
        this.effects[action.kinds.INPUT.ordinal()] = this.composeInputEffects();
        this.ensurings[action.kinds.INPUT.ordinal()] = this.composeInputEnsurings();
    }

    private term composeInputWheres() {
        term where = booleans.trueTerm;
        if (this.locals.length == 0) {
            return where;
        }
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.INPUT)) continue;
            transition tr = trt.transitionKind(action.kinds.INPUT);
            action a = tr.theAction();
            component c = trt.component();
            term t = booleans.imply(booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where())), tr.where());
            varMap m = new varMap();
            variable[] qVars = new variable[c.nFormals()];
            int i = 0;
            while (i < qVars.length) {
                qVars[i] = new variable(c.formal(i).id(), c.formal(i).sort(), 15);
                m.add(c.formal(i), qVars[i]);
                ++i;
            }
            t = m.map(t);
            i = 0;
            while (i < qVars.length) {
                t = new term(new quantifier(quantifier.ALL, qVars[i]), t);
                ++i;
            }
            where = booleans.conjoin(where, t);
        }
        return where;
    }

    private program composeInputEffects() {
        Vector<statement> stmtVector = new Vector<statement>();
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transition tr;
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.INPUT) || trt.transitionKind(action.kinds.INPUT).effects() == null || (tr = trt.transitionKind(action.kinds.INPUT)).effects() == null) continue;
            statement stmt = this.contributeInputEffect(tr, trt.component());
            stmtVector.addElement(stmt);
        }
        if (stmtVector.size() == 0) {
            return null;
        }
        Object[] statements = new statement[stmtVector.size()];
        stmtVector.copyInto(statements);
        return new program((statement[])statements);
    }

    private statement contributeInputEffect(transition t, component c) {
        action a = t.theAction();
        term w = booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where()));
        program prog = this.paramMap.map(t.effects());
        if (c.nFormals() == 0) {
            term[] ifs = new term[]{w};
            program[] thens = new program[]{prog};
            return new conditional(ifs, thens, new program(new statement[0]));
        }
        varMap m = new varMap();
        variable[] qVars = new variable[c.nFormals()];
        variable[] lVars = new variable[c.nFormals()];
        int i = 0;
        while (i < qVars.length) {
            variable f = c.formal(i);
            qVars[i] = new variable(f.id(), f.sort(), 15);
            lVars[i] = new variable(f.id(), f.sort(), 13);
            m.add(this.paramMap.map(f), new term(lVars[i]));
            ++i;
        }
        loop l = null;
        w = m.map(w);
        prog = m.map(prog);
        varMap m1 = new varMap();
        int i2 = lVars.length - 1;
        while (i2 >= 0) {
            if (i2 + 1 < qVars.length) {
                m1.add(lVars[i2 + 1], qVars[i2 + 1]);
            }
            term w1 = m1.map(w);
            int j = i2 + 1;
            while (j < qVars.length) {
                w1 = new term(new quantifier(quantifier.EXISTS, qVars[j]), w1);
                ++j;
            }
            statement[] s = new statement[]{l};
            prog = l == null ? prog : new program(s);
            l = new loop(lVars[i2], w1, prog);
            --i2;
        }
        return l;
    }

    private term composeInputEnsurings() {
        term ensuring = booleans.trueTerm;
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.INPUT)) continue;
            transition tr = trt.transitionKind(action.kinds.INPUT);
            action a = tr.theAction();
            component c = trt.component();
            term t = booleans.imply(booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where())), tr.ensuring());
            varMap m = new varMap();
            variable[] qVars = new variable[c.nFormals()];
            int i = 0;
            while (i < qVars.length) {
                qVars[i] = new variable(c.formal(i).id(), c.formal(i).sort(), 15);
                m.add(c.formal(i), qVars[i]);
                ++i;
            }
            t = m.map(t);
            i = 0;
            while (i < qVars.length) {
                t = new term(new quantifier(quantifier.ALL, qVars[i]), t);
                ++i;
            }
            ensuring = booleans.conjoin(ensuring, t);
        }
        return ensuring;
    }

    private void composeOutputs() {
        this.wheres[action.kinds.OUTPUT.ordinal()] = this.composeOutputWheres();
        this.pres[action.kinds.OUTPUT.ordinal()] = this.composeOutputPres();
        this.effects[action.kinds.OUTPUT.ordinal()] = this.paramMap.map(this.composeOutputEffects());
        this.ensurings[action.kinds.OUTPUT.ordinal()] = this.paramMap.map(this.composeOutputEnsurings());
    }

    private term composeOutputWheres() {
        if (this.locals.length == 0) {
            return null;
        }
        boolean noWheres = true;
        term where = booleans.falseTerm;
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.OUTPUT)) continue;
            transition tr = trt.transitionKind(action.kinds.OUTPUT);
            action a = tr.theAction();
            term t = booleans.conjoin(this.paramMap.map(trt.component().where()), this.paramMap.map(a.where()));
            where = booleans.disjoin(where, booleans.conjoin(t, tr.where()));
            noWheres = false;
        }
        if (noWheres) {
            where = booleans.trueTerm;
        }
        return booleans.conjoin(where, this.wheres[action.kinds.INPUT.ordinal()]);
    }

    private term[] composeOutputPres() {
        boolean noPres = true;
        term[] pre = new term[]{booleans.falseTerm};
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.OUTPUT)) continue;
            transition tr = trt.transitionKind(action.kinds.OUTPUT);
            action a = tr.theAction();
            component c = trt.component();
            term t = booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where()));
            t = booleans.conjoin(t, this.paramMap.map(tr.preAsTerm()));
            pre[0] = booleans.disjoin(pre[0], t);
            noPres = false;
        }
        if (noPres || pre[0].equals(booleans.trueTerm)) {
            pre = new term[]{};
        }
        return pre;
    }

    private program composeOutputEffects() {
        statement[] s;
        Vector<term> testVector = new Vector<term>();
        Vector<program> thenVector = new Vector<program>();
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transition tr;
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.OUTPUT) || (tr = trt.transitionKind(action.kinds.OUTPUT)).effects() == null) continue;
            action a = tr.theAction();
            component c = trt.component();
            testVector.addElement(booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where())));
            thenVector.addElement(this.paramMap.map(tr.effects()));
        }
        if (testVector.size() == 0) {
            return this.effects[action.kinds.INPUT.ordinal()];
        }
        Object[] tests = new term[testVector.size()];
        Object[] thenClauses = new program[thenVector.size()];
        program emptyProg = new program(new statement[0]);
        testVector.copyInto(tests);
        thenVector.copyInto(thenClauses);
        conditional c = new conditional((term[])tests, (program[])thenClauses, emptyProg);
        if (this.effects[action.kinds.INPUT.ordinal()] != null) {
            program inP = this.effects[action.kinds.INPUT.ordinal()];
            s = new statement[inP.nStatements() + 1];
            System.arraycopy(inP.statements, 0, s, 0, inP.nStatements());
        } else {
            s = new statement[1];
        }
        s[s.length - 1] = c;
        return new program(s);
    }

    private term composeOutputEnsurings() {
        term ensuring = booleans.trueTerm;
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.OUTPUT)) continue;
            transition tr = trt.transitionKind(action.kinds.OUTPUT);
            action a = tr.theAction();
            component c = trt.component();
            term t = booleans.imply(booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where())), tr.ensuring());
            ensuring = booleans.conjoin(ensuring, t);
        }
        term inEnsuring = this.ensurings[action.kinds.INPUT.ordinal()] != null ? this.ensurings[action.kinds.INPUT.ordinal()] : booleans.trueTerm;
        return booleans.conjoin(ensuring, inEnsuring);
    }

    private void composeInternals() {
        this.wheres[action.kinds.INTERNAL.ordinal()] = this.composeInternalWheres();
        this.pres[action.kinds.INTERNAL.ordinal()] = this.composeInternalPres();
        this.effects[action.kinds.INTERNAL.ordinal()] = this.composeInternalEffects();
        this.ensurings[action.kinds.INTERNAL.ordinal()] = this.composeInternalEnsurings();
    }

    private term composeInternalWheres() {
        if (this.locals.length == 0) {
            return null;
        }
        boolean noWheres = true;
        term where = booleans.falseTerm;
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            term t;
            component c;
            action a;
            transition tr;
            transitionTriple trt = e.nextElement();
            if (trt.hasKind(action.kinds.OUTPUT)) {
                tr = trt.transitionKind(action.kinds.OUTPUT);
                a = tr.theAction();
                c = trt.component();
                t = booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where()));
                where = booleans.disjoin(where, booleans.conjoin(t, tr.where()));
                noWheres = false;
            }
            if (!trt.hasKind(action.kinds.INTERNAL)) continue;
            tr = trt.transitionKind(action.kinds.INTERNAL);
            a = tr.theAction();
            c = trt.component();
            t = booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where()));
            where = booleans.disjoin(where, booleans.conjoin(t, tr.where()));
            noWheres = false;
        }
        if (noWheres) {
            where = booleans.trueTerm;
        }
        return booleans.conjoin(where, this.wheres[action.kinds.INPUT.ordinal()]);
    }

    private term[] composeInternalPres() {
        boolean noPres = true;
        term[] pre = new term[]{booleans.falseTerm};
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.INTERNAL)) continue;
            transition tr = trt.transitionKind(action.kinds.INTERNAL);
            action a = tr.theAction();
            component c = trt.component();
            term t = booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where()));
            t = booleans.conjoin(t, this.paramMap.map(tr.preAsTerm()));
            pre[0] = booleans.disjoin(pre[0], t);
            noPres = false;
        }
        term outputPre = booleans.trueTerm;
        if (this.pres[action.kinds.OUTPUT.ordinal()].length != 0) {
            outputPre = this.pres[action.kinds.OUTPUT.ordinal()][0];
            noPres = false;
        }
        pre[0] = booleans.disjoin(pre[0], outputPre);
        if (noPres || pre[0].equals(booleans.trueTerm)) {
            pre = new term[]{};
        }
        return pre;
    }

    private program composeInternalEffects() {
        statement[] s;
        Vector<term> testVector = new Vector<term>();
        Vector<program> thenVector = new Vector<program>();
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transition tr;
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.INTERNAL) || (tr = trt.transitionKind(action.kinds.INTERNAL)).effects() == null) continue;
            action a = tr.theAction();
            component c = trt.component();
            testVector.addElement(booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where())));
            thenVector.addElement(this.paramMap.map(tr.effects()));
        }
        if (testVector.size() == 0) {
            return this.effects[action.kinds.OUTPUT.ordinal()];
        }
        Object[] tests = new term[testVector.size()];
        Object[] thenClauses = new program[thenVector.size()];
        program emptyProg = new program(new statement[0]);
        testVector.copyInto(tests);
        thenVector.copyInto(thenClauses);
        conditional c = new conditional((term[])tests, (program[])thenClauses, emptyProg);
        if (this.effects[action.kinds.OUTPUT.ordinal()] != null) {
            program outP = this.effects[action.kinds.OUTPUT.ordinal()];
            s = new statement[outP.nStatements() + 1];
            System.arraycopy(outP.statements, 0, s, 0, outP.nStatements());
        } else {
            s = new statement[1];
        }
        s[s.length - 1] = c;
        return new program(s);
    }

    private term composeInternalEnsurings() {
        term ensuring = booleans.trueTerm;
        Enumeration<transitionTriple> e = this.triples.elements();
        while (e.hasMoreElements()) {
            transitionTriple trt = e.nextElement();
            if (!trt.hasKind(action.kinds.INTERNAL)) continue;
            transition tr = trt.transitionKind(action.kinds.INTERNAL);
            action a = tr.theAction();
            component c = trt.component();
            term t = booleans.imply(booleans.conjoin(this.paramMap.map(c.where()), this.paramMap.map(a.where())), tr.ensuring());
            ensuring = booleans.conjoin(ensuring, t);
        }
        term outEnsuring = this.ensurings[action.kinds.OUTPUT.ordinal()] != null ? this.ensurings[action.kinds.OUTPUT.ordinal()] : booleans.trueTerm;
        return booleans.conjoin(ensuring, outEnsuring);
    }
}

