/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;

class transitionPattern {
    String name;
    String kind;
    term[] actuals;
    variable[] locals;

    transitionPattern(String name, String kind2, term[] actuals, variable[] locals) {
        if (name == null || kind2 == null || actuals == null || locals == null) {
            throw new InternalError("composer.transitionPattern");
        }
        this.name = name;
        this.kind = kind2;
        this.actuals = actuals;
        this.locals = locals;
    }

    transitionPattern(transition t) {
        this.name = t.theAction().name();
        this.kind = t.theAction().kindAsString();
        this.actuals = new term[t.nActuals()];
        this.locals = new variable[t.nLocals()];
        int i = 0;
        while (i < this.actuals.length) {
            this.actuals[i] = t.actual(i);
            ++i;
        }
        i = 0;
        while (i < this.locals.length) {
            this.locals[i] = t.local(i);
            ++i;
        }
        if (this.name == null) {
            throw new InternalError("composer.transitionPattern");
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof transitionPattern ? this.equals((transitionPattern)obj) : false;
    }

    public boolean equals(transitionPattern t) {
        if (t == null || this.actuals.length != t.actuals.length || this.locals.length != t.locals.length) {
            return false;
        }
        int i = 0;
        while (i < this.actuals.length) {
            if (!this.actuals[i].equals(t.actuals[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.locals.length) {
            if (!this.locals[i].equals(t.locals[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(transition t) {
        return this.equals(new transitionPattern(t));
    }
}

