/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.assignment;
import com.veromodo.tioa.automaton.conditional;
import com.veromodo.tioa.automaton.loop;
import com.veromodo.tioa.automaton.ndrwhile;
import com.veromodo.tioa.automaton.opMap;
import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.varMap;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class transitionLocals {
    variable localsVar;
    variable primedLocalsVar;
    variable[] locals;
    variable[] primedLocals;
    varMap sigma;
    opMap omega;

    transitionLocals(variable localsVar, variable primedLocalsVar, variable[] locals, variable[] primedLocals, sortTuple localsSortTuple, term where, term[] pre, program effects, term ensuring, Context x) {
        this.localsVar = localsVar;
        this.primedLocalsVar = primedLocalsVar;
        this.locals = (variable[])locals.clone();
        this.primedLocals = (variable[])primedLocals.clone();
        this.sigma = new varMap();
        this.omega = new opMap();
        this.reduceLocals(localsSortTuple, where, pre, effects, ensuring, x);
    }

    void reduceLocals(sortTuple localsSortTuple, term where, term[] pre, program effects, term ensuring, Context x) {
        int nReduced = this.reduceEquated(localsSortTuple, where, effects, x);
        int nLocals = this.locals.length - (nReduced += this.reduceUnused(localsSortTuple, where, pre, effects, ensuring));
        if (nLocals == 0) {
            this.locals = new variable[0];
            this.primedLocals = new variable[0];
            this.omega.freeze();
            return;
        }
        if (nReduced == 0) {
            this.omega.freeze();
            return;
        }
        String[] fields = new String[nLocals];
        sort[] fieldSorts = new sort[nLocals];
        int[] oldIndex = new int[nLocals];
        int i = 0;
        int j = 0;
        while (i < this.locals.length) {
            if (this.locals[i] != null) {
                fields[j] = this.locals[i].id();
                fieldSorts[j] = this.locals[i].sort();
                oldIndex[j++] = i;
            }
            ++i;
        }
        sortTuple st = new sortTuple(this.localsVar.sort(), fields, fieldSorts);
        this.locals = new variable[nLocals];
        this.primedLocals = new variable[nLocals];
        int i2 = 0;
        while (i2 < nLocals) {
            operator op = st.get(i2);
            String info2 = "op" + op.uid();
            this.locals[i2] = new variable(fields[i2], fieldSorts[i2], 10, info2);
            this.primedLocals[i2] = new variable(String.valueOf(fields[i2]) + "'", fieldSorts[i2], 11, info2);
            this.omega.add(localsSortTuple.get(oldIndex[i2]), st.get(i2).id());
            this.omega.add(localsSortTuple.set(oldIndex[i2]), st.set(i2).id());
            ++i2;
        }
        this.omega.freeze();
    }

    private int reduceUnused(sortTuple localsSortTuple, term where, term[] pre, program effects, term ensuring) {
        if (this.locals.length == 0) {
            return 0;
        }
        int nReduced = 0;
        term[] args = new term[]{new term(this.localsVar)};
        term[] pArgs = new term[]{new term(this.primedLocalsVar)};
        int i = 0;
        while (i < this.locals.length) {
            if (this.locals[i] != null) {
                operator getOp = localsSortTuple.get(i);
                term agTerm = new term(getOp, args);
                term pAgTerm = new term(getOp, pArgs);
                if (!(where.occursFreely(this.locals[i]) || where.isSubterm(agTerm) || ensuring.occursFreely(this.locals[i]) || ensuring.isSubterm(agTerm) || ensuring.isSubterm(pAgTerm) || effects.freeVars().contains(this.locals[i].intern()) || effects.occurs(agTerm))) {
                    boolean found = false;
                    int j = 0;
                    while (j < pre.length && !found) {
                        if (pre[j].occursFreely(this.locals[i]) || pre[j].isSubterm(agTerm)) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.locals[i] = null;
                        ++nReduced;
                    }
                }
            }
            ++i;
        }
        return nReduced;
    }

    int reduceEquated(sortTuple localsSortTuple, term where, program effects, Context x) {
        int nReduced = 0;
        Vector<term> subterms = new Vector<term>();
        transitionLocals.collectArgs(subterms, booleans.andOp, where);
        int i = 0;
        while (i < subterms.size()) {
            opSym opId;
            term subterm = subterms.elementAt(i);
            if (subterm.kind() == 0 && ((opId = subterm.op().id()).equals(opSym.eqSym) || opId.equals(opSym.iffSym))) {
                term def = null;
                int localIndex = 0;
                while (localIndex < this.locals.length) {
                    if (this.locals[localIndex] != null) {
                        if (transitionLocals.isLValue(this.locals[localIndex], effects, x)) break;
                        term lhs = subterm.arg(0);
                        term rhs = subterm.arg(1);
                        if (x.isEquiv(new term(this.locals[localIndex]), lhs)) {
                            def = rhs;
                        } else if (x.isEquiv(new term(this.locals[localIndex]), rhs)) {
                            def = lhs;
                        }
                        if (def != null) break;
                    }
                    ++localIndex;
                }
                if (def != null && !def.occursFreely(this.localsVar)) {
                    boolean skip = false;
                    int k = 0;
                    while (!skip && k < this.locals.length) {
                        skip = this.locals[k] != null && def.occursFreely(this.locals[k]);
                        ++k;
                    }
                    if (!skip) {
                        term[] args = new term[]{new term(this.localsVar)};
                        operator getOp = localsSortTuple.get(localIndex);
                        term t = new term(getOp, args);
                        this.sigma.add(this.locals[localIndex], def);
                        this.sigma.add(t, def);
                        this.locals[localIndex] = null;
                        ++nReduced;
                    }
                }
            }
            ++i;
        }
        return nReduced;
    }

    public static void collectArgs(Vector<term> v, operator op, term t) {
        if (t.kind() == 0 && op.equals(t.op())) {
            int i = 0;
            while (i < t.nArgs()) {
                transitionLocals.collectArgs(v, op, t.arg(i));
                ++i;
            }
        } else {
            v.addElement(t);
        }
    }

    private static boolean isLValue(variable v, program p, Context x) {
        if (p == null || v == null || v.kind() != 5 && v.kind() != 10) {
            return false;
        }
        int i = 0;
        while (i < p.nStatements()) {
            statement s = p.statement(i);
            switch (s.kind()) {
                case 1: {
                    term lhs = simplify.iterate(((assignment)s).lhs(), x);
                    if (!x.isEquiv(lhs, new term(v))) break;
                    return true;
                }
                case 2: {
                    if (!transitionLocals.isLValue(v, ((loop)s).program(), x)) break;
                    return true;
                }
                case 3: {
                    conditional c = (conditional)s;
                    int j = 0;
                    while (j < c.nIfs()) {
                        Context x1 = x.copy();
                        x1.assertTrue(c.predicate(j));
                        int k = 0;
                        while (k < j) {
                            x1.assertFalse(c.predicate(k));
                            ++k;
                        }
                        if (transitionLocals.isLValue(v, c.thenClause(j), x1)) {
                            return true;
                        }
                        ++j;
                    }
                    if (c.elseClause() == null) break;
                    Context x1 = x.copy();
                    int j2 = 0;
                    while (j2 < c.nIfs()) {
                        x1.assertFalse(c.predicate(j2));
                        ++j2;
                    }
                    if (!transitionLocals.isLValue(v, c.elseClause(), x1)) break;
                    return true;
                }
                case 5: {
                    ndrwhile w = (ndrwhile)s;
                    if (!transitionLocals.isLValue(v, w.whileClause(), x)) break;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

