/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.funcDecl;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;

public class trajectory
extends Unit {
    private String name;
    private int trajIndex = nextTrajIndex++;
    private static int nextTrajIndex = 1;
    private term[] invariants;
    private term invariantConjunction = null;
    private term stopWhen;
    private funcDecl[] funcDecls;
    private term[] evolve;

    public String name() {
        return this.name;
    }

    public int index() {
        return this.trajIndex;
    }

    public int nInvariants() {
        return this.invariants.length;
    }

    public term invariant(int n) {
        return this.invariants[n];
    }

    public term stopWhen() {
        return this.stopWhen;
    }

    public int nFuncDecls() {
        return this.funcDecls.length;
    }

    public funcDecl funcDecl(int n) {
        return this.funcDecls[n];
    }

    public int nEvolve() {
        return this.evolve.length;
    }

    public term evolve(int n) {
        return this.evolve[n];
    }

    public trajectory(String name, funcDecl[] funcDecls, term[] invariants, term stopWhen, term[] evolve) {
        this.name = name;
        this.funcDecls = funcDecls;
        this.invariants = invariants;
        this.stopWhen = stopWhen;
        this.evolve = evolve;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.align(0).fill().put("trajdef").blank().put(this.name);
        funcDecl.printDecls(pp, this.funcDecls);
        if (this.nInvariants() > 0) {
            pp.eol().fill().put("invariant").blank();
            pp.list(this.invariants, ";").end();
        }
        if (!this.stopWhen.isTrue()) {
            pp.eol().fill().put("stop").blank().put("when").blank().print(this.stopWhen).end();
        }
        pp.eol().fill().print("evolve");
        return pp.eol().blist(this.evolve, ";").end().end().end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(this.idToSValue());
        list.add(SExp.makeSValue(this.name));
        if (this.funcDecls.length > 0) {
            list.add(funcDecl.vecToSValue(this.funcDecls));
        }
        if (this.invariants.length > 0) {
            if (this.invariantConjunction == null) {
                this.invariantConjunction = booleans.conjoin(this.invariants);
            }
            SList inv_list = SExp.makeSList(SExp.makeSValue("invariant"));
            inv_list.add(this.invariantConjunction.toSValue());
            list.add(inv_list);
        }
        if (this.stopWhen != null) {
            SList stop_list = SExp.makeSList(SExp.makeSValue("stop"), this.stopWhen.toSValue());
            list.add(stop_list);
        }
        SList e_list = SExp.makeSList(SExp.makeSValue("evolve"));
        int k = 0;
        while (k < this.evolve.length) {
            e_list.add(this.evolve[k].toSValue());
            ++k;
        }
        list.add(e_list);
        return list;
    }

    public iprinter printId(iprinter ip) {
        return ip.put("tj" + this.trajIndex);
    }

    public SValue idToSValue() {
        return SExp.makeSValue("tj" + this.trajIndex);
    }
}

