/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.proofsub;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class simfire
extends statement {
    protected proofsub[] subs;
    private transition theTransition;
    protected term[] actuals;

    public transition theTransition() {
        return this.theTransition;
    }

    public int nActuals() {
        return this.actuals.length;
    }

    public term actual(int n) {
        return this.actuals[n];
    }

    public simfire(transition t, term[] acts, proofsub[] subs) {
        super(6);
        this.theTransition = t;
        this.actuals = acts;
        this.subs = subs;
        HashSet<String> externalReps = new HashSet<String>();
        for (variable v : this.freeVars()) {
            String rep = v.toString();
            if (externalReps.contains(rep)) {
                throw new InternalError("Distinct variables " + rep + " in\n " + this + " aka\n " + this.toSValue());
            }
            externalReps.add(rep);
        }
    }

    @Override
    public HashSet<variable> freeVars() {
        HashSet<variable> freeVars = new HashSet<variable>();
        int i = 0;
        while (i < this.actuals.length) {
            freeVars.addAll(this.actuals[i].freeVars());
            ++i;
        }
        i = 0;
        while (i < this.subs.length) {
            freeVars.addAll(this.subs[i].freeVars());
            freeVars.remove(this.subs[i].var().intern());
            ++i;
        }
        return freeVars;
    }

    @Override
    public boolean occurs(term t) {
        int i = 0;
        while (i < this.actuals.length) {
            if (this.actuals[i].isSubterm(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        if (this.nActuals() > 0) {
            pp.blank(0).fill(1).put("(").list(this.actuals, ",").put(")").end();
        }
        return pp;
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        int i;
        SList list = SExp.makeSList(SExp.makeSValue("sim_fire"));
        list.add(this.theTransition.transIdToSValue());
        if (this.nActuals() > 0) {
            SList list1 = SExp.makeSList(SExp.makeSValue("actuals"));
            i = 0;
            while (i < this.actuals.length) {
                list1.add(this.actuals[i].toSValue());
                ++i;
            }
            list.add(list1);
        }
        if (this.subs.length > 0) {
            SList list2 = SExp.makeSList(SExp.makeSValue("using"));
            i = 0;
            while (i < this.subs.length) {
                list2.add(this.subs[i].toSValue());
                ++i;
            }
            list.add(list2);
        }
        return list;
    }
}

