/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.declaration;
import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.stateVariable;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;

public class schedule
extends Unit {
    private program prog;
    private stateVariable[] stateVariables;
    private declaration[] decs;

    public int nStateVariables() {
        return this.stateVariables.length;
    }

    public stateVariable stateVariable(int n) {
        return this.stateVariables[n];
    }

    public schedule(stateVariable[] states, statement[] prog) {
        this(states, prog, null);
    }

    public schedule(stateVariable[] states, statement[] prog, declaration[] decs) {
        this.stateVariables = states;
        this.prog = new program(prog);
        this.decs = decs;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill().put("schedule").eol();
        if (this.stateVariables.length != 0) {
            pp.fill().put("states").eol().blist(this.stateVariables, ",");
            pp.end().eol();
        }
        if (this.decs != null) {
            pp.fill().put("with").eol().blist(this.decs, ",");
            pp.end().eol();
        }
        pp.fill().fill("do".length() + 1).put("do").blank().end().eol();
        pp.blist(this.prog.statements, ";").end().eol().put("od");
        pp.end().eol();
        return pp;
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = new SList();
        if (this.prog != null) {
            list.add(SExp.makeSValue("schedule"));
            SList list1 = SExp.makeSList(SExp.makeSValue("states"));
            if (this.decs != null) {
                SList ilist = new SList();
                ilist.add(SExp.makeSValue("with"));
                int a = 0;
                while (a < this.decs.length) {
                    ilist.add(this.decs[a].toSValue());
                    ++a;
                }
                list.add(ilist);
            }
            int i = 0;
            while (i < this.stateVariables.length) {
                list1.add(this.stateVariables[i].toSValue());
                ++i;
            }
            list.add(list1);
        }
        list.add(this.prog.toSValue());
        return list;
    }
}

