/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.conditional;
import com.veromodo.tioa.automaton.loop;
import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.automaton.transitionLocals;
import com.veromodo.tioa.automaton.varMap;
import com.veromodo.tioa.checker.Options;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.factoring;
import java.util.Vector;

public class reduce {
    public static program iterate(program p, Context x) {
        if (!Options.simplify() || p == null) {
            return p;
        }
        while (true) {
            program previous = p;
            if ((p = reduce.program(p, x)) != previous) continue;
            boolean reduced = false;
            statement[] statements = new statement[p.nStatements()];
            int i = 0;
            while (i < statements.length) {
                statement s = p.statement(i);
                if (s instanceof loop) {
                    loop l = (loop)s;
                    program body = reduce.iterate(l.program(), x);
                    if (body != l.program()) {
                        reduced = true;
                        statements[i] = new loop(l.var(), l.term(), body);
                    }
                } else if (s instanceof conditional) {
                    conditional c = (conditional)s;
                    term[] ifs = new term[c.nIfs()];
                    program[] progs = new program[c.nIfs()];
                    boolean reduced1 = false;
                    int j = 0;
                    while (j < c.nIfs()) {
                        ifs[j] = c.predicate(j);
                        progs[j] = reduce.iterate(c.thenClause(j), x);
                        reduced1 |= progs[j] != c.thenClause(j);
                        ++j;
                    }
                    program elseProg = c.elseClause() == null ? null : reduce.iterate(c.elseClause(), x);
                    if (reduced1 |= elseProg != c.elseClause()) {
                        reduced = true;
                        statements[i] = new conditional(ifs, progs, elseProg);
                    }
                }
                ++i;
            }
            if (!reduced) break;
            p = new program(statements);
        }
        return p;
    }

    private static program program(program p, Context x) {
        if (p == null) {
            return p;
        }
        boolean reduced = false;
        Vector<statement> newStatements = new Vector<statement>(p.nStatements());
        int i = 0;
        while (i < p.nStatements()) {
            statement s = p.statement(i);
            if (s instanceof loop) {
                statement s1 = reduce.loop((loop)s, x);
                reduced |= s1 != s;
                newStatements.addElement(s1);
            } else if (s instanceof conditional) {
                Unit u = reduce.conditional((conditional)s, x);
                if (u instanceof statement) {
                    statement s1 = (statement)u;
                    reduced |= s1 != s;
                    newStatements.addElement(s1);
                } else if (u instanceof program) {
                    program p1 = (program)u;
                    int j = 0;
                    while (j < p1.nStatements()) {
                        newStatements.addElement(p1.statement(j));
                        ++j;
                    }
                    reduced = true;
                }
            } else {
                newStatements.addElement(s);
            }
            ++i;
        }
        if (!reduced) {
            return p;
        }
        return new program(newStatements.toArray(new statement[0]));
    }

    private static statement loop(loop l, Context x) {
        if (l.term().sort().equals(sort.boolSort)) {
            term g = l.term();
            variable v = l.var();
            program p = l.program();
            term gSimp = simplify.iterate(g, x);
            Vector<quantifier> qfrs = new Vector<quantifier>();
            Vector<variable> vars = new Vector<variable>();
            quantifier q = new quantifier(quantifier.EXISTS, v);
            term tOrig = new term(q, gSimp);
            qfrs.addElement(q);
            vars.addElement(v);
            varMap sigma = new varMap();
            term tSimp = simplify.findVarEquals(vars, qfrs, tOrig, gSimp, sigma, true, null, true, x);
            if (tSimp == tOrig) {
                return l;
            }
            if (tSimp.kind() == 1 && tSimp.qfr() == q) {
                throw new InternalError("Can this really happen?");
            }
            term[] tests = new term[]{tSimp};
            program[] thenClauses = new program[]{sigma.map(p)};
            return new conditional(tests, thenClauses, null);
        }
        return l;
    }

    private static Unit conditional(conditional c, Context x) {
        boolean trivial = true;
        boolean reduced = false;
        Vector<term> ifs = new Vector<term>();
        Vector<program> thens = new Vector<program>();
        program trueProg = null;
        Context x1 = x.copy();
        int i = 0;
        while (i < c.nIfs()) {
            term t = simplify.iterate(c.predicate(i), x1);
            reduced |= t != c.predicate(i);
            if (x.isFalse(t)) {
                reduced = true;
            } else {
                if (x.isTrue(t)) {
                    trueProg = c.thenClause(i);
                    reduced = true;
                    break;
                }
                trivial = false;
                ifs.addElement(t);
                thens.addElement(c.thenClause(i));
                x1.assertFalse(t);
            }
            ++i;
        }
        if (trivial) {
            if (trueProg != null) {
                return trueProg;
            }
            return c.elseClause();
        }
        if (!reduced) {
            return c;
        }
        return new conditional(ifs.toArray(new term[ifs.size()]), thens.toArray(new program[ifs.size()]), trueProg != null ? trueProg : c.elseClause());
    }

    public static transition transition(transition t, Context x) {
        if (!Options.simplify() || t == null) {
            return t;
        }
        term where = simplify.iterate(t.where(), x);
        term[] pre = new term[t.nPreconditions()];
        int i = 0;
        while (i < pre.length) {
            pre[i] = t.pre(i);
            ++i;
        }
        term ensuring = t.ensuring();
        program effects = t.effects();
        factoring localFactors = new factoring();
        action a = t.theAction();
        term[] actuals = t.actuals;
        String caseName = t.caseName();
        transitionLocals tLocals = new transitionLocals(t.localsVar(), t.primedLocalsVar(), t.locals, t.primedLocals, t.localsSortTuple(), where, pre, effects, ensuring, x);
        where = simplify.iterate(tLocals.omega.map(tLocals.sigma.map(where)), x);
        int i2 = 0;
        while (i2 < pre.length) {
            pre[i2] = simplify.iterate(tLocals.omega.map(tLocals.sigma.map(pre[i2])), x);
            ++i2;
        }
        effects = reduce.iterate(tLocals.omega.map(tLocals.sigma.map(effects)), x);
        ensuring = simplify.iterate(tLocals.omega.map(tLocals.sigma.map(ensuring)), x);
        return new transition(a, actuals, tLocals.localsVar, tLocals.primedLocalsVar, tLocals.locals, tLocals.primedLocals, localFactors, where, caseName, null, pre, null, effects, ensuring);
    }
}

