/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class program
extends Unit {
    protected statement[] statements;

    public int nStatements() {
        return this.statements.length;
    }

    public statement statement(int n) {
        return this.statements[n];
    }

    public program(statement[] statements) {
        this.statements = statements;
        HashSet<String> externalReps = new HashSet<String>();
        for (variable v : this.freeVars()) {
            String rep = v.toString();
            if (externalReps.contains(rep)) {
                throw new InternalError("Distinct variables " + rep + " in\n " + this + " aka\n " + this.toSValue());
            }
            externalReps.add(rep);
        }
    }

    public HashSet<variable> freeVars() {
        HashSet<variable> freeVars = new HashSet<variable>();
        int i = 0;
        while (i < this.statements.length) {
            freeVars.addAll(this.statements[i].freeVars());
            ++i;
        }
        return freeVars;
    }

    public boolean occurs(term t) {
        int i = 0;
        while (i < this.statements.length) {
            if (this.statements[i].occurs(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        return pp.blist(this.statements, ";");
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SList list = new SList();
        int i = 0;
        while (i < this.statements.length) {
            list.add(this.statements[i].toSValue());
            ++i;
        }
        return list;
    }
}

