/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ndrfire
extends statement {
    private transition theTransition;
    private String compName;
    protected term[] actuals;
    private String caseName;

    public String compName() {
        return this.compName;
    }

    public void setCompName(String cName) {
        this.compName = cName;
    }

    public transition theTransition() {
        return this.theTransition;
    }

    public void setTransition(transition t) {
        this.theTransition = t;
    }

    public int nActuals() {
        return this.actuals.length;
    }

    public term actual(int n) {
        return this.actuals[n];
    }

    public String caseName() {
        return this.caseName;
    }

    public ndrfire(transition t, term[] acts) {
        super(6);
        this.theTransition = t;
        this.actuals = acts;
        if (t == null) {
            throw new InternalError("ndrfire constructed with null transition.");
        }
        HashSet<String> externalReps = new HashSet<String>();
        for (variable v : this.freeVars()) {
            String rep = v.toString();
            if (externalReps.contains(rep)) {
                throw new InternalError("Distinct variables " + rep + " in\n " + this + " aka\n " + this.toSValue());
            }
            externalReps.add(rep);
        }
    }

    public ndrfire() {
        super(6);
        this.actuals = new term[0];
    }

    @Override
    public HashSet<variable> freeVars() {
        HashSet<variable> freeVars = new HashSet<variable>();
        int i = 0;
        while (i < this.actuals.length) {
            freeVars.addAll(this.actuals[i].freeVars());
            ++i;
        }
        return freeVars;
    }

    @Override
    public boolean occurs(term t) {
        int i = 0;
        while (i < this.actuals.length) {
            if (this.actuals[i].isSubterm(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        action act = this.theTransition.theAction();
        pp.align(0).align(2);
        pp.align(0).fill().put("fire").blank().fill().put(action.kind2String(act.kind())).blank().put(act.name());
        if (this.nActuals() > 0) {
            pp.blank(0).fill("(".length()).put("(");
            pp.list(this.actuals, ",");
            pp.put(")").end();
        }
        return pp.end().end().end().end().end();
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("fire"));
        if (this.compName != null) {
            SString sCompName = new SString(this.compName);
            list.add(sCompName);
        }
        if (this.theTransition != null) {
            list.add(this.theTransition.transIdToSValue());
        }
        if (this.nActuals() > 0) {
            SList list1 = SExp.makeSList(SExp.makeSValue("actuals"));
            int i = 0;
            while (i < this.actuals.length) {
                list1.add(this.actuals[i].toSValue());
                ++i;
            }
            list.add(list1);
        }
        return list;
    }
}

