/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;

public class invariant
extends Unit {
    private String automatonName;
    private term[] invariants;
    private term invariantConjunction = null;
    private String invName = "";

    public invariant(String name, term[] invariants, String automatonName) {
        this.invName = name;
        this.invariants = invariants;
        this.automatonName = automatonName;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.align().fill().put("invariant").blank().put("of").blank().put(this.automatonName).put(":").end();
        int i = 0;
        while (i < this.invariants.length - 1) {
            pp.eol().print(this.invariants[i]).put(";");
            ++i;
        }
        return pp.eol().print(this.invariants[this.invariants.length - 1]).end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        if (this.invariantConjunction == null) {
            this.invariantConjunction = booleans.conjoin(this.invariants);
        }
        SList list = SExp.makeSList(SExp.makeSValue("invariant"));
        list.add(SExp.makeSValue(this.invName));
        list.add(SExp.makeSValue(this.automatonName));
        list.add(this.invariantConjunction.toSValue());
        return list;
    }
}

