/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class conditional
extends statement
implements SPrintable {
    private term[] tests;
    private program[] thenClauses;
    private program elseClause;

    public int nIfs() {
        return this.tests.length;
    }

    public term predicate(int n) {
        return this.tests[n];
    }

    public program thenClause(int n) {
        return this.thenClauses[n];
    }

    public program elseClause() {
        return this.elseClause;
    }

    public conditional(term[] tests, program[] thenClauses, program elseClause) {
        super(3);
        this.tests = tests;
        this.thenClauses = thenClauses;
        this.elseClause = elseClause;
        if (tests.length == 0 || tests.length != thenClauses.length) {
            throw new InternalError("conditional.conditional");
        }
        int i = 0;
        while (i < tests.length) {
            if (!tests[i].sort().equals(sort.boolSort)) {
                throw new InternalError("conditional.conditional");
            }
            ++i;
        }
        HashSet<String> externalReps = new HashSet<String>();
        for (variable v : this.freeVars()) {
            String rep = v.toString();
            if (externalReps.contains(rep)) {
                throw new InternalError("Distinct variables " + rep + " in\n " + this + " aka\n " + this.toSValue());
            }
            externalReps.add(rep);
        }
    }

    @Override
    public HashSet<variable> freeVars() {
        HashSet<variable> freeVars = new HashSet<variable>();
        int i = 0;
        while (i < this.tests.length) {
            freeVars.addAll(this.tests[i].freeVars());
            freeVars.addAll(this.thenClauses[i].freeVars());
            ++i;
        }
        if (this.elseClause != null) {
            freeVars.addAll(this.elseClause.freeVars());
        }
        return freeVars;
    }

    @Override
    public boolean occurs(term t) {
        int i = 0;
        while (i < this.tests.length) {
            if (this.tests[i].isSubterm(t) || this.thenClauses[i].occurs(t)) {
                return true;
            }
            ++i;
        }
        return this.elseClause == null ? false : this.elseClause.occurs(t);
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.align(0);
        String key = "if";
        int i = 0;
        while (i < this.tests.length) {
            pp.align(0).align(3);
            pp.fill(key.length() + 1).put(key).put(" ").print(this.tests[i]).blank().put("then").end();
            pp.blank().print(this.thenClauses[i]).end().end().blank();
            key = "elseif";
            ++i;
        }
        if (this.elseClause() != null && this.elseClause().nStatements() > 0) {
            pp.align(0).align(3).put("else").blank().print(this.elseClause).end().end().blank();
        }
        return pp.put("fi").end();
    }

    @Override
    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    @Override
    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue("if"));
        SList list2 = new SList();
        int i = 0;
        while (i < this.tests.length) {
            SList list3 = new SList();
            list3.add(this.tests[i].toSValue());
            list3.add(this.thenClauses[i].toSValue());
            list2.add(list3);
            ++i;
        }
        list.add(list2);
        if (this.elseClause != null) {
            if (this.elseClause.nStatements() > 0) {
                list.add(this.elseClause.toSValue());
            } else {
                list.add(new SList());
            }
        }
        return list;
    }
}

