/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.actionSet;
import com.veromodo.tioa.automaton.actionTable;
import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.automaton.component;
import com.veromodo.tioa.automaton.schedule;
import com.veromodo.tioa.automaton.stateVariable;
import com.veromodo.tioa.automaton.task;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.checker.Options;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.notions.vocabRef;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class composition
extends automaton
implements SPrintable {
    private component[] components;
    private actionSet[] hiddens;

    public int nComponents() {
        return this.components.length;
    }

    public component component(int n) {
        return this.components[n];
    }

    public actionSet hidden(int n) {
        return this.hiddens[n];
    }

    private composition(String name, formal[] formals, factoring formalFactors, term where, vocabRef[] assumptions, action[] actions2, variable statesVar, variable primedStatesVar, stateVariable[] states, variable[] primedStates, term initially, transition[] transitions, actionSet[] hiddens, task[] tasks, schedule sched) {
        super(name, formals, formalFactors, where, assumptions, actions2, new factoring(actions2.length), statesVar, primedStatesVar, states, primedStates, initially, null, null, transitions, null, tasks, sched);
        this.hiddens = hiddens;
    }

    public static composition make(String name, formal[] formals, factoring formalFactors, term where, vocabRef[] imports, component[] components, variable statesVar, variable primedStatesVar, stateVariable[] states, variable[] primedStates, actionSet[] hiddens, schedule schedP) {
        action[] actions2 = new action[]{};
        transition[] transitions = new transition[]{};
        term initially = null;
        task[] tasks = new task[]{};
        schedule sched = schedP;
        composition result = new composition(name, formals, formalFactors, where, imports, actions2, statesVar, primedStatesVar, states, primedStates, initially, transitions, hiddens, tasks, sched);
        result.components = components;
        return result;
    }

    private static stateVariable[] state(component[] components) {
        return new stateVariable[0];
    }

    private static term statePred(component[] components, stateVariable[] states) {
        term p = booleans.trueTerm;
        int i = 0;
        while (i < components.length) {
            p = booleans.conjoin(p, components[i].initially(states[i].variable(), new Context()));
            ++i;
        }
        return p;
    }

    private static Hashtable<String, formal[]> selectCanonicals(formal[] compositeFormals, stateVariable[] states, variable[] primedStates, component[] components) {
        HashSet<formal[]> fSet;
        HashSet<String> compositeVars = new HashSet<String>();
        int i = 0;
        while (i < compositeFormals.length) {
            if (compositeFormals[i].kind() == formal.kind.VAR) {
                compositeVars.add(compositeFormals[i].var().toString().intern());
            }
            ++i;
        }
        i = 0;
        while (i < states.length) {
            compositeVars.add(states[i].variable().toString().intern());
            compositeVars.add(primedStates[i].toString().intern());
            ++i;
        }
        i = 0;
        while (i < components.length) {
            component c = components[i];
            int j = 0;
            while (j < c.nFormals()) {
                compositeVars.add(c.formal(j).toString().intern());
                ++j;
            }
            ++i;
        }
        Hashtable<String, HashSet<formal[]>> formalSetTab = new Hashtable<String, HashSet<formal[]>>();
        int i2 = 0;
        while (i2 < components.length) {
            component c = components[i2];
            automaton aut = c.resortedAutomaton();
            int k = 0;
            while (k < aut.nActions()) {
                action a = aut.action(k);
                fSet = (HashSet<formal[]>)formalSetTab.get(a.name());
                if (fSet == null) {
                    fSet = new HashSet<formal[]>();
                    formalSetTab.put(a.name(), fSet);
                }
                fSet.add(a.formals);
                ++k;
            }
            ++i2;
        }
        Hashtable<String, formal[]> formalTab = new Hashtable<String, formal[]>();
        formal[] f = null;
        Enumeration e = formalSetTab.keys();
        while (e.hasMoreElements()) {
            boolean found = false;
            String aName = (String)e.nextElement();
            fSet = (HashSet)formalSetTab.get(aName);
            Iterator i3 = fSet.iterator();
            while (!found && i3.hasNext()) {
                f = (formal[])i3.next();
                boolean bl = found = !composition.formalsClash(f, compositeVars);
            }
            if (!found) {
                formal[] f1 = new formal[f.length];
                int i4 = 0;
                while (i4 < f.length) {
                    variable v = f[i4].var();
                    if (compositeVars.contains(v.toString().intern())) {
                        v = v.makeDifferentExternal();
                    }
                    f1[i4] = new formal(v);
                    ++i4;
                }
                f = f1;
            }
            formalTab.put(aName, f);
        }
        return formalTab;
    }

    private static boolean formalsClash(formal[] actionFormals, HashSet<String> compositeVars) {
        int i = 0;
        while (i < actionFormals.length) {
            if (actionFormals[i].kind() != formal.kind.VAR) {
                throw new InternalError("composition.formalsClash");
            }
            if (compositeVars.contains(actionFormals[i].var().toString().intern())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static action[] actions(component[] components, actionSet[] hiddens) {
        Hashtable<String, actionTable> actionTables = new Hashtable<String, actionTable>();
        boolean nextIndex = false;
        int i = 0;
        while (i < components.length) {
            component c = components[i];
            automaton aut = c.expandedAutomaton();
            if (aut == null) {
                throw new InternalError("composition:actions");
            }
            int k = 0;
            while (k < aut.nActions()) {
                action a = aut.action(k);
                actionTable at = (actionTable)actionTables.get(a.name());
                if (at == null) {
                    at = new actionTable(a.name());
                    actionTables.put(a.name(), at);
                }
                at.addAction(a, c);
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < hiddens.length) {
            actionTable at = (actionTable)actionTables.get(hiddens[i].name());
            if (at == null) {
                throw new InternalError("composition:actions");
            }
            at.addHidden(hiddens[i]);
            ++i;
        }
        int nActions = 0;
        Enumeration e = actionTables.elements();
        while (e.hasMoreElements()) {
            actionTable at = (actionTable)e.nextElement();
            nActions += at.composeActions(nActions);
        }
        action[] actions2 = new action[nActions];
        Enumeration e2 = actionTables.elements();
        while (e2.hasMoreElements()) {
            actionTable at = (actionTable)e2.nextElement();
            action.kinds[] kindsArray = action.kinds.values();
            int n = 0;
            int n2 = kindsArray.length;
            while (n < n2) {
                action.kinds kind2 = kindsArray[n];
                if (at.hasKind(kind2)) {
                    actions2[at.action4Kind((action.kinds)kind2).index()] = at.action4Kind(kind2);
                }
                ++n;
            }
        }
        return actions2;
    }

    private static task[] tasks(component[] components) {
        return new task[0];
    }

    public automaton desugar() {
        throw new InternalError("composition.desugar");
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.align();
        if (Options.components()) {
            int i = 0;
            while (i < this.nComponents()) {
                if (this.components[i].expandedAutomaton() != null) {
                    pp.align(0).print(this.components[i].expandedAutomaton()).eol().end();
                }
                ++i;
            }
        }
        pp.end();
        pp.align();
        pp.fill().put("automaton").blank();
        if (this.nFormals() == 0) {
            pp.put(this.name());
        } else {
            pp.fill().print(this.name()).blank(0);
            formal.print(pp, this.formals, this.formalFactors).end();
        }
        pp.end().eol();
        if (this.vocab.length > 0) {
            pp.fill().put("imports").blank().list(this.vocab, ",").end().eol();
        }
        pp = Options.expand() ? super.printThisKindOfAutomaton(pp) : this.printThisKindOfAutomaton(pp);
        return pp.end();
    }

    @Override
    protected prettyprinter printThisKindOfAutomaton(prettyprinter pp) {
        pp.fill().put("components").eol().blist(this.components, ";").end().eol();
        if (this.hiddens.length > 0) {
            pp.fill().put("hidden").eol().blist(this.hiddens, ",").end().eol();
        }
        if (this.schedule() != null) {
            pp.eol();
        }
        pp.fill().print(this.schedule()).end();
        return pp;
    }

    @Override
    public SValue toSValue() {
        SList list = (SList)super.toSValue();
        if (Options.components()) {
            int i = 0;
            while (i < this.nComponents()) {
                list.add(this.component(i).expandedAutomaton().toSValue());
                ++i;
            }
        }
        if (Options.expand()) {
            list.add(super.thisKindOfAutomatonToSValue());
        }
        return list;
    }

    @Override
    protected SValue thisKindOfAutomatonToSValue() {
        SList componentList = SExp.makeSList(SExp.makeSValue("compose"));
        int i = 0;
        while (i < this.components.length) {
            componentList.add(this.components[i].toSValue());
            ++i;
        }
        SList list = SExp.makeSList(componentList);
        if (this.hiddens != null) {
            SList hiddenList = SExp.makeSList(SExp.makeSValue("hidden"));
            int i2 = 0;
            while (i2 < this.hiddens.length) {
                hiddenList.add(this.hiddens[i2].toSValue());
                ++i2;
            }
            list.add(hiddenList);
        }
        if (this.schedule() != null) {
            list.add(this.schedule().toSValue());
        }
        return list;
    }
}

