/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.actionKey;
import com.veromodo.tioa.automaton.actionPattern;
import com.veromodo.tioa.automaton.assignment;
import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.automaton.component;
import com.veromodo.tioa.automaton.conditional;
import com.veromodo.tioa.automaton.loop;
import com.veromodo.tioa.automaton.ndrfire;
import com.veromodo.tioa.automaton.ndrwhile;
import com.veromodo.tioa.automaton.ndryield;
import com.veromodo.tioa.automaton.program;
import com.veromodo.tioa.automaton.simfire;
import com.veromodo.tioa.automaton.statement;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.automaton.transitionPattern;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Hashtable;

public class composer {
    private boolean expandable = true;
    private Hashtable<actionKey, actionPattern> actionPatterns;
    private String errorString = "";
    static /* synthetic */ Class class$0;

    public boolean isExpandable() {
        return this.expandable;
    }

    private void appendToErrorMessage(String s) {
        this.errorString = String.valueOf(this.errorString) + s + "\n";
    }

    public String errorString() {
        return this.errorString;
    }

    private boolean checkAutomatonParameters(String cname, automaton a) {
        boolean ok = true;
        int i = 0;
        while (i < a.nFormals()) {
            if (a.formal(i).kind() == formal.kind.TYPE) {
                this.appendToErrorMessage("Component " + cname + " has TYPE parameter(s).");
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    private boolean checkSignature(String cname, automaton A) {
        boolean ok = true;
        int i = 0;
        while (i < A.nActions()) {
            action a = A.action(i);
            int j = 0;
            while (i < a.nFormals()) {
                if (a.formal(j).kind() == formal.kind.CONST) {
                    this.appendToErrorMessage(String.valueOf(a.kindAsString()) + " action " + a.name() + " in component " + cname + " has CONST parameter " + a.formal(j).constant());
                    ok = false;
                }
                ++j;
            }
            ++i;
        }
        return ok;
    }

    private boolean checkTransitions(String cname, automaton A) {
        boolean ok = true;
        Hashtable<String, EnumSet<action.kinds>> transitions = new Hashtable<String, EnumSet<action.kinds>>();
        int i = 0;
        while (i < A.nTransitions()) {
            transition T = A.transition(i);
            action a = T.theAction();
            EnumSet<action.kinds> kinds2 = (EnumSet<action.kinds>)transitions.get(a.name());
            if (kinds2 == null) {
                kinds2 = EnumSet.allOf(action.kinds.class);
                kinds2.contains((Object)a.kind());
                transitions.put(a.name(), kinds2);
            } else if (kinds2.contains((Object)a.kind())) {
                this.appendToErrorMessage("component " + cname + " has more then one transition for " + a.kindAsString() + " action " + a.name());
                ok = false;
            } else {
                kinds2.add(a.kind());
            }
            ++i;
        }
        return ok;
    }

    private boolean checkSignatureParameters(String cname, automaton A) {
        boolean ok = true;
        int i = 0;
        while (i < A.nActions()) {
            action a = A.action(i);
            actionKey key = new actionKey(a);
            actionPattern ap = this.actionPatterns.get(key);
            if (ap == null) {
                this.actionPatterns.put(key, new actionPattern(cname, a));
            } else if (!ap.matches(a)) {
                this.appendToErrorMessage("parameters for " + a.kindAsString() + " action " + a.name() + " in component " + cname + " do not match those in component " + ap.componentName());
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    private boolean checkTransitionParameters(String cname, automaton A) {
        boolean ok = true;
        Hashtable<String, transitionPattern> transitions = new Hashtable<String, transitionPattern>();
        int i = 0;
        while (i < A.nTransitions()) {
            transitionPattern tp;
            transition t = A.transition(i);
            action a = t.theAction();
            actionKey key = new actionKey(a);
            actionPattern ap = this.actionPatterns.get(key);
            if (ap == null) {
                throw new InternalError("composer.checkTransitionParameters");
            }
            if (!ap.matches(t)) {
                this.appendToErrorMessage("actual parameters of transition " + a.kindAsString() + " " + a.name() + " do not match those of its action in component " + cname);
                ok = false;
            }
            if ((tp = (transitionPattern)transitions.get(a.name())) == null) {
                transitions.put(a.name(), new transitionPattern(t));
            } else if (!tp.matches(t)) {
                this.appendToErrorMessage("transition " + a.kindAsString() + " " + a.name() + " of component " + cname + " " + "has different local variables from those " + "of transition " + tp.kind + " " + tp.name);
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    private boolean checkVariableRef(String cname, automaton A) {
        transition t;
        boolean ok = true;
        BitSet kinds2 = new BitSet();
        kinds2.set(2);
        int i = 0;
        while (i < A.nActions()) {
            action a = A.action(i);
            ok &= this.checkTerm("action " + a.name() + " in the signature of " + A.name(), a.where(), kinds2);
            ++i;
        }
        kinds2.clear(2);
        kinds2.set(1);
        kinds2.set(3);
        kinds2.set(8);
        kinds2.set(7);
        kinds2.set(15);
        i = 0;
        while (i < A.nTransitions()) {
            t = A.transition(i);
            ok &= this.checkTerm("transition " + t.theAction().name() + " of component " + A.name(), t.where(), kinds2);
            int j = 0;
            while (j < t.nPreconditions()) {
                ok &= this.checkTerm("preconditions of transition " + t.theAction().name() + " of component " + A.name(), t.pre(j), kinds2);
                ++j;
            }
            program p = t.effects();
            if (p != null) {
                ok &= this.checkProgram(String.valueOf(A.name()) + " transition body", p, kinds2);
            }
            ++i;
        }
        kinds2.set(4);
        kinds2.set(9);
        i = 0;
        while (i < A.nTransitions()) {
            t = A.transition(i);
            ok &= this.checkTerm("ensuring of transition " + t.theAction().name() + " of component " + A.name(), t.ensuring(), kinds2);
            ++i;
        }
        return ok;
    }

    private boolean checkProgram(String name, program p, BitSet kinds2) {
        boolean ok = true;
        int i = 0;
        while (i < p.nStatements()) {
            statement s = p.statement(i);
            switch (s.kind()) {
                case 1: {
                    assignment ass = (assignment)s;
                    ok &= this.checkTerm("assignment in " + name, ass.lhs(), kinds2);
                    if (ass.rhs().isTerm()) {
                        ok &= this.checkTerm("assignment in " + name, ass.rhs().term(), kinds2);
                    } else {
                        variable v = ass.rhs().chooseVar();
                        if (!kinds2.get(v.kind())) {
                            this.appendToErrorMessage("unexpected kind of variable found in " + name);
                        }
                    }
                    ass = null;
                    break;
                }
                case 2: {
                    loop lup = (loop)s;
                    ok &= this.checkTerm("loop in " + name, lup.term(), kinds2);
                    if (!kinds2.get(lup.var().kind())) {
                        this.appendToErrorMessage("unexpected kind of variable found in " + name);
                    }
                    lup = null;
                    break;
                }
                case 3: {
                    conditional cond = (conditional)s;
                    int j = 0;
                    while (j < cond.nIfs()) {
                        ok &= this.checkTerm("if predicate in " + name, cond.predicate(j), kinds2);
                        ok &= this.checkProgram(name, cond.thenClause(0), kinds2);
                        ++j;
                    }
                    ok &= this.checkProgram(name, cond.elseClause(), kinds2);
                    cond = null;
                    break;
                }
                case 4: {
                    ndryield yie = (ndryield)s;
                    ok &= this.checkTerm("yield statement in " + name, yie.yield(), kinds2);
                    yie = null;
                    break;
                }
                case 5: {
                    ndrwhile whi = (ndrwhile)s;
                    ok &= this.checkTerm("while statement in " + name, whi.predicate(), kinds2);
                    ok &= this.checkProgram(name, whi.whileClause(), kinds2);
                    whi = null;
                    break;
                }
                case 6: {
                    ndrfire fir = (ndrfire)s;
                    int j = 0;
                    while (j < fir.nActuals()) {
                        ok &= this.checkTerm("fire statement in " + name + " case " + fir.caseName(), fir.actual(j), kinds2);
                        ++j;
                    }
                    fir = null;
                    break;
                }
                case 7: {
                    simfire sim = (simfire)s;
                    int j = 0;
                    while (j < sim.nActuals()) {
                        ok &= this.checkTerm("simulation fire statement in " + name, sim.actual(j), kinds2);
                        ++j;
                    }
                    sim = null;
                }
            }
            ++i;
        }
        return ok;
    }

    private boolean checkInitially(String cname, automaton A) {
        BitSet kinds2 = new BitSet();
        kinds2.set(1);
        kinds2.set(3);
        kinds2.set(5);
        return this.checkTerm("initially of component " + cname, A.initially(), kinds2);
    }

    private boolean checkTerm(String name, term t, BitSet kinds2) {
        for (variable v : t.freeVars()) {
            if (kinds2.get(v.kind())) continue;
            this.appendToErrorMessage("Unexpected kind of variable found in " + name);
            return false;
        }
        return true;
    }

    public composer(component[] c) {
        int i = 0;
        while (i < c.length) {
            String name = c[i].name();
            automaton A = c[i].baseAutomaton();
            this.expandable &= this.checkAutomatonParameters(name, A);
            this.expandable &= this.checkSignature(name, A);
            this.expandable &= this.checkTransitions(name, A);
            this.expandable &= this.checkSignatureParameters(name, A);
            this.expandable &= this.checkTransitionParameters(name, A);
            this.expandable &= this.checkVariableRef(name, A);
            this.expandable &= this.checkInitially(name, A);
            ++i;
        }
    }
}

