/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.automaton.resorting;
import com.veromodo.tioa.automaton.stateVariable;
import com.veromodo.tioa.automaton.varMap;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.substitution;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.Vector;

public class component
extends Unit
implements SPrintable {
    private String name;
    protected variable[] formals;
    private sort[] formalSorts;
    private factoring formalFactors;
    private automaton baseAutomaton;
    private automaton resortedAutomaton;
    private automaton expandedAutomaton;
    private term[] actuals;
    private term where;
    private term initially;
    private resorting sortMap;
    private varMap expanMap;

    public String name() {
        return this.name;
    }

    public int nFormals() {
        return this.formals.length;
    }

    public variable formal(int i) {
        return this.formals[i];
    }

    public automaton baseAutomaton() {
        return this.baseAutomaton;
    }

    public automaton resortedAutomaton() {
        return this.resortedAutomaton;
    }

    public automaton expandedAutomaton() {
        return this.expandedAutomaton;
    }

    public int nActuals() {
        return this.actuals.length;
    }

    public term actual(int n) {
        return this.actuals[n];
    }

    public term where() {
        return this.where;
    }

    protected term initially(variable statesVar, Context x) {
        if (this.initially == null) {
            this.initially = this.makeInitially(statesVar, x);
        }
        return this.initially;
    }

    public resorting sortMap() {
        return this.sortMap;
    }

    public component(variable parentState, String name, variable[] formals, factoring formalFactors, automaton baseAutomaton, term[] autActuals, term where, resorting sortMap) {
        this.name = name;
        this.formals = formals;
        this.formalSorts = new sort[formals.length];
        int i = 0;
        while (i < formals.length) {
            this.formalSorts[i] = formals[i].sort();
            ++i;
        }
        this.formalFactors = formalFactors;
        this.where = where == null ? booleans.trueTerm : where;
        this.baseAutomaton = baseAutomaton;
        this.actuals = autActuals;
        this.sortMap = sortMap == null ? (resorting)resorting.theIdentity() : sortMap;
    }

    private term makeAggregateTerm(variable av) {
        if (this.nFormals() == 0) {
            return new term(av);
        }
        term[] args = new term[this.nFormals() + 1];
        args[0] = new term(av);
        int i = 0;
        while (i < this.nFormals()) {
            args[i + 1] = new term(this.formals[i]);
            ++i;
        }
        opSym op = opSym.bracketOp(true, this.nFormals(), false);
        signature sig = new signature(av.sort().subsort(this.nFormals()), this.formalSorts);
        return new term(new operator(op, sig), args);
    }

    private term makeInitially(variable statesVar, Context x) {
        boolean nondet = false;
        automaton a = this.expandedAutomaton;
        term initially = new term(a.initially());
        term[] eqArgs = new term[2];
        Vector<variable> existentials = new Vector<variable>();
        int i = 0;
        while (i < a.nStateVariables()) {
            block9: {
                operator eqOp;
                block11: {
                    stateVariable s;
                    block10: {
                        term varTerm;
                        s = a.stateVariable(i);
                        if (s.initialValue() == null) break block9;
                        eqOp = operator.eqOp(s.variable().sort());
                        term[] varArgs = new term[]{this.makeAggregateTerm(statesVar)};
                        eqArgs[0] = varTerm = new term(s.selector(), varArgs);
                        if (!s.initialValue().isTerm()) break block10;
                        eqArgs[1] = s.initialValue().term();
                        break block11;
                    }
                    if (s.initialValue().where() == null) break block9;
                    eqArgs[1] = new term(s.initialValue().chooseVar());
                    existentials.addElement(s.initialValue().chooseVar());
                    initially = booleans.conjoin(initially, s.initialValue().where());
                }
                initially = booleans.conjoin(initially, new term(eqOp, eqArgs));
            }
            ++i;
        }
        Enumeration e = existentials.elements();
        while (e.hasMoreElements()) {
            initially = new term(new quantifier(quantifier.EXISTS, (variable)e.nextElement()), initially);
        }
        initially = booleans.imply(this.where, initially);
        if (this.nFormals() == 0) {
            return initially;
        }
        sort[] dom = new sort[this.nFormals() + 1];
        term[] defArgs = new term[this.nFormals() + 1];
        dom[0] = statesVar.sort();
        defArgs[0] = new term(statesVar);
        int i2 = 0;
        while (i2 < this.nFormals()) {
            dom[i2 + 1] = this.formal(i2).sort();
            defArgs[i2 + 1] = new term(this.formal(i2));
            ++i2;
        }
        operator defOp = new operator(new opSym(1, "defined"), new signature(sort.boolSort, dom));
        term[] implArgs = new term[]{this.where, new term(defOp, defArgs)};
        initially = booleans.conjoin(initially, new term(booleans.iffOp, implArgs));
        substitution s = new substitution();
        variable[] qVars = new variable[this.formals.length];
        int i3 = 0;
        while (i3 < this.formals.length) {
            qVars[i3] = new variable(this.formals[i3].id(), this.formals[i3].sort(), 15);
            s.add(this.formals[i3], qVars[i3]);
            ++i3;
        }
        initially = s.map(initially);
        i3 = 0;
        while (i3 < qVars.length) {
            initially = new term(new quantifier(quantifier.ALL, qVars[i3]), initially);
            ++i3;
        }
        return simplify.iterate(initially, x);
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill().print(this.name);
        if (this.formals.length > 0) {
            pp.blank(0).fill(1).put("[").list(this.formals, ",").put("]").end();
        }
        boolean abbr = true;
        abbr &= this.name.equals(this.baseAutomaton.name());
        abbr &= this.formals.length == this.actuals.length;
        int i = 0;
        while (abbr && i < this.formals.length) {
            if (this.actuals[i].kind() != 2 || !this.formals[i].equals(this.actuals[i].var())) {
                abbr = false;
            }
            ++i;
        }
        if (!abbr && this.actuals.length > 0) {
            pp.put(" ").print(":").blank();
            pp.fill().print(this.baseAutomaton.name());
            pp.blank(0).fill(1).put("(").list(this.actuals, ",").put(")").end().end();
        }
        if (!this.where.isTrue()) {
            pp.blank().fill(1).print("where").blank().print(this.where()).end();
        }
        return pp.end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue(this.name()));
        SList formalsList = SExp.makeSList(SExp.makeSValue("formals"));
        int a = 0;
        while (a < this.nFormals()) {
            formalsList.add(this.formals[a].toSValue());
            ++a;
        }
        if (formalsList.size() > 1) {
            list.add(formalsList);
        }
        if (!this.name.equals(this.baseAutomaton.name())) {
            list.add(SExp.makeSValue(this.baseAutomaton.name()));
        }
        SList actualsList = SExp.makeSList(SExp.makeSValue("actuals"));
        int i = 0;
        while (i < this.nActuals()) {
            actualsList.add(this.actuals[i].toSValue());
            ++i;
        }
        actualsList.add(this.where.toSValue());
        list.add(actualsList);
        return list;
    }
}

